/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.logger.Logger;

public class PropertiesModule
implements Module {
    private static final Logger log = new Logger(PropertiesModule.class);
    private final List<String> propertiesFiles;

    public PropertiesModule(List<String> propertiesFiles) {
        this.propertiesFiles = propertiesFiles;
    }

    public void configure(Binder binder) {
        Properties fileProps = new Properties();
        Properties systemProps = System.getProperties();
        Properties props = new Properties(fileProps);
        props.putAll((Map<?, ?>)systemProps);
        for (String propertiesFile : this.propertiesFiles) {
            try {
                InputStream stream = PropertiesModule.openPropertiesFile(propertiesFile, systemProps);
                try {
                    if (stream == null) continue;
                    log.debug("Loading properties from %s", propertiesFile);
                    try (InputStreamReader in = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                        fileProps.load(in);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        binder.bind(Properties.class).toInstance((Object)props);
    }

    @Nullable
    private static InputStream openPropertiesFile(String propertiesFile, Properties systemProps) throws IOException {
        InputStream stream = ClassLoader.getSystemResourceAsStream(propertiesFile);
        if (stream != null) {
            return stream;
        }
        File workingDirectoryFile = new File(systemProps.getProperty("druid.properties.file", propertiesFile));
        if (workingDirectoryFile.exists()) {
            return new BufferedInputStream(new FileInputStream(workingDirectoryFile));
        }
        return null;
    }
}

