/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import io.netty.util.SuppressForbidden;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.druid.java.util.common.guava.Comparators;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class DateTimes {
    public static final DateTime EPOCH = DateTimes.utc(0L);
    public static final DateTime MAX = DateTimes.utc(0x3FFFFFFFFFFFFFFFL);
    public static final DateTime MIN = DateTimes.utc(-4611686018427387904L);
    public static final DateTime COMPARE_DATE_AS_STRING_MIN = DateTimes.of("0000-01-01");
    public static final DateTime COMPARE_DATE_AS_STRING_MAX = DateTimes.of("10000-01-01").minus(1L);
    public static final UtcFormatter ISO_DATE_TIME = DateTimes.wrapFormatter(ISODateTimeFormat.dateTime());
    public static final UtcFormatter ISO_DATE_OPTIONAL_TIME = DateTimes.wrapFormatter(ISODateTimeFormat.dateOptionalTimeParser());
    public static final UtcFormatter ISO_DATE_OR_TIME_WITH_OFFSET = DateTimes.wrapFormatter(ISODateTimeFormat.dateTimeParser().withOffsetParsed());
    private static final Set<String> AVAILABLE_TIMEZONE_IDS = ImmutableSet.copyOf((Object[])TimeZone.getAvailableIDs());
    public static final Pattern COMMON_DATE_TIME_PATTERN = Pattern.compile("[0-9]{4}-[01][0-9]-[0-3][0-9]T[0-2][0-9]:[0-5][0-9]:[0-5][0-9]\\.[0-9]{3}(Z|[+\\-][0-9]{2}(:[0-9]{2}))");

    public static DateTimeZone inferTzFromString(String tzId) {
        return DateTimes.inferTzFromString(tzId, true);
    }

    @SuppressForbidden(reason="DateTimeZone#forID")
    public static DateTimeZone inferTzFromString(String tzId, boolean fallback) throws IllegalArgumentException {
        try {
            return DateTimeZone.forID((String)tzId);
        }
        catch (IllegalArgumentException e) {
            if (!fallback && !AVAILABLE_TIMEZONE_IDS.contains(tzId)) {
                throw e;
            }
            return DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(tzId));
        }
    }

    public static UtcFormatter wrapFormatter(DateTimeFormatter formatter) {
        return new UtcFormatter(formatter);
    }

    public static DateTime utc(long instant) {
        return new DateTime(instant, (Chronology)ISOChronology.getInstanceUTC());
    }

    public static DateTime of(String instant) {
        try {
            return new DateTime((Object)instant, (Chronology)ISOChronology.getInstanceUTC());
        }
        catch (IllegalArgumentException ex) {
            try {
                return new DateTime((Object)Long.valueOf(instant), (Chronology)ISOChronology.getInstanceUTC());
            }
            catch (IllegalArgumentException ex2) {
                throw ex;
            }
        }
    }

    public static DateTime of(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour) {
        return new DateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, (Chronology)ISOChronology.getInstanceUTC());
    }

    public static DateTime nowUtc() {
        return DateTime.now((Chronology)ISOChronology.getInstanceUTC());
    }

    public static DateTime max(DateTime dt1, DateTime dt2) {
        return dt1.compareTo((ReadableInstant)dt2) >= 0 ? dt1 : dt2;
    }

    public static DateTime min(DateTime dt1, DateTime dt2) {
        return dt1.compareTo((ReadableInstant)dt2) < 0 ? dt1 : dt2;
    }

    public static int subMonths(long timestamp1, long timestamp2, DateTimeZone timeZone) {
        DateTime time1 = new DateTime(timestamp1, timeZone);
        DateTime time2 = new DateTime(timestamp2, timeZone);
        return Months.monthsBetween((ReadableInstant)time1, (ReadableInstant)time2).getMonths();
    }

    public static boolean canCompareAsString(DateTime dateTime) {
        return dateTime.getMillis() >= COMPARE_DATE_AS_STRING_MIN.getMillis() && dateTime.getMillis() <= COMPARE_DATE_AS_STRING_MAX.getMillis() && ISOChronology.getInstanceUTC().equals((Object)dateTime.getChronology());
    }

    public static DateTime earlierOf(DateTime a, DateTime b) {
        if (Objects.compare(a, b, Ordering.natural().nullsLast()) < 0) {
            return a;
        }
        return b;
    }

    public static DateTime laterOf(DateTime a, DateTime b) {
        if (Objects.compare(a, b, Comparators.naturalNullsFirst()) > 0) {
            return a;
        }
        return b;
    }

    private DateTimes() {
    }

    public static class UtcFormatter {
        private final DateTimeFormatter innerFormatter;

        private UtcFormatter(DateTimeFormatter innerFormatter) {
            this.innerFormatter = innerFormatter.withChronology((Chronology)ISOChronology.getInstanceUTC());
        }

        @SuppressForbidden(reason="DateTimeFormatter#parseDateTime")
        public DateTime parse(String instant) {
            return this.innerFormatter.parseDateTime(instant);
        }

        public String print(DateTime instant) {
            return this.innerFormatter.print((ReadableInstant)instant);
        }
    }
}

