/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import java.io.IOException;
import org.apache.druid.java.util.common.guava.SequenceWrapper;
import org.apache.druid.java.util.common.guava.Yielder;

final class WrappingYielder<OutType>
implements Yielder<OutType> {
    private Yielder<OutType> baseYielder;
    private final SequenceWrapper wrapper;

    WrappingYielder(Yielder<OutType> baseYielder, SequenceWrapper wrapper) {
        this.baseYielder = baseYielder;
        this.wrapper = wrapper;
    }

    @Override
    public OutType get() {
        return this.baseYielder.get();
    }

    @Override
    public Yielder<OutType> next(final OutType initValue) {
        try {
            return (Yielder)this.wrapper.wrap(new Supplier<Yielder<OutType>>(){

                public Yielder<OutType> get() {
                    WrappingYielder.this.baseYielder = WrappingYielder.this.baseYielder.next(initValue);
                    return WrappingYielder.this;
                }
            });
        }
        catch (Throwable t) {
            try {
                this.wrapper.after(false, t);
            }
            catch (Exception e) {
                t.addSuppressed(e);
            }
            Throwables.propagateIfPossible((Throwable)t);
            throw new RuntimeException(t);
        }
    }

    @Override
    public boolean isDone() {
        return this.baseYielder.isDone();
    }

    @Override
    public void close() throws IOException {
        boolean isDone;
        try {
            isDone = this.isDone();
            this.baseYielder.close();
        }
        catch (Throwable t) {
            try {
                this.wrapper.after(false, t);
            }
            catch (Exception e) {
                t.addSuppressed(e);
            }
            Throwables.propagateIfInstanceOf((Throwable)t, IOException.class);
            Throwables.propagateIfPossible((Throwable)t);
            throw new RuntimeException(t);
        }
        try {
            this.wrapper.after(isDone, null);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, IOException.class);
            Throwables.propagateIfPossible((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

