/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.Exprs;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.UnivariateVectorProcessorFactory;

public abstract class VectorMathUnivariateDoubleProcessorFactory
implements UnivariateVectorProcessorFactory {
    @Override
    public <T> ExprVectorProcessor<T> asProcessor(Expr.VectorInputBindingInspector inspector, Expr arg) {
        ExpressionType inputType = arg.getOutputType(inspector);
        ExprVectorProcessor<double[]> processor = null;
        if (inputType != null) {
            if (inputType.is(ExprType.LONG)) {
                processor = this.longProcessor(inspector, arg);
            } else if (inputType.is(ExprType.DOUBLE)) {
                processor = this.doubleProcessor(inspector, arg);
            }
        } else {
            processor = this.doubleProcessor(inspector, arg);
        }
        if (processor == null) {
            throw Exprs.cannotVectorize();
        }
        return processor;
    }

    public abstract ExprVectorProcessor<double[]> longProcessor(Expr.VectorInputBindingInspector var1, Expr var2);

    public abstract ExprVectorProcessor<double[]> doubleProcessor(Expr.VectorInputBindingInspector var1, Expr var2);
}

