/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseNullableColumnValueSelector;

public final class NullableNumericBufferAggregator
implements BufferAggregator {
    private final BufferAggregator delegate;
    private final BaseNullableColumnValueSelector nullSelector;

    public NullableNumericBufferAggregator(BufferAggregator delegate, BaseNullableColumnValueSelector nullSelector) {
        this.delegate = delegate;
        this.nullSelector = nullSelector;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.put(position, (byte)1);
        this.delegate.init(buf, position + 1);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        boolean isNotNull;
        boolean bl = isNotNull = !this.nullSelector.isNull();
        if (isNotNull) {
            if (buf.get(position) == 1) {
                buf.put(position, (byte)0);
            }
            this.delegate.aggregate(buf, position + 1);
        }
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        if (buf.get(position) == 1) {
            return null;
        }
        return this.delegate.get(buf, position + 1);
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        if (buf.get(position) == 1) {
            throw new IllegalStateException("Cannot return float for Null Value");
        }
        return this.delegate.getFloat(buf, position + 1);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        if (buf.get(position) == 1) {
            throw new IllegalStateException("Cannot return long for Null Value");
        }
        return this.delegate.getLong(buf, position + 1);
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        if (buf.get(position) == 1) {
            throw new IllegalStateException("Cannot return double for Null Value");
        }
        return this.delegate.getDouble(buf, position + 1);
    }

    @Override
    public boolean isNull(ByteBuffer buf, int position) {
        return buf.get(position) == 1 || this.delegate.isNull(buf, position + 1);
    }

    @Override
    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        this.delegate.relocate(oldPosition + 1, newPosition + 1, oldBuffer, newBuffer);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("delegate", this.delegate);
        inspector.visit("nullSelector", this.nullSelector);
    }
}

