/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import javax.annotation.Nullable;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.math.expr.Expr;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.chrono.ISOChronology;

public class ExprUtils {
    static DateTimeZone toTimeZone(Expr timeZoneArg) {
        if (!timeZoneArg.isLiteral()) {
            throw new IAE("Time zone must be a literal", new Object[0]);
        }
        Object literalValue = timeZoneArg.getLiteralValue();
        return literalValue == null ? DateTimeZone.UTC : DateTimes.inferTzFromString((String)literalValue);
    }

    static PeriodGranularity toPeriodGranularity(Expr wrappingExpr, Expr periodArg, @Nullable Expr originArg, @Nullable Expr timeZoneArg, Expr.ObjectBinding bindings) {
        DateTime origin;
        DateTimeZone timeZone;
        Period period;
        try {
            period = new Period((Object)periodArg.eval(bindings).asString());
        }
        catch (IllegalArgumentException iae) {
            throw InvalidInput.exception("Invalid period[%s] specified for expression[%s]: [%s]", periodArg.stringify(), wrappingExpr.stringify(), iae.getMessage());
        }
        if (timeZoneArg == null) {
            timeZone = null;
        } else {
            String value = timeZoneArg.eval(bindings).asString();
            DateTimeZone dateTimeZone = timeZone = value != null ? DateTimes.inferTzFromString(value) : null;
        }
        if (originArg == null) {
            origin = null;
        } else {
            ISOChronology chronology = timeZone == null ? ISOChronology.getInstanceUTC() : ISOChronology.getInstance(timeZone);
            Object value = originArg.eval(bindings).value();
            origin = value != null ? new DateTime(value, (Chronology)chronology) : null;
        }
        return new PeriodGranularity(period, origin, timeZone);
    }

    static boolean isStringLiteral(Expr expr) {
        return expr.isLiteral() && expr.getLiteralValue() instanceof String;
    }
}

