/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter.vector;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.VectorObjectSelector;

public class MultiValueStringObjectVectorValueMatcher
implements VectorValueMatcherFactory {
    protected final VectorObjectSelector selector;

    public MultiValueStringObjectVectorValueMatcher(VectorObjectSelector selector) {
        this.selector = selector;
    }

    @Override
    public VectorValueMatcher makeMatcher(final @Nullable String value) {
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[MultiValueStringObjectVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                Object[] vector = MultiValueStringObjectVectorValueMatcher.this.selector.getObjectVector();
                int[] selection = this.match.getSelection();
                int numRows = 0;
                block0: for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    Object val = vector[rowNum];
                    if (val instanceof List) {
                        for (Object o : (List)val) {
                            if ((o != null || !includeUnknown) && !Objects.equals(value, o)) continue;
                            selection[numRows++] = rowNum;
                            continue block0;
                        }
                        continue;
                    }
                    if ((val != null || !includeUnknown) && !Objects.equals(value, val)) continue;
                    selection[numRows++] = rowNum;
                }
                this.match.setSelectionSize(numRows);
                return this.match;
            }
        };
    }

    @Override
    public VectorValueMatcher makeMatcher(Object matchValue, ColumnType matchValueType) {
        ExprEval<?> eval = ExprEval.ofType(ExpressionType.fromColumnType(matchValueType), matchValue);
        ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(eval, ExpressionType.STRING);
        if (castForComparison == null || castForComparison.asString() == null) {
            return VectorValueMatcher.allFalseObjectMatcher(this.selector);
        }
        return this.makeMatcher(castForComparison.asString());
    }

    @Override
    public VectorValueMatcher makeMatcher(DruidPredicateFactory predicateFactory) {
        final DruidObjectPredicate<String> predicate = predicateFactory.makeStringPredicate();
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[MultiValueStringObjectVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                Object[] vector = MultiValueStringObjectVectorValueMatcher.this.selector.getObjectVector();
                int[] selection = this.match.getSelection();
                int numRows = 0;
                block0: for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    Object val = vector[rowNum];
                    if (val instanceof List) {
                        for (Object o : (List)val) {
                            if (!predicate.apply((String)o).matches(includeUnknown)) continue;
                            selection[numRows++] = rowNum;
                            continue block0;
                        }
                        continue;
                    }
                    if (!predicate.apply((String)val).matches(includeUnknown)) continue;
                    selection[numRows++] = rowNum;
                }
                this.match.setSelectionSize(numRows);
                return this.match;
            }
        };
    }
}

