/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.segment.DefaultColumnFormatConfig;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.NestedCommonFormatColumnHandler;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.nested.NestedCommonFormatColumnFormatSpec;

public class NestedDataColumnSchema
extends DimensionSchema {
    final int formatVersion;
    @Nullable
    final NestedCommonFormatColumnFormatSpec columnFormatSpec;

    @JsonCreator
    public NestedDataColumnSchema(@JsonProperty(value="name") String name, @JsonProperty(value="formatVersion") @Nullable Integer version, @JsonProperty(value="columnFormatSpec") @Nullable NestedCommonFormatColumnFormatSpec columnFormatSpec, @JacksonInject DefaultColumnFormatConfig defaultFormatConfig) {
        super(name, null, true);
        this.formatVersion = version != null ? version : (defaultFormatConfig.getNestedColumnFormatVersion() != null ? defaultFormatConfig.getNestedColumnFormatVersion() : 5);
        DefaultColumnFormatConfig.validateNestedFormatVersion(this.formatVersion);
        this.columnFormatSpec = columnFormatSpec == null ? (defaultFormatConfig.getIndexSpec() != null ? defaultFormatConfig.getIndexSpec().getAutoColumnFormatSpec() : IndexSpec.getDefault().getAutoColumnFormatSpec()) : columnFormatSpec;
    }

    public NestedDataColumnSchema(String name, int version) {
        super(name, null, true);
        this.formatVersion = version;
        DefaultColumnFormatConfig.validateNestedFormatVersion(this.formatVersion);
        this.columnFormatSpec = IndexSpec.getDefault().getAutoColumnFormatSpec();
    }

    @JsonProperty(value="formatVersion")
    public int getFormatVersion() {
        return this.formatVersion;
    }

    @JsonProperty(value="columnFormatSpec")
    public NestedCommonFormatColumnFormatSpec getColumnFormatSpec() {
        return this.columnFormatSpec;
    }

    @Override
    public String getTypeName() {
        return "json";
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.NESTED_DATA;
    }

    @Override
    public DimensionHandler getDimensionHandler() {
        return new NestedCommonFormatColumnHandler(this.getName(), null, this.columnFormatSpec);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NestedDataColumnSchema that = (NestedDataColumnSchema)o;
        return Objects.equals(this.formatVersion, that.formatVersion) && Objects.equals(this.columnFormatSpec, that.columnFormatSpec);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.formatVersion, this.columnFormatSpec);
    }

    @Override
    public String toString() {
        return "NestedDataColumnSchema{formatVersion=" + this.formatVersion + "columnFormatSpec=" + String.valueOf(this.columnFormatSpec) + "}";
    }
}

