/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SimpleTopNOptimizationInspector;
import org.apache.druid.segment.TopNOptimizationInspector;
import org.apache.druid.segment.UnnestCursorFactory;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.WrappedSegment;

public class UnnestSegment
extends WrappedSegment {
    private final VirtualColumn unnestColumn;
    @Nullable
    private final DimFilter filter;

    public UnnestSegment(Segment delegate, VirtualColumn unnestColumn, @Nullable DimFilter filter) {
        super(delegate);
        this.unnestColumn = unnestColumn;
        this.filter = filter;
    }

    @Override
    @Nullable
    public <T> T as(@Nonnull Class<T> clazz) {
        if (CursorFactory.class.equals(clazz)) {
            return (T)new UnnestCursorFactory(this.delegate.as(CursorFactory.class), this.unnestColumn, this.filter);
        }
        if (TopNOptimizationInspector.class.equals(clazz)) {
            return (T)new SimpleTopNOptimizationInspector(this.filter == null);
        }
        return null;
    }

    @Override
    public String getDebugString() {
        return "unnest->" + this.delegate.getDebugString();
    }
}

