/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.lookup;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.join.lookup.LookupJoinable;

public class LookupColumnSelectorFactory
implements ColumnSelectorFactory {
    public static final String KEY_COLUMN = "k";
    public static final String VALUE_COLUMN = "v";
    private final Supplier<Pair<String, String>> currentEntry;

    LookupColumnSelectorFactory(Supplier<Pair<String, String>> currentEntry) {
        this.currentEntry = currentEntry;
    }

    @Override
    @Nonnull
    public DimensionSelector makeDimensionSelector(final DimensionSpec dimensionSpec) {
        Supplier<String> supplierToUse;
        if (KEY_COLUMN.equals(dimensionSpec.getDimension())) {
            supplierToUse = () -> {
                Pair<String, String> entry = this.currentEntry.get();
                return entry != null ? (String)entry.lhs : null;
            };
        } else if (VALUE_COLUMN.equals(dimensionSpec.getDimension())) {
            supplierToUse = () -> {
                Pair<String, String> entry = this.currentEntry.get();
                return entry != null ? (String)entry.rhs : null;
            };
        } else {
            return DimensionSelector.constant(null, dimensionSpec.getExtractionFn());
        }
        return dimensionSpec.decorate(new BaseSingleValueDimensionSelector(){

            @Override
            @Nullable
            protected String getValue() {
                if (dimensionSpec.getExtractionFn() != null) {
                    return dimensionSpec.getExtractionFn().apply((String)supplierToUse.get());
                }
                return (String)supplierToUse.get();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("dimensionSpec", dimensionSpec);
                inspector.visit("supplier", supplierToUse);
            }
        });
    }

    @Override
    @Nonnull
    public ColumnValueSelector makeColumnValueSelector(String columnName) {
        return this.makeDimensionSelector(DefaultDimensionSpec.of(columnName));
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        if (LookupJoinable.ALL_COLUMNS.contains(column)) {
            return new ColumnCapabilitiesImpl().setType(ColumnType.STRING);
        }
        return null;
    }
}

