/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.shim;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.shim.ShimCursor;
import org.apache.druid.segment.vector.ReadableVectorInspector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class ShimNumericColumnValueSelector
implements ColumnValueSelector<Object> {
    private final ShimCursor cursor;
    private final ReadableVectorInspector vectorInspector;
    private final VectorValueSelector vectorSelector;
    private final Supplier<Object> getObjectSupplier;
    private double[] doubleVector;
    private float[] floatVector;
    private long[] longVector;
    private boolean[] nullVector;
    private int doubleId = -1;
    private int floatId = -1;
    private int longId = -1;
    private int nullId = -1;

    public ShimNumericColumnValueSelector(ShimCursor cursor, VectorValueSelector vectorSelector, ValueType preferredType) {
        this.cursor = cursor;
        this.vectorInspector = cursor.vectorColumnSelectorFactory.getReadableVectorInspector();
        this.vectorSelector = vectorSelector;
        if (preferredType == ValueType.DOUBLE) {
            this.getObjectSupplier = () -> this.isNull() ? null : Double.valueOf(this.getDouble());
        } else if (preferredType == ValueType.FLOAT) {
            this.getObjectSupplier = () -> this.isNull() ? null : Float.valueOf(this.getFloat());
        } else if (preferredType == ValueType.LONG) {
            this.getObjectSupplier = () -> this.isNull() ? null : Long.valueOf(this.getLong());
        } else {
            throw DruidException.defensive("Unsupported preferredType[%s], must be numeric", preferredType);
        }
    }

    @Override
    public double getDouble() {
        this.populateDoubleVector();
        return this.doubleVector[this.cursor.currentIndexInVector];
    }

    @Override
    public float getFloat() {
        this.populateFloatVector();
        return this.floatVector[this.cursor.currentIndexInVector];
    }

    @Override
    public long getLong() {
        this.populateLongVector();
        return this.longVector[this.cursor.currentIndexInVector];
    }

    @Override
    public boolean isNull() {
        this.populateNullVector();
        return this.nullVector != null && this.nullVector[this.cursor.currentIndexInVector];
    }

    @Override
    @Nullable
    public Object getObject() {
        return this.getObjectSupplier.get();
    }

    @Override
    public Class<?> classOfObject() {
        return Number.class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }

    private void populateDoubleVector() {
        int id = this.vectorInspector.getId();
        if (id != this.doubleId) {
            this.doubleVector = this.vectorSelector.getDoubleVector();
            this.doubleId = id;
        }
    }

    private void populateFloatVector() {
        int id = this.vectorInspector.getId();
        if (id != this.floatId) {
            this.floatVector = this.vectorSelector.getFloatVector();
            this.floatId = id;
        }
    }

    private void populateLongVector() {
        int id = this.vectorInspector.getId();
        if (id != this.longId) {
            this.longVector = this.vectorSelector.getLongVector();
            this.longId = id;
        }
    }

    private void populateNullVector() {
        int id = this.vectorInspector.getId();
        if (id != this.nullId) {
            this.nullVector = this.vectorSelector.getNullVector();
            this.nullId = id;
        }
    }
}

