/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.utils;

import com.google.common.base.Preconditions;

public class CircularBuffer<E> {
    private final E[] buffer;
    private int start = 0;
    private int size = 0;

    public E[] getBuffer() {
        return this.buffer;
    }

    public CircularBuffer(int capacity) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"Capacity must be greater than 0.");
        this.buffer = new Object[capacity];
    }

    public void add(E item) {
        this.buffer[this.start++] = item;
        if (this.start >= this.buffer.length) {
            this.start = 0;
        }
        if (this.size < this.buffer.length) {
            ++this.size;
        }
    }

    public E getLatest(int index) {
        Preconditions.checkArgument((index >= 0 && index < this.size ? 1 : 0) != 0, (Object)"invalid index");
        int bufferIndex = this.start - index - 1;
        if (bufferIndex < 0) {
            bufferIndex = this.buffer.length + bufferIndex;
        }
        return this.buffer[bufferIndex];
    }

    public E get(int index) {
        Preconditions.checkArgument((index >= 0 && index < this.size ? 1 : 0) != 0, (Object)"invalid index");
        int bufferIndex = (this.start - this.size + index) % this.buffer.length;
        if (bufferIndex < 0) {
            bufferIndex += this.buffer.length;
        }
        return this.buffer[bufferIndex];
    }

    public int size() {
        return this.size;
    }
}

