/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCombinedCmd;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.exceptions.EmpireSQLException;
import org.apache.empire.dbms.DBMSFeature;
import org.apache.empire.dbms.DBMSHandlerBase;
import org.apache.empire.dbms.DBSqlPhrase;
import org.apache.empire.dbms.mysql.MySQLDDLGenerator;
import org.apache.empire.exceptions.NotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBMSHandlerMySQL
extends DBMSHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(DBMSHandlerMySQL.class);
    protected static final String[] MYSQL_KEYWORDS = new String[]{"ACCESSIBLE", "ACCOUNT", "ACTION", "ADD", "AFTER", "AGAINST", "AGGREGATE", "ALGORITHM", "ALL", "ALTER", "ALWAYS", "ANALYSE", "ANALYZE", "AND", "ANY", "AS", "ASC", "ASCII", "ASENSITIVE", "AT", "AUTOEXTEND_SIZE", "AUTO_INCREMENT", "AVG", "AVG_ROW_LENGTH", "BACKUP", "BEFORE", "BEGIN", "BETWEEN", "BIGINT", "BINARY", "BINLOG", "BIT", "BLOB", "BLOCK", "BOOL", "BOOLEAN", "BOTH", "BTREE", "BY", "BYTE", "CACHE", "CALL", "CASCADE", "CASCADED", "CASE", "CATALOG_NAME", "CHAIN", "CHANGE", "CHANGED", "CHANNEL", "CHAR", "CHARACTER", "CHARSET", "CHECK", "CHECKSUM", "CIPHER", "CLASS_ORIGIN", "CLIENT", "CLOSE", "COALESCE", "CODE", "COLLATE", "COLLATION", "COLUMN", "COLUMNS", "COLUMN_FORMAT", "COLUMN_NAME", "COMMENT", "COMMIT", "COMMITTED", "COMPACT", "COMPLETION", "COMPRESSED", "COMPRESSION", "CONCURRENT", "CONDITION", "CONNECTION", "CONSISTENT", "CONSTRAINT", "CONSTRAINT_CATALOG", "CONSTRAINT_NAME", "CONSTRAINT_SCHEMA", "CONTAINS", "CONTEXT", "CONTINUE", "CONVERT", "CPU", "CREATE", "CROSS", "CUBE", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CURSOR_NAME", "DATA", "DATABASE", "DATABASES", "DATAFILE", "DATE", "DATETIME", "DAY", "DAY_HOUR", "DAY_MICROSECOND", "DAY_MINUTE", "DAY_SECOND", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFAULT_AUTH", "DEFINER", "DELAYED", "DELAY_KEY_WRITE", "DELETE", "DESC", "DESCRIBE", "DES_KEY_FILE", "DETERMINISTIC", "DIAGNOSTICS", "DIRECTORY", "DISABLE", "DISCARD", "DISK", "DISTINCT", "DISTINCTROW", "DIV", "DO", "DOUBLE", "DROP", "DUAL", "DUMPFILE", "DUPLICATE", "DYNAMIC", "EACH", "ELSE", "ELSEIF", "ENABLE", "ENCLOSED", "ENCRYPTION", "END", "ENDS", "ENGINE", "ENGINES", "ENUM", "ERROR", "ERRORS", "ESCAPE", "ESCAPED", "EVENT", "EVENTS", "EVERY", "EXCHANGE", "EXECUTE", "EXISTS", "EXIT", "EXPANSION", "EXPIRE", "EXPLAIN", "EXPORT", "EXTENDED", "EXTENT_SIZE", "FALSE", "FAST", "FAULTS", "FETCH", "FIELDS", "FILE", "FILE_BLOCK_SIZE", "FILTER", "FIRST", "FIXED", "FLOAT", "FLOAT4", "FLOAT8", "FLUSH", "FOLLOWS", "FOR", "FORCE", "FOREIGN", "FORMAT", "FOUND", "FROM", "FULL", "FULLTEXT", "FUNCTION", "GENERAL", "GENERATED", "GEOMETRY", "GEOMETRYCOLLECTION", "GET", "GET_FORMAT", "GLOBAL", "GRANT", "GRANTS", "GROUP", "GROUP_REPLICATION", "HANDLER", "HASH", "HAVING", "HELP", "HIGH_PRIORITY", "HOST", "HOSTS", "HOUR", "HOUR_MICROSECOND", "HOUR_MINUTE", "HOUR_SECOND", "IDENTIFIED", "IF", "IGNORE", "IGNORE_SERVER_IDS", "IMPORT", "IN", "INDEX", "INDEXES", "INFILE", "INITIAL_SIZE", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INSERT_METHOD", "INSTALL", "INSTANCE", "INT", "INT1", "INT2", "INT3", "INT4", "INT8", "INTEGER", "INTERVAL", "INTO", "INVOKER", "IO", "IO_AFTER_GTIDS", "IO_BEFORE_GTIDS", "IO_THREAD", "IPC", "IS", "ISOLATION", "ISSUER", "ITERATE", "JOIN", "JSON", "KEY", "KEYS", "KEY_BLOCK_SIZE", "KILL", "LANGUAGE", "LAST", "LEADING", "LEAVE", "LEAVES", "LEFT", "LESS", "LEVEL", "LIKE", "LIMIT", "LINEAR", "LINES", "LINESTRING", "LIST", "LOAD", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCK", "LOCKS", "LOGFILE", "LOGS", "LONG", "LONGBLOB", "LONGTEXT", "LOOP", "LOW_PRIORITY", "MASTER", "MASTER_AUTO_POSITION", "MASTER_BIND", "MASTER_CONNECT_RETRY", "MASTER_DELAY", "MASTER_HEARTBEAT_PERIOD", "MASTER_HOST", "MASTER_LOG_FILE", "MASTER_LOG_POS", "MASTER_PASSWORD", "MASTER_PORT", "MASTER_RETRY_COUNT", "MASTER_SERVER_ID", "MASTER_SSL", "MASTER_SSL_CA", "MASTER_SSL_CAPATH", "MASTER_SSL_CERT", "MASTER_SSL_CIPHER", "MASTER_SSL_CRL", "MASTER_SSL_CRLPATH", "MASTER_SSL_KEY", "MASTER_SSL_VERIFY_SERVER_CERT", "MASTER_TLS_VERSION", "MASTER_USER", "MATCH", "MAXVALUE", "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS", "MAX_SIZE", "MAX_STATEMENT_TIME", "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS", "MEDIUM", "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEMORY", "MERGE", "MESSAGE_TEXT", "MICROSECOND", "MIDDLEINT", "MIGRATE", "MINUTE", "MINUTE_MICROSECOND", "MINUTE_SECOND", "MIN_ROWS", "MOD", "MODE", "MODIFIES", "MODIFY", "MONTH", "MULTILINESTRING", "MULTIPOINT", "MULTIPOLYGON", "MUTEX", "MYSQL_ERRNO", "NAME", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NDB", "NDBCLUSTER", "NEVER", "NEW", "NEXT", "NO", "NODEGROUP", "NONBLOCKING", "NONE", "NOT", "NO_WAIT", "NO_WRITE_TO_BINLOG", "NULL", "NUMBER", "NUMERIC", "NVARCHAR", "OFFSET", "OLD_PASSWORD", "ON", "ONE", "ONLY", "OPEN", "OPTIMIZE", "OPTIMIZER_COSTS", "OPTION", "OPTIONALLY", "OPTIONS", "OR", "ORDER", "OUT", "OUTER", "OUTFILE", "OWNER", "PACK_KEYS", "PAGE", "PARSER", "PARSE_GCOL_EXPR", "PARTIAL", "PARTITION", "PARTITIONING", "PARTITIONS", "PASSWORD", "PHASE", "PLUGIN", "PLUGINS", "PLUGIN_DIR", "POINT", "POLYGON", "PORT", "PRECEDES", "PRECISION", "PREPARE", "PRESERVE", "PREV", "PRIMARY", "PRIVILEGES", "PROCEDURE", "PROCESSLIST", "PROFILE", "PROFILES", "PROXY", "PURGE", "QUARTER", "QUERY", "QUICK", "RANGE", "READ", "READS", "READ_ONLY", "READ_WRITE", "REAL", "REBUILD", "RECOVER", "REDOFILE", "REDO_BUFFER_SIZE", "REDUNDANT", "REFERENCES", "REGEXP", "RELAY", "RELAYLOG", "RELAY_LOG_FILE", "RELAY_LOG_POS", "RELAY_THREAD", "RELEASE", "RELOAD", "REMOVE", "RENAME", "REORGANIZE", "REPAIR", "REPEAT", "REPEATABLE", "REPLACE", "REPLICATE_DO_DB", "REPLICATE_DO_TABLE", "REPLICATE_IGNORE_DB", "REPLICATE_IGNORE_TABLE", "REPLICATE_REWRITE_DB", "REPLICATE_WILD_DO_TABLE", "REPLICATE_WILD_IGNORE_TABLE", "REPLICATION", "REQUIRE", "RESET", "RESIGNAL", "RESTORE", "RESTRICT", "RESUME", "RETURN", "RETURNED_SQLSTATE", "RETURNS", "REVERSE", "REVOKE", "RIGHT", "RLIKE", "ROLLBACK", "ROLLUP", "ROTATE", "ROUTINE", "ROW", "ROWS", "ROW_COUNT", "ROW_FORMAT", "RTREE", "SAVEPOINT", "SCHEDULE", "SCHEMA", "SCHEMAS", "SCHEMA_NAME", "SECOND", "SECOND_MICROSECOND", "SECURITY", "SELECT", "SENSITIVE", "SEPARATOR", "SERIAL", "SERIALIZABLE", "SERVER", "SESSION", "SET", "SHARE", "SHOW", "SHUTDOWN", "SIGNAL", "SIGNED", "SIMPLE", "SLAVE", "SLOW", "SMALLINT", "SNAPSHOT", "SOCKET", "SOME", "SONAME", "SOUNDS", "SOURCE", "SPATIAL", "SPECIFIC", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "SQL_AFTER_GTIDS", "SQL_AFTER_MTS_GAPS", "SQL_BEFORE_GTIDS", "SQL_BIG_RESULT", "SQL_BUFFER_RESULT", "SQL_CACHE", "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE", "SQL_SMALL_RESULT", "SQL_THREAD", "SQL_TSI_DAY", "SQL_TSI_HOUR", "SQL_TSI_MINUTE", "SQL_TSI_MONTH", "SQL_TSI_QUARTER", "SQL_TSI_SECOND", "SQL_TSI_WEEK", "SQL_TSI_YEAR", "SSL", "STACKED", "START", "STARTING", "STARTS", "STATS_AUTO_RECALC", "STATS_PERSISTENT", "STATS_SAMPLE_PAGES", "STATUS", "STOP", "STORAGE", "STORED", "STRAIGHT_JOIN", "STRING", "SUBCLASS_ORIGIN", "SUBJECT", "SUBPARTITION", "SUBPARTITIONS", "SUPER", "SUSPEND", "SWAPS", "SWITCHES", "TABLE", "TABLES", "TABLESPACE", "TABLE_CHECKSUM", "TABLE_NAME", "TEMPORARY", "TEMPTABLE", "TERMINATED", "TEXT", "THAN", "THEN", "TIME", "TIMESTAMP", "TIMESTAMPADD", "TIMESTAMPDIFF", "TINYBLOB", "TINYINT", "TINYTEXT", "TO", "TRAILING", "TRANSACTION", "TRIGGER", "TRIGGERS", "TRUE", "TRUNCATE", "TYPE", "TYPES", "UNCOMMITTED", "UNDEFINED", "UNDO", "UNDOFILE", "UNDO_BUFFER_SIZE", "UNICODE", "UNINSTALL", "UNION", "UNIQUE", "UNKNOWN", "UNLOCK", "UNSIGNED", "UNTIL", "UPDATE", "UPGRADE", "USAGE", "USE", "USER", "USER_RESOURCES", "USE_FRM", "USING", "UTC_DATE", "UTC_TIME", "UTC_TIMESTAMP", "VALIDATION", "VALUE", "VALUES", "VARBINARY", "VARCHAR", "VARCHARACTER", "VARIABLES", "VARYING", "VIEW", "VIRTUAL", "WAIT", "WARNINGS", "WEEK", "WEIGHT_STRING", "WHEN", "WHERE", "WHILE", "WITH", "WITHOUT", "WORK", "WRAPPER", "WRITE", "X509", "XA", "XID", "XML", "XOR", "YEAR", "YEAR_MONTH", "ZEROFILL"};
    private String databaseName = null;
    private String characterSet = "utf8";
    private boolean useSequenceTable = false;
    private String sequenceTableName = "Sequences";
    private String engine;
    private DBDDLGenerator<?> ddlGenerator = null;

    public DBMSHandlerMySQL() {
        super(MYSQL_KEYWORDS);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public boolean isUseSequenceTable() {
        return this.useSequenceTable;
    }

    public void setUseSequenceTable(boolean useSequenceTable) {
        this.useSequenceTable = useSequenceTable;
    }

    public String getSequenceTableName() {
        return this.sequenceTableName;
    }

    public void setSequenceTableName(String sequenceTableName) {
        this.sequenceTableName = sequenceTableName;
    }

    @Override
    public void attachDatabase(DBDatabase db, Connection conn) {
        try {
            if (StringUtils.isNotEmpty(this.databaseName)) {
                this.executeSQL("USE " + this.databaseName, null, conn, null);
            }
            if (this.useSequenceTable && db.getTable(this.sequenceTableName) == null) {
                new DBMSHandlerBase.DBSeqTable(this.sequenceTableName, db);
            }
            super.attachDatabase(db, conn);
        }
        catch (SQLException e) {
            throw new EmpireSQLException(this, e);
        }
    }

    @Override
    public DBCommand createCommand(boolean autoPrepareStmt) {
        return new DBCommandMySQL(this, autoPrepareStmt);
    }

    @Override
    public DBSQLBuilder createSQLBuilder() {
        return new DBSQLBuilderMySQL(this);
    }

    @Override
    public DBCommandExpr createCombinedCommand(DBCommandExpr left, String keyWord, DBCommandExpr right) {
        return new DBCombinedCmd(left, keyWord, right){
            protected int limit;
            protected int skip;
            {
                this.limit = -1;
                this.skip = -1;
            }

            @Override
            public DBCommandExpr limitRows(int numRows) {
                this.limit = numRows;
                return this;
            }

            @Override
            public DBCommandExpr skipRows(int numRows) {
                this.skip = numRows;
                return this;
            }

            @Override
            public void clearLimit() {
                this.limit = -1;
                this.skip = -1;
            }

            @Override
            public void getSelect(DBSQLBuilder sql, int flags) {
                super.getSelect(sql, flags);
                if (this.limit >= 0 && this.not(flags, 32)) {
                    sql.append("\r\nLIMIT ");
                    sql.append(String.valueOf(this.limit));
                    if (this.skip >= 0) {
                        sql.append(" OFFSET ");
                        sql.append(String.valueOf(this.skip));
                    }
                }
            }
        };
    }

    @Override
    public boolean isSupported(DBMSFeature type) {
        switch (type) {
            case CREATE_SCHEMA: {
                return true;
            }
            case SEQUENCES: {
                return this.useSequenceTable;
            }
            case QUERY_LIMIT_ROWS: {
                return true;
            }
            case QUERY_SKIP_ROWS: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getSQLPhrase(DBSqlPhrase phrase) {
        switch (phrase) {
            case SQL_NULL: {
                return "null";
            }
            case SQL_PARAMETER: {
                return " ? ";
            }
            case SQL_RENAME_TABLE: {
                return " ";
            }
            case SQL_RENAME_COLUMN: {
                return " AS ";
            }
            case SQL_DATABASE_LINK: {
                return "@";
            }
            case SQL_QUOTES_OPEN: {
                return "`";
            }
            case SQL_QUOTES_CLOSE: {
                return "`";
            }
            case SQL_CONCAT_EXPR: {
                return "concat(?, {0})";
            }
            case SQL_BOOLEAN_TRUE: {
                return "1";
            }
            case SQL_BOOLEAN_FALSE: {
                return "0";
            }
            case SQL_CURRENT_DATE: {
                return "CURRENT_DATE()";
            }
            case SQL_DATE_TEMPLATE: {
                return "STR_TO_DATE('{0}','%Y-%m-%d')";
            }
            case SQL_CURRENT_TIME: {
                return "CURRENT_TIME()";
            }
            case SQL_TIME_TEMPLATE: {
                return "STR_TO_DATE('{0}','%H:%i:%s')";
            }
            case SQL_CURRENT_DATETIME: {
                return "CURRENT_TIMESTAMP()";
            }
            case SQL_DATETIME_TEMPLATE: {
                return "STR_TO_DATE('{0}','%Y-%m-%d %H:%i:%s')";
            }
            case SQL_CURRENT_TIMESTAMP: {
                return "CURRENT_TIMESTAMP()";
            }
            case SQL_TIMESTAMP_TEMPLATE: {
                return "STR_TO_DATE('{0}','%Y-%m-%d %H:%i:%s.%f')";
            }
            case SQL_FUNC_COALESCE: {
                return "coalesce(?, {0})";
            }
            case SQL_FUNC_SUBSTRING: {
                return "substring(?, {0})";
            }
            case SQL_FUNC_SUBSTRINGEX: {
                return "substring(?, {0}, {1})";
            }
            case SQL_FUNC_REPLACE: {
                return "replace(?, {0}, {1})";
            }
            case SQL_FUNC_REVERSE: {
                return "reverse(?)";
            }
            case SQL_FUNC_STRINDEX: {
                return "instr(?, {0})";
            }
            case SQL_FUNC_STRINDEXFROM: {
                return "locate({0}, ?, {1})";
            }
            case SQL_FUNC_LENGTH: {
                return "length(?)";
            }
            case SQL_FUNC_UPPER: {
                return "upper(?)";
            }
            case SQL_FUNC_LOWER: {
                return "lcase(?)";
            }
            case SQL_FUNC_TRIM: {
                return "trim(?)";
            }
            case SQL_FUNC_LTRIM: {
                return "ltrim(?)";
            }
            case SQL_FUNC_RTRIM: {
                return "rtrim(?)";
            }
            case SQL_FUNC_ESCAPE: {
                return "? escape {0:VARCHAR}";
            }
            case SQL_FUNC_CONTAINS: {
                return "MATCH(?) AGAINST({0})";
            }
            case SQL_FUNC_ABS: {
                return "abs(?)";
            }
            case SQL_FUNC_ROUND: {
                return "round(?,{0})";
            }
            case SQL_FUNC_TRUNC: {
                return "truncate(?,{0})";
            }
            case SQL_FUNC_CEILING: {
                return "ceiling(?)";
            }
            case SQL_FUNC_FLOOR: {
                return "floor(?)";
            }
            case SQL_FUNC_MOD: {
                return "mod(?,{0})";
            }
            case SQL_FUNC_FORMAT: {
                return "format(?, {0:INTEGER})";
            }
            case SQL_FUNC_DAY: {
                return "day(?)";
            }
            case SQL_FUNC_MONTH: {
                return "month(?)";
            }
            case SQL_FUNC_YEAR: {
                return "year(?)";
            }
            case SQL_FUNC_SUM: {
                return "sum(?)";
            }
            case SQL_FUNC_MAX: {
                return "max(?)";
            }
            case SQL_FUNC_MIN: {
                return "min(?)";
            }
            case SQL_FUNC_AVG: {
                return "avg(?)";
            }
            case SQL_FUNC_DECODE: {
                return "case ? {0} end";
            }
            case SQL_FUNC_DECODE_SEP: {
                return " ";
            }
            case SQL_FUNC_DECODE_PART: {
                return "when {0} then {1}";
            }
            case SQL_FUNC_DECODE_ELSE: {
                return "else {0}";
            }
        }
        return phrase.getSqlDefault();
    }

    @Override
    public String getConvertPhrase(DataType destType, DataType srcType, Object format) {
        switch (destType) {
            case BOOL: {
                return "CAST(? AS UNSIGNED)";
            }
            case INTEGER: {
                return "CAST(? AS SIGNED)";
            }
            case DECIMAL: {
                return "CAST(? AS DECIMAL)";
            }
            case FLOAT: {
                return "CAST(? AS DECIMAL)";
            }
            case DATE: {
                return "CAST(? AS DATE)";
            }
            case TIME: {
                return "CAST(? AS TIME)";
            }
            case DATETIME: 
            case TIMESTAMP: {
                return "CAST(? AS DATETIME)";
            }
            case VARCHAR: 
            case CHAR: {
                if (format != null) {
                    return "CAST(? AS CHAR " + format.toString() + ")";
                }
                return "CAST(? AS CHAR)";
            }
            case BLOB: {
                return "CAST(? AS BLOB)";
            }
        }
        log.error("getConvertPhrase: unknown type " + (Object)((Object)destType));
        return "?";
    }

    @Override
    public Object getNextSequenceValue(DBDatabase db, String seqName, int minValue, Connection conn) {
        if (this.useSequenceTable) {
            DBTable t = db.getTable(this.sequenceTableName);
            return ((DBMSHandlerBase.DBSeqTable)t).getNextValue(seqName, minValue, conn);
        }
        return null;
    }

    @Override
    public DBColumnExpr getNextSequenceValueExpr(DBTableColumn column) {
        throw new NotSupportedException(this, "getNextSequenceValueExpr");
    }

    @Override
    public Timestamp getUpdateTimestamp(Connection conn) {
        GregorianCalendar cal = new GregorianCalendar();
        return new Timestamp(cal.getTimeInMillis());
    }

    @Override
    public void getDDLScript(DBDDLGenerator.DDLActionType type, DBObject dbo, DBSQLScript script) {
        if (this.ddlGenerator == null) {
            this.ddlGenerator = new MySQLDDLGenerator(this);
        }
        this.ddlGenerator.getDDLScript(type, dbo, script);
    }

    public static class DBSQLBuilderMySQL
    extends DBSQLBuilder {
        public DBSQLBuilderMySQL(DBMSHandlerMySQL dbms) {
            super(dbms);
        }

        @Override
        protected void escapeAndAppendLiteral(String value) {
            if (value.indexOf(39) >= 0 || value.indexOf(92) >= 0) {
                int len = value.length();
                for (int i = 0; i < len; ++i) {
                    if (value.charAt(i) == '\'') {
                        this.sql.append("''");
                        continue;
                    }
                    if (value.charAt(i) == '\\') {
                        this.sql.append("\\\\");
                        continue;
                    }
                    this.sql.append(value.charAt(i));
                }
            } else {
                this.sql.append(value);
            }
        }
    }

    public static class DBCommandMySQL
    extends DBCommand {
        protected int limit = -1;
        protected int skip = -1;

        public DBCommandMySQL(DBMSHandlerMySQL dbms, boolean autoPrepareStmt) {
            super(dbms, autoPrepareStmt);
        }

        @Override
        public DBCommand limitRows(int numRows) {
            this.limit = numRows;
            return this;
        }

        @Override
        public DBCommand skipRows(int numRows) {
            this.skip = numRows;
            return this;
        }

        @Override
        public void clearLimit() {
            this.limit = -1;
            this.skip = -1;
        }

        @Override
        public void getSelect(DBSQLBuilder sql, int flags) {
            super.getSelect(sql, flags);
            if (this.limit >= 0 && this.not(flags, 32)) {
                sql.append("\r\nLIMIT ");
                sql.append(String.valueOf(this.limit));
                if (this.skip >= 0) {
                    sql.append(" OFFSET ");
                    sql.append(String.valueOf(this.skip));
                }
            }
        }

        @Override
        protected void addDeleteWithJoins(DBSQLBuilder sql, DBRowSet table) {
            sql.append(table.getAlias());
            this.addFrom(sql);
            this.addWhere(sql);
        }
    }
}

