/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.postgresql;

import java.util.Set;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.expr.compare.DBCompareAndOrExpr;
import org.apache.empire.db.expr.compare.DBCompareColExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.expr.compare.DBCompareNotExpr;
import org.apache.empire.xml.XMLUtil;
import org.w3c.dom.Element;

public class PostgresBoolAndOrExpr
extends DBColumnExpr {
    private static final String BOOL_AND = "BOOL_AND";
    private static final String BOOL_OR = "BOOL_OR";
    private final DBCompareExpr cmpExpr;
    private final boolean or;
    private String name;

    public PostgresBoolAndOrExpr(DBCompareExpr cmpExpr, boolean or) {
        this.cmpExpr = cmpExpr;
        this.or = or;
    }

    public DBDatabase getDatabase() {
        return this.cmpExpr.getDatabase();
    }

    @Override
    public DataType getDataType() {
        return DataType.BOOL;
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        return null;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            StringBuilder buf = new StringBuilder();
            this.appendName(buf, this.cmpExpr);
            buf.append("_");
            buf.append(this.or ? BOOL_OR : BOOL_AND);
            this.name = buf.toString();
        }
        return this.name;
    }

    @Override
    public boolean isAggregate() {
        return true;
    }

    @Override
    public DBRowSet getRowSet() {
        if (this.cmpExpr instanceof DBCompareColExpr) {
            DBColumnExpr colExpr = ((DBCompareColExpr)this.cmpExpr).getColumnExpr();
            return colExpr != null ? colExpr.getRowSet() : null;
        }
        return null;
    }

    @Override
    public DBColumn getUpdateColumn() {
        return null;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.cmpExpr.addReferencedColumns(list);
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        sql.append(this.or ? BOOL_OR : BOOL_AND);
        sql.append("(");
        this.cmpExpr.addSQL(sql, context);
        sql.append(")");
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element elem = XMLUtil.addElement(parent, "column");
        elem.setAttribute("name", this.getName());
        elem.setAttribute("function", this.or ? BOOL_OR : BOOL_AND);
        elem.setAttribute("dataType", this.getDataType().name());
        elem.setAttribute("aggregate", "true");
        return elem;
    }

    protected void appendName(StringBuilder buf, DBCompareExpr expr) {
        if (ObjectUtils.isWrapper(expr)) {
            this.appendName(buf, ObjectUtils.unwrap(expr));
        } else if (expr instanceof DBCompareNotExpr) {
            this.appendName(buf, ((DBCompareNotExpr)expr).getExpr());
        } else if (expr instanceof DBCompareAndOrExpr) {
            this.appendName(buf, ((DBCompareAndOrExpr)expr).getLeft());
            this.appendName(buf, ((DBCompareAndOrExpr)expr).getRight());
        } else if (expr instanceof DBCompareColExpr) {
            DBColumnExpr colExpr = ((DBCompareColExpr)expr).getColumnExpr();
            if (buf.length() > 0) {
                buf.append("_");
            }
            buf.append(colExpr.getName());
        }
    }
}

