/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

import java.io.Serializable;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.exceptions.InternalException;

public class OptionEntry
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object value;
    private String text;
    private boolean active;

    public OptionEntry(Object value, String text, boolean active) {
        this.value = value;
        this.text = text;
        this.active = active;
    }

    public OptionEntry(Object value, String text) {
        this(value, text, true);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean valueEquals(Object value) {
        return ObjectUtils.compareEqual(this.value, value);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalException(e);
        }
    }

    public String getValueString() {
        if (this.value == null) {
            return "";
        }
        if (this.value instanceof Enum) {
            return ObjectUtils.getString((Enum)this.value);
        }
        return String.valueOf(this.value);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String toString() {
        return StringUtils.concat("{", StringUtils.toString(this.value, "null"), "=", this.text, "}");
    }
}

