/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.accounting.journalentry.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.accounting.closure.domain.GLClosure;
import org.apache.fineract.accounting.closure.domain.GLClosureRepository;
import org.apache.fineract.accounting.financialactivityaccount.domain.FinancialActivityAccount;
import org.apache.fineract.accounting.financialactivityaccount.domain.FinancialActivityAccountRepositoryWrapper;
import org.apache.fineract.accounting.glaccount.data.GLAccountDataForLookup;
import org.apache.fineract.accounting.glaccount.domain.GLAccount;
import org.apache.fineract.accounting.glaccount.domain.GLAccountRepository;
import org.apache.fineract.accounting.glaccount.domain.GLAccountType;
import org.apache.fineract.accounting.glaccount.exception.GLAccountNotFoundException;
import org.apache.fineract.accounting.glaccount.service.GLAccountReadPlatformService;
import org.apache.fineract.accounting.journalentry.api.JournalEntryJsonInputParams;
import org.apache.fineract.accounting.journalentry.command.JournalEntryCommand;
import org.apache.fineract.accounting.journalentry.command.SingleDebitOrCreditEntryCommand;
import org.apache.fineract.accounting.journalentry.data.AdvancedMappingtDTO;
import org.apache.fineract.accounting.journalentry.data.ClientTransactionDTO;
import org.apache.fineract.accounting.journalentry.data.LoanDTO;
import org.apache.fineract.accounting.journalentry.data.SavingsDTO;
import org.apache.fineract.accounting.journalentry.data.SharesDTO;
import org.apache.fineract.accounting.journalentry.domain.JournalEntry;
import org.apache.fineract.accounting.journalentry.domain.JournalEntryRepository;
import org.apache.fineract.accounting.journalentry.domain.JournalEntryType;
import org.apache.fineract.accounting.journalentry.exception.JournalEntriesNotFoundException;
import org.apache.fineract.accounting.journalentry.exception.JournalEntryInvalidException;
import org.apache.fineract.accounting.journalentry.exception.JournalEntryRuntimeException;
import org.apache.fineract.accounting.journalentry.serialization.JournalEntryCommandFromApiJsonDeserializer;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorForLoan;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorForLoanFactory;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorForSavings;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorForSavingsFactory;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorForShares;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorForSharesFactory;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorHelper;
import org.apache.fineract.accounting.journalentry.service.CashBasedAccountingProcessorForClientTransactions;
import org.apache.fineract.accounting.journalentry.service.JournalEntryWritePlatformService;
import org.apache.fineract.accounting.journalentry.service.JournalEntryWritePlatformServiceJpaRepositoryImpl;
import org.apache.fineract.accounting.provisioning.domain.LoanProductProvisioningEntry;
import org.apache.fineract.accounting.provisioning.domain.ProvisioningEntry;
import org.apache.fineract.accounting.rule.domain.AccountingRule;
import org.apache.fineract.accounting.rule.domain.AccountingRuleRepository;
import org.apache.fineract.accounting.rule.exception.AccountingRuleNotFoundException;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.configuration.service.ConfigurationReadPlatformService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.investor.domain.ExternalAssetOwner;
import org.apache.fineract.investor.domain.ExternalAssetOwnerRepository;
import org.apache.fineract.investor.domain.ExternalAssetOwnerTransfer;
import org.apache.fineract.investor.exception.ExternalAssetOwnerNotFoundException;
import org.apache.fineract.investor.service.AccountingService;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.OrganisationCurrencyRepositoryWrapper;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.office.domain.OfficeRepositoryWrapper;
import org.apache.fineract.portfolio.PortfolioProductType;
import org.apache.fineract.portfolio.loanaccount.data.AccountingBridgeDataDTO;
import org.apache.fineract.portfolio.loanaccount.data.AccountingBridgeLoanTransactionDTO;
import org.apache.fineract.portfolio.loanaccount.data.LoanChargePaidByDTO;
import org.apache.fineract.portfolio.loanaccount.domain.AmortizationType;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAmortizationAllocationMappingRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanChargePaidBy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRelation;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRelationTypeEnum;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanproduct.service.LoanEnumerations;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetail;
import org.apache.fineract.portfolio.paymentdetail.service.PaymentDetailWritePlatformService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class JournalEntryWritePlatformServiceJpaRepositoryImpl
implements JournalEntryWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JournalEntryWritePlatformServiceJpaRepositoryImpl.class);
    private final GLClosureRepository glClosureRepository;
    private final GLAccountRepository glAccountRepository;
    private final JournalEntryRepository glJournalEntryRepository;
    private final OfficeRepositoryWrapper officeRepositoryWrapper;
    private final AccountingProcessorForLoanFactory accountingProcessorForLoanFactory;
    private final AccountingProcessorForSavingsFactory accountingProcessorForSavingsFactory;
    private final AccountingProcessorForSharesFactory accountingProcessorForSharesFactory;
    private final AccountingProcessorHelper helper;
    private final JournalEntryCommandFromApiJsonDeserializer fromApiJsonDeserializer;
    private final AccountingRuleRepository accountingRuleRepository;
    private final GLAccountReadPlatformService glAccountReadPlatformService;
    private final OrganisationCurrencyRepositoryWrapper organisationCurrencyRepository;
    private final PlatformSecurityContext context;
    private final PaymentDetailWritePlatformService paymentDetailWritePlatformService;
    private final FinancialActivityAccountRepositoryWrapper financialActivityAccountRepositoryWrapper;
    private final CashBasedAccountingProcessorForClientTransactions accountingProcessorForClientTransactions;
    private final ConfigurationReadPlatformService configurationReadPlatformService;
    private final AccountingService accountingService;
    private final ExternalAssetOwnerRepository externalAssetOwnerRepository;
    private final LoanAmortizationAllocationMappingRepository loanAmortizationAllocationMappingRepository;
    private final LoanTransactionRepository loanTransactionRepository;

    @Transactional
    public CommandProcessingResult createJournalEntry(JsonCommand command) {
        try {
            JournalEntryCommand journalEntryCommand = this.fromApiJsonDeserializer.commandFromApiJson(command.json());
            journalEntryCommand.validateForCreate();
            Long officeId = command.longValueOfParameterNamed(JournalEntryJsonInputParams.OFFICE_ID.getValue());
            Office office = this.officeRepositoryWrapper.findOneWithNotFoundDetection(officeId);
            Long accountRuleId = command.longValueOfParameterNamed(JournalEntryJsonInputParams.ACCOUNTING_RULE.getValue());
            String currencyCode = command.stringValueOfParameterNamed(JournalEntryJsonInputParams.CURRENCY_CODE.getValue());
            this.validateBusinessRulesForJournalEntries(journalEntryCommand);
            LinkedHashMap changes = new LinkedHashMap();
            PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createAndPersistPaymentDetail(command, changes);
            LocalDate transactionDate = command.localDateValueOfParameterNamed(JournalEntryJsonInputParams.TRANSACTION_DATE.getValue());
            String transactionId = this.generateTransactionId(officeId);
            String referenceNumber = command.stringValueOfParameterNamed(JournalEntryJsonInputParams.REFERENCE_NUMBER.getValue());
            ExternalAssetOwner externalAssetOwner = null;
            ExternalId externalId = ExternalIdFactory.produce((String)command.stringValueOfParameterNamed(JournalEntryJsonInputParams.EXTERNAL_ASSET_OWNER.getValue()));
            if (!externalId.isEmpty()) {
                if (!this.configurationReadPlatformService.retrieveGlobalConfiguration("asset-externalization-of-non-active-loans").isEnabled()) {
                    throw new JournalEntryRuntimeException("error.msg.glJournalEntry.asset.externalization.not.enabled", "GL Journal Entry with Asset Externalization not enabled");
                }
                Optional optExternalAssetOwner = this.externalAssetOwnerRepository.findByExternalId(externalId);
                if (!optExternalAssetOwner.isPresent()) {
                    throw new ExternalAssetOwnerNotFoundException(externalId);
                }
                externalAssetOwner = (ExternalAssetOwner)optExternalAssetOwner.get();
            }
            if (accountRuleId != null) {
                AccountingRule accountingRule = (AccountingRule)this.accountingRuleRepository.findById((Object)accountRuleId).orElseThrow(() -> new AccountingRuleNotFoundException(accountRuleId));
                if (accountingRule.getAccountToCredit() == null) {
                    if (journalEntryCommand.getCredits() == null) {
                        throw new JournalEntryInvalidException(JournalEntryInvalidException.GlJournalEntryInvalidReason.NO_DEBITS_OR_CREDITS, null, null, null);
                    }
                    if (journalEntryCommand.getDebits() != null) {
                        this.checkDebitOrCreditAccountsAreValid(accountingRule, journalEntryCommand.getCredits(), journalEntryCommand.getDebits());
                        this.checkDebitAndCreditAmounts(journalEntryCommand.getCredits(), journalEntryCommand.getDebits());
                    }
                    this.saveAllDebitOrCreditEntries(journalEntryCommand, office, paymentDetail, currencyCode, transactionDate, journalEntryCommand.getCredits(), transactionId, JournalEntryType.CREDIT, referenceNumber, externalAssetOwner);
                } else {
                    GLAccount creditAccountHead = accountingRule.getAccountToCredit();
                    this.validateGLAccountForTransaction(creditAccountHead);
                    this.validateDebitOrCreditArrayForExistingGLAccount(creditAccountHead, journalEntryCommand.getCredits());
                    this.saveAllDebitOrCreditEntries(journalEntryCommand, office, paymentDetail, currencyCode, transactionDate, journalEntryCommand.getCredits(), transactionId, JournalEntryType.CREDIT, referenceNumber, externalAssetOwner);
                }
                if (accountingRule.getAccountToDebit() == null) {
                    if (journalEntryCommand.getDebits() == null) {
                        throw new JournalEntryInvalidException(JournalEntryInvalidException.GlJournalEntryInvalidReason.NO_DEBITS_OR_CREDITS, null, null, null);
                    }
                    if (journalEntryCommand.getCredits() != null) {
                        this.checkDebitOrCreditAccountsAreValid(accountingRule, journalEntryCommand.getCredits(), journalEntryCommand.getDebits());
                        this.checkDebitAndCreditAmounts(journalEntryCommand.getCredits(), journalEntryCommand.getDebits());
                    }
                    this.saveAllDebitOrCreditEntries(journalEntryCommand, office, paymentDetail, currencyCode, transactionDate, journalEntryCommand.getDebits(), transactionId, JournalEntryType.DEBIT, referenceNumber, externalAssetOwner);
                } else {
                    GLAccount debitAccountHead = accountingRule.getAccountToDebit();
                    this.validateGLAccountForTransaction(debitAccountHead);
                    this.validateDebitOrCreditArrayForExistingGLAccount(debitAccountHead, journalEntryCommand.getDebits());
                    this.saveAllDebitOrCreditEntries(journalEntryCommand, office, paymentDetail, currencyCode, transactionDate, journalEntryCommand.getDebits(), transactionId, JournalEntryType.DEBIT, referenceNumber, externalAssetOwner);
                }
            } else {
                this.saveAllDebitOrCreditEntries(journalEntryCommand, office, paymentDetail, currencyCode, transactionDate, journalEntryCommand.getDebits(), transactionId, JournalEntryType.DEBIT, referenceNumber, externalAssetOwner);
                this.saveAllDebitOrCreditEntries(journalEntryCommand, office, paymentDetail, currencyCode, transactionDate, journalEntryCommand.getCredits(), transactionId, JournalEntryType.CREDIT, referenceNumber, externalAssetOwner);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId(officeId).withTransactionId(transactionId).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            throw this.handleJournalEntryDataIntegrityIssues(throwable, (NonTransientDataAccessException)dve);
        }
    }

    private void validateDebitOrCreditArrayForExistingGLAccount(GLAccount glaccount, SingleDebitOrCreditEntryCommand[] creditOrDebits) {
        if (creditOrDebits.length != 1) {
            throw new JournalEntryInvalidException(JournalEntryInvalidException.GlJournalEntryInvalidReason.INVALID_DEBIT_OR_CREDIT_ACCOUNTS, null, null, null);
        }
        for (SingleDebitOrCreditEntryCommand creditOrDebit : creditOrDebits) {
            if (glaccount != null && creditOrDebit != null && Objects.equals(glaccount.getId(), creditOrDebit.getGlAccountId())) continue;
            throw new JournalEntryInvalidException(JournalEntryInvalidException.GlJournalEntryInvalidReason.INVALID_DEBIT_OR_CREDIT_ACCOUNTS, null, null, null);
        }
    }

    private void checkDebitOrCreditAccountsAreValid(AccountingRule accountingRule, SingleDebitOrCreditEntryCommand[] credits, SingleDebitOrCreditEntryCommand[] debits) {
        int validCreditsNo = 0;
        int validDebitsNo = 0;
        if (credits != null && credits.length > 0) {
            List allowedCreditGLAccounts = this.glAccountReadPlatformService.retrieveAccountsByTagId((Long)accountingRule.getId(), JournalEntryType.CREDIT.getValue());
            for (GLAccountDataForLookup accountDataForLookup : allowedCreditGLAccounts) {
                for (SingleDebitOrCreditEntryCommand credit : credits) {
                    if (!credit.getGlAccountId().equals(accountDataForLookup.getId())) continue;
                    ++validCreditsNo;
                }
            }
            if (credits.length != validCreditsNo) {
                throw new JournalEntryRuntimeException("error.msg.glJournalEntry.invalid.credits", "Invalid Credits.");
            }
        }
        if (debits != null && debits.length > 0) {
            List allowedDebitGLAccounts = this.glAccountReadPlatformService.retrieveAccountsByTagId((Long)accountingRule.getId(), JournalEntryType.DEBIT.getValue());
            for (GLAccountDataForLookup accountDataForLookup : allowedDebitGLAccounts) {
                for (SingleDebitOrCreditEntryCommand debit : debits) {
                    if (!debit.getGlAccountId().equals(accountDataForLookup.getId())) continue;
                    ++validDebitsNo;
                }
            }
            if (debits.length != validDebitsNo) {
                throw new JournalEntryRuntimeException("error.msg.glJournalEntry.invalid.debits", "Invalid Debits");
            }
        }
    }

    private void checkDebitAndCreditAmounts(SingleDebitOrCreditEntryCommand[] credits, SingleDebitOrCreditEntryCommand[] debits) {
        BigDecimal creditsSum = BigDecimal.ZERO;
        BigDecimal debitsSum = BigDecimal.ZERO;
        for (SingleDebitOrCreditEntryCommand creditEntryCommand : credits) {
            if (creditEntryCommand.getAmount() == null || creditEntryCommand.getGlAccountId() == null) {
                throw new JournalEntryInvalidException(JournalEntryInvalidException.GlJournalEntryInvalidReason.DEBIT_CREDIT_ACCOUNT_OR_AMOUNT_EMPTY, null, null, null);
            }
            creditsSum = creditsSum.add(creditEntryCommand.getAmount());
        }
        for (SingleDebitOrCreditEntryCommand debitEntryCommand : debits) {
            if (debitEntryCommand.getAmount() == null || debitEntryCommand.getGlAccountId() == null) {
                throw new JournalEntryInvalidException(JournalEntryInvalidException.GlJournalEntryInvalidReason.DEBIT_CREDIT_ACCOUNT_OR_AMOUNT_EMPTY, null, null, null);
            }
            debitsSum = debitsSum.add(debitEntryCommand.getAmount());
        }
        if (creditsSum.compareTo(debitsSum) != 0) {
            throw new JournalEntryInvalidException(JournalEntryInvalidException.GlJournalEntryInvalidReason.DEBIT_CREDIT_SUM_MISMATCH, null, null, null);
        }
    }

    private void validateGLAccountForTransaction(GLAccount creditOrDebitAccountHead) {
        if (creditOrDebitAccountHead.isDisabled()) {
            throw new JournalEntryInvalidException(JournalEntryInvalidException.GlJournalEntryInvalidReason.GL_ACCOUNT_DISABLED, null, creditOrDebitAccountHead.getName(), creditOrDebitAccountHead.getGlCode());
        }
        if (!creditOrDebitAccountHead.isManualEntriesAllowed()) {
            throw new JournalEntryInvalidException(JournalEntryInvalidException.GlJournalEntryInvalidReason.GL_ACCOUNT_MANUAL_ENTRIES_NOT_PERMITTED, null, creditOrDebitAccountHead.getName(), creditOrDebitAccountHead.getGlCode());
        }
    }

    @Transactional
    public CommandProcessingResult revertJournalEntry(JsonCommand command) {
        List journalEntries = this.glJournalEntryRepository.findUnReversedManualJournalEntriesByTransactionId(command.getTransactionId());
        String reversalComment = command.stringValueOfParameterNamed("comments");
        if (journalEntries.size() <= 1) {
            throw new JournalEntriesNotFoundException(command.getTransactionId());
        }
        String reversalTransactionId = this.revertJournalEntry(journalEntries, reversalComment);
        return new CommandProcessingResultBuilder().withTransactionId(reversalTransactionId).build();
    }

    public void createJournalEntryForReversedLoanTransaction(LocalDate transactionDate, String loanTransactionId, Long officeId) {
        GLClosure latestGLClosure = this.helper.getLatestClosureByBranch(officeId.longValue());
        this.helper.checkForBranchClosures(latestGLClosure, transactionDate);
        String transactionId = "L" + loanTransactionId;
        List journalEntries = this.glJournalEntryRepository.findJournalEntries(transactionId, PortfolioProductType.LOAN.getValue());
        if (journalEntries == null || journalEntries.isEmpty()) {
            return;
        }
        for (JournalEntry journalEntry : journalEntries) {
            JournalEntry reversalJournalEntry = JournalEntry.createNew((Office)journalEntry.getOffice(), (PaymentDetail)journalEntry.getPaymentDetail(), (GLAccount)journalEntry.getGlAccount(), (String)journalEntry.getCurrencyCode(), (String)transactionId, (boolean)Boolean.FALSE, (LocalDate)transactionDate, (JournalEntryType)(journalEntry.isDebitEntry() ? JournalEntryType.CREDIT : JournalEntryType.DEBIT), (BigDecimal)journalEntry.getAmount(), (String)journalEntry.getDescription(), (Integer)journalEntry.getEntityType(), (Long)journalEntry.getEntityId(), (String)journalEntry.getReferenceNumber(), (Long)journalEntry.getLoanTransactionId(), (Long)journalEntry.getSavingsTransactionId(), (Long)journalEntry.getClientTransactionId(), (Long)journalEntry.getShareTransactionId());
            this.helper.persistJournalEntry(reversalJournalEntry);
        }
    }

    public String revertJournalEntry(List<JournalEntry> journalEntries, String reversalComment) {
        Long officeId = (Long)journalEntries.get(0).getOffice().getId();
        String reversalTransactionId = this.generateTransactionId(officeId);
        boolean manualEntry = true;
        boolean useDefaultComment = StringUtils.isBlank((CharSequence)reversalComment);
        this.validateCommentForReversal((String)reversalComment);
        LocalDate journalEntriesTransactionDate = journalEntries.get(0).getTransactionDate();
        GLClosure latestGLClosureByBranch = this.glClosureRepository.getLatestGLClosureByBranch(officeId);
        if (latestGLClosureByBranch != null && !DateUtils.isBefore((LocalDate)latestGLClosureByBranch.getClosingDate(), (LocalDate)journalEntriesTransactionDate)) {
            String accountName = null;
            String accountGLCode = null;
            throw new JournalEntryInvalidException(JournalEntryInvalidException.GlJournalEntryInvalidReason.ACCOUNTING_CLOSED, latestGLClosureByBranch.getClosingDate(), accountName, accountGLCode);
        }
        for (JournalEntry journalEntry : journalEntries) {
            if (useDefaultComment) {
                reversalComment = "Reversal entry for Journal Entry with Entry Id  :" + String.valueOf(journalEntry.getId()) + " and transaction Id " + journalEntry.getTransactionId();
            }
            JournalEntry reversalJournalEntry = journalEntry.isDebitEntry() ? JournalEntry.createNew((Office)journalEntry.getOffice(), (PaymentDetail)journalEntry.getPaymentDetail(), (GLAccount)journalEntry.getGlAccount(), (String)journalEntry.getCurrencyCode(), (String)reversalTransactionId, (boolean)true, (LocalDate)journalEntry.getTransactionDate(), (JournalEntryType)JournalEntryType.CREDIT, (BigDecimal)journalEntry.getAmount(), (String)reversalComment, null, null, (String)journalEntry.getReferenceNumber(), (Long)journalEntry.getLoanTransactionId(), (Long)journalEntry.getSavingsTransactionId(), (Long)journalEntry.getClientTransactionId(), (Long)journalEntry.getShareTransactionId()) : JournalEntry.createNew((Office)journalEntry.getOffice(), (PaymentDetail)journalEntry.getPaymentDetail(), (GLAccount)journalEntry.getGlAccount(), (String)journalEntry.getCurrencyCode(), (String)reversalTransactionId, (boolean)true, (LocalDate)journalEntry.getTransactionDate(), (JournalEntryType)JournalEntryType.DEBIT, (BigDecimal)journalEntry.getAmount(), (String)reversalComment, null, null, (String)journalEntry.getReferenceNumber(), (Long)journalEntry.getLoanTransactionId(), (Long)journalEntry.getSavingsTransactionId(), (Long)journalEntry.getClientTransactionId(), (Long)journalEntry.getShareTransactionId());
            this.helper.persistJournalEntry(reversalJournalEntry);
            journalEntry.setReversed(true);
            journalEntry.setReversalJournalEntry(reversalJournalEntry);
            this.helper.persistJournalEntry(journalEntry);
        }
        return reversalTransactionId;
    }

    public String revertProvisioningJournalEntries(LocalDate reversalTransactionDate, Long entityId, Integer entityType) {
        List journalEntries = this.glJournalEntryRepository.findProvisioningJournalEntriesByEntityId(entityId, entityType);
        String reversalTransactionId = ((JournalEntry)journalEntries.get(0)).getTransactionId();
        for (JournalEntry journalEntry : journalEntries) {
            String reversalComment = "Reversal entry for Journal Entry with Entry Id  :" + String.valueOf(journalEntry.getId()) + " and transaction Id " + journalEntry.getTransactionId();
            JournalEntry reversalJournalEntry = journalEntry.isDebitEntry() ? JournalEntry.createNew((Office)journalEntry.getOffice(), (PaymentDetail)journalEntry.getPaymentDetail(), (GLAccount)journalEntry.getGlAccount(), (String)journalEntry.getCurrencyCode(), (String)journalEntry.getTransactionId(), (boolean)Boolean.FALSE, (LocalDate)reversalTransactionDate, (JournalEntryType)JournalEntryType.CREDIT, (BigDecimal)journalEntry.getAmount(), (String)reversalComment, (Integer)journalEntry.getEntityType(), (Long)journalEntry.getEntityId(), (String)journalEntry.getReferenceNumber(), (Long)journalEntry.getLoanTransactionId(), (Long)journalEntry.getSavingsTransactionId(), (Long)journalEntry.getClientTransactionId(), (Long)journalEntry.getShareTransactionId()) : JournalEntry.createNew((Office)journalEntry.getOffice(), (PaymentDetail)journalEntry.getPaymentDetail(), (GLAccount)journalEntry.getGlAccount(), (String)journalEntry.getCurrencyCode(), (String)journalEntry.getTransactionId(), (boolean)Boolean.FALSE, (LocalDate)reversalTransactionDate, (JournalEntryType)JournalEntryType.DEBIT, (BigDecimal)journalEntry.getAmount(), (String)reversalComment, (Integer)journalEntry.getEntityType(), (Long)journalEntry.getEntityId(), (String)journalEntry.getReferenceNumber(), (Long)journalEntry.getLoanTransactionId(), (Long)journalEntry.getSavingsTransactionId(), (Long)journalEntry.getClientTransactionId(), (Long)journalEntry.getShareTransactionId());
            this.helper.persistJournalEntry(reversalJournalEntry);
            journalEntry.setReversalJournalEntry(reversalJournalEntry);
            journalEntry.setReversed(true);
            this.helper.persistJournalEntry(journalEntry);
        }
        return reversalTransactionId;
    }

    public String createProvisioningJournalEntries(ProvisioningEntry provisioningEntry) {
        Collection provisioningEntries = provisioningEntry.getLoanProductProvisioningEntries();
        HashMap officeMap = new HashMap();
        for (LoanProductProvisioningEntry entry : provisioningEntries) {
            List<LoanProductProvisioningEntry> list;
            OfficeCurrencyKey key = new OfficeCurrencyKey(entry.getOffice(), entry.getCurrencyCode());
            if (officeMap.containsKey(key)) {
                list = (List)officeMap.get(key);
                list.add(entry);
                continue;
            }
            list = new ArrayList();
            list.add(entry);
            officeMap.put(key, list);
        }
        HashMap<GLAccount, BigDecimal> liabilityMap = new HashMap<GLAccount, BigDecimal>();
        HashMap<GLAccount, BigDecimal> expenseMap = new HashMap<GLAccount, BigDecimal>();
        for (Map.Entry entry : officeMap.entrySet()) {
            liabilityMap.clear();
            expenseMap.clear();
            for (LoanProductProvisioningEntry lppEntry : (List)entry.getValue()) {
                BigDecimal amount;
                if (liabilityMap.containsKey(lppEntry.getLiabilityAccount())) {
                    amount = (BigDecimal)liabilityMap.get(lppEntry.getLiabilityAccount());
                    amount = amount.add(lppEntry.getReservedAmount());
                    liabilityMap.put(lppEntry.getLiabilityAccount(), amount);
                } else {
                    amount = BigDecimal.ZERO.add(lppEntry.getReservedAmount());
                    liabilityMap.put(lppEntry.getLiabilityAccount(), amount);
                }
                if (expenseMap.containsKey(lppEntry.getExpenseAccount())) {
                    amount = (BigDecimal)expenseMap.get(lppEntry.getExpenseAccount());
                    amount = amount.add(lppEntry.getReservedAmount());
                    expenseMap.put(lppEntry.getExpenseAccount(), amount);
                    continue;
                }
                amount = BigDecimal.ZERO.add(lppEntry.getReservedAmount());
                expenseMap.put(lppEntry.getExpenseAccount(), amount);
            }
            this.createJournalEntry(provisioningEntry.getCreatedDate(), (Long)provisioningEntry.getId(), ((OfficeCurrencyKey)entry.getKey()).office, ((OfficeCurrencyKey)entry.getKey()).currency, liabilityMap, expenseMap);
        }
        return "P" + String.valueOf(provisioningEntry.getId());
    }

    private void createJournalEntry(LocalDate transactionDate, Long entryId, Office office, String currencyCode, Map<GLAccount, BigDecimal> liabilityMap, Map<GLAccount, BigDecimal> expenseMap) {
        for (Map.Entry<GLAccount, BigDecimal> entry : liabilityMap.entrySet()) {
            this.helper.createProvisioningCreditJournalEntry(transactionDate, entryId, office, currencyCode, entry.getKey(), entry.getValue());
        }
        for (Map.Entry<GLAccount, BigDecimal> entry : expenseMap.entrySet()) {
            this.helper.createProvisioningDebitJournalEntry(transactionDate, entryId, office, currencyCode, entry.getKey(), entry.getValue());
        }
    }

    private void validateCommentForReversal(String reversalComment) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("GLJournalEntry");
        baseDataValidator.reset().parameter("comments").value((Object)reversalComment).notExceedingLengthOf(Integer.valueOf(500));
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    @Transactional
    public void createJournalEntriesForLoan(AccountingBridgeDataDTO accountingBridgeData) {
        boolean cashBasedAccountingEnabled = accountingBridgeData.isCashBasedAccountingEnabled();
        boolean upfrontAccrualBasedAccountingEnabled = accountingBridgeData.isUpfrontAccrualBasedAccountingEnabled();
        boolean periodicAccrualBasedAccountingEnabled = accountingBridgeData.isPeriodicAccrualBasedAccountingEnabled();
        if (cashBasedAccountingEnabled || upfrontAccrualBasedAccountingEnabled || periodicAccrualBasedAccountingEnabled) {
            LoanDTO loanDTO = this.helper.populateLoanDtoFromDTO(accountingBridgeData);
            AccountingProcessorForLoan accountingProcessorForLoan = this.accountingProcessorForLoanFactory.determineProcessor(loanDTO);
            accountingProcessorForLoan.createJournalEntriesForLoan(loanDTO);
        }
    }

    @Transactional
    public void createJournalEntriesForSavings(Map<String, Object> accountingBridgeData) {
        boolean cashBasedAccountingEnabled = (Boolean)accountingBridgeData.get("cashBasedAccountingEnabled");
        boolean accrualBasedAccountingEnabled = (Boolean)accountingBridgeData.get("accrualBasedAccountingEnabled");
        if (cashBasedAccountingEnabled || accrualBasedAccountingEnabled) {
            SavingsDTO savingsDTO = this.helper.populateSavingsDtoFromMap(accountingBridgeData, cashBasedAccountingEnabled, accrualBasedAccountingEnabled);
            AccountingProcessorForSavings accountingProcessorForSavings = this.accountingProcessorForSavingsFactory.determineProcessor(savingsDTO);
            accountingProcessorForSavings.createJournalEntriesForSavings(savingsDTO);
        }
    }

    @Transactional
    public void createJournalEntriesForShares(Map<String, Object> accountingBridgeData) {
        boolean cashBasedAccountingEnabled = (Boolean)accountingBridgeData.get("cashBasedAccountingEnabled");
        boolean accrualBasedAccountingEnabled = (Boolean)accountingBridgeData.get("accrualBasedAccountingEnabled");
        if (cashBasedAccountingEnabled) {
            SharesDTO sharesDTO = this.helper.populateSharesDtoFromMap(accountingBridgeData, cashBasedAccountingEnabled, accrualBasedAccountingEnabled);
            AccountingProcessorForShares accountingProcessorForShares = this.accountingProcessorForSharesFactory.determineProcessor(sharesDTO);
            accountingProcessorForShares.createJournalEntriesForShares(sharesDTO);
        }
    }

    public void revertShareAccountJournalEntries(ArrayList<Long> transactionIds, LocalDate transactionDate) {
        for (Long shareTransactionId : transactionIds) {
            String transactionId = "SH" + shareTransactionId;
            List journalEntries = this.glJournalEntryRepository.findJournalEntries(transactionId, PortfolioProductType.SHARES.getValue());
            if (journalEntries == null || journalEntries.isEmpty()) continue;
            Long officeId = (Long)((JournalEntry)journalEntries.get(0)).getOffice().getId();
            String reversalTransactionId = this.generateTransactionId(officeId);
            for (JournalEntry journalEntry : journalEntries) {
                String reversalComment = "Reversal entry for Journal Entry with id  :" + String.valueOf(journalEntry.getId()) + " and transaction Id " + journalEntry.getTransactionId();
                JournalEntry reversalJournalEntry = journalEntry.isDebitEntry() ? JournalEntry.createNew((Office)journalEntry.getOffice(), (PaymentDetail)journalEntry.getPaymentDetail(), (GLAccount)journalEntry.getGlAccount(), (String)journalEntry.getCurrencyCode(), (String)reversalTransactionId, (boolean)Boolean.FALSE, (LocalDate)transactionDate, (JournalEntryType)JournalEntryType.CREDIT, (BigDecimal)journalEntry.getAmount(), (String)reversalComment, (Integer)journalEntry.getEntityType(), (Long)journalEntry.getEntityId(), (String)journalEntry.getReferenceNumber(), (Long)journalEntry.getLoanTransactionId(), (Long)journalEntry.getSavingsTransactionId(), (Long)journalEntry.getClientTransactionId(), (Long)journalEntry.getShareTransactionId()) : JournalEntry.createNew((Office)journalEntry.getOffice(), (PaymentDetail)journalEntry.getPaymentDetail(), (GLAccount)journalEntry.getGlAccount(), (String)journalEntry.getCurrencyCode(), (String)reversalTransactionId, (boolean)Boolean.FALSE, (LocalDate)transactionDate, (JournalEntryType)JournalEntryType.DEBIT, (BigDecimal)journalEntry.getAmount(), (String)reversalComment, (Integer)journalEntry.getEntityType(), (Long)journalEntry.getEntityId(), (String)journalEntry.getReferenceNumber(), (Long)journalEntry.getLoanTransactionId(), (Long)journalEntry.getSavingsTransactionId(), (Long)journalEntry.getClientTransactionId(), (Long)journalEntry.getShareTransactionId());
                this.helper.persistJournalEntry(reversalJournalEntry);
                journalEntry.setReversalJournalEntry(reversalJournalEntry);
                journalEntry.setReversed(true);
                this.helper.persistJournalEntry(journalEntry);
            }
        }
    }

    private void validateBusinessRulesForJournalEntries(JournalEntryCommand command) {
        LocalDate transactionDate = command.getTransactionDate();
        if (DateUtils.isDateInTheFuture((LocalDate)transactionDate)) {
            throw new JournalEntryInvalidException(JournalEntryInvalidException.GlJournalEntryInvalidReason.FUTURE_DATE, transactionDate, null, null);
        }
        GLClosure latestGLClosure = this.glClosureRepository.getLatestGLClosureByBranch(command.getOfficeId());
        if (latestGLClosure != null && !DateUtils.isBefore((LocalDate)latestGLClosure.getClosingDate(), (LocalDate)transactionDate)) {
            throw new JournalEntryInvalidException(JournalEntryInvalidException.GlJournalEntryInvalidReason.ACCOUNTING_CLOSED, latestGLClosure.getClosingDate(), null, null);
        }
        SingleDebitOrCreditEntryCommand[] credits = command.getCredits();
        SingleDebitOrCreditEntryCommand[] debits = command.getDebits();
        if (credits == null || credits.length == 0 || debits == null || debits.length == 0) {
            throw new JournalEntryInvalidException(JournalEntryInvalidException.GlJournalEntryInvalidReason.NO_DEBITS_OR_CREDITS, null, null, null);
        }
        this.checkDebitAndCreditAmounts(credits, debits);
    }

    private void saveAllDebitOrCreditEntries(JournalEntryCommand command, Office office, PaymentDetail paymentDetail, String currencyCode, LocalDate transactionDate, SingleDebitOrCreditEntryCommand[] singleDebitOrCreditEntryCommands, String transactionId, JournalEntryType type, String referenceNumber, ExternalAssetOwner externalAssetOwner) {
        boolean manualEntry = true;
        for (SingleDebitOrCreditEntryCommand singleDebitOrCreditEntryCommand : singleDebitOrCreditEntryCommands) {
            GLAccount glAccount = (GLAccount)this.glAccountRepository.findById((Object)singleDebitOrCreditEntryCommand.getGlAccountId()).orElseThrow(() -> new GLAccountNotFoundException(singleDebitOrCreditEntryCommand.getGlAccountId()));
            this.validateGLAccountForTransaction(glAccount);
            String comments = command.getComments();
            if (!StringUtils.isBlank((CharSequence)singleDebitOrCreditEntryCommand.getComments())) {
                comments = singleDebitOrCreditEntryCommand.getComments();
            }
            this.organisationCurrencyRepository.findOneWithNotFoundDetection(currencyCode);
            JournalEntry glJournalEntry = JournalEntry.createNew((Office)office, (PaymentDetail)paymentDetail, (GLAccount)glAccount, (String)currencyCode, (String)transactionId, (boolean)true, (LocalDate)transactionDate, (JournalEntryType)type, (BigDecimal)singleDebitOrCreditEntryCommand.getAmount(), (String)comments, null, null, (String)referenceNumber, null, null, null, null);
            this.helper.persistJournalEntry(glJournalEntry);
            this.accountingService.createMappingToOwner(externalAssetOwner, glJournalEntry);
        }
    }

    private String generateTransactionId(Long officeId) {
        AppUser user = this.context.authenticatedUser();
        Long time = System.currentTimeMillis();
        String uniqueVal = String.valueOf(time) + String.valueOf(user.getId()) + officeId;
        return Long.toHexString(Long.parseLong(uniqueVal));
    }

    private PlatformDataIntegrityException handleJournalEntryDataIntegrityIssues(Throwable realCause, NonTransientDataAccessException dve) {
        log.error("Error occurred.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.glJournalEntry.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource Journal Entry: " + realCause.getMessage()));
    }

    @Transactional
    public CommandProcessingResult defineOpeningBalance(JsonCommand command) {
        try {
            String transactionId2;
            JournalEntryCommand journalEntryCommand = this.fromApiJsonDeserializer.commandFromApiJson(command.json());
            journalEntryCommand.validateForCreate();
            FinancialActivityAccount financialActivityAccountId = this.financialActivityAccountRepositoryWrapper.findByFinancialActivityTypeWithNotFoundDetection(300);
            Long contraId = (Long)financialActivityAccountId.getGlAccount().getId();
            if (contraId == null) {
                throw new GeneralPlatformDomainRuleException("error.msg.financial.activity.mapping.opening.balance.contra.account.cannot.be.null", "office-opening-balances-contra-account value can not be null", new Object[]{"office-opening-balances-contra-account"});
            }
            this.validateJournalEntriesArePostedBefore(contraId);
            Long officeId = command.longValueOfParameterNamed(JournalEntryJsonInputParams.OFFICE_ID.getValue());
            Office office = this.officeRepositoryWrapper.findOneWithNotFoundDetection(officeId);
            String currencyCode = command.stringValueOfParameterNamed(JournalEntryJsonInputParams.CURRENCY_CODE.getValue());
            this.validateBusinessRulesForJournalEntries(journalEntryCommand);
            List transactionIdsToBeReversed = this.glJournalEntryRepository.findNonReversedContraTransactionIds(contraId, officeId);
            for (String transactionId2 : transactionIdsToBeReversed) {
                List journalEntries = this.glJournalEntryRepository.findUnReversedManualJournalEntriesByTransactionId(transactionId2);
                this.revertJournalEntry(journalEntries, "defining opening balance");
            }
            LocalDate transactionDate = command.localDateValueOfParameterNamed(JournalEntryJsonInputParams.TRANSACTION_DATE.getValue());
            transactionId2 = this.generateTransactionId(officeId);
            this.saveAllDebitOrCreditOpeningBalanceEntries(journalEntryCommand, office, currencyCode, transactionDate, journalEntryCommand.getDebits(), transactionId2, JournalEntryType.DEBIT, contraId);
            this.saveAllDebitOrCreditOpeningBalanceEntries(journalEntryCommand, office, currencyCode, transactionDate, journalEntryCommand.getCredits(), transactionId2, JournalEntryType.CREDIT, contraId);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId(officeId).withTransactionId(transactionId2).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            throw this.handleJournalEntryDataIntegrityIssues(throwable, (NonTransientDataAccessException)dve);
        }
    }

    private void saveAllDebitOrCreditOpeningBalanceEntries(JournalEntryCommand command, Office office, String currencyCode, LocalDate transactionDate, SingleDebitOrCreditEntryCommand[] singleDebitOrCreditEntryCommands, String transactionId, JournalEntryType type, Long contraAccountId) {
        boolean manualEntry = true;
        GLAccount contraAccount = (GLAccount)this.glAccountRepository.findById((Object)contraAccountId).orElseThrow(() -> new GLAccountNotFoundException(contraAccountId));
        if (!GLAccountType.fromInt((Integer)contraAccount.getType()).isEquityType()) {
            throw new GeneralPlatformDomainRuleException("error.msg.configuration.opening.balance.contra.account.value.is.invalid.account.type", "Global configuration 'office-opening-balances-contra-account' value is not an equity type account", new Object[]{contraAccountId});
        }
        this.validateGLAccountForTransaction(contraAccount);
        JournalEntryType contraType = this.getContraType(type);
        String comments = command.getComments();
        this.organisationCurrencyRepository.findOneWithNotFoundDetection(currencyCode);
        for (SingleDebitOrCreditEntryCommand singleDebitOrCreditEntryCommand : singleDebitOrCreditEntryCommands) {
            GLAccount glAccount = (GLAccount)this.glAccountRepository.findById((Object)singleDebitOrCreditEntryCommand.getGlAccountId()).orElseThrow(() -> new GLAccountNotFoundException(singleDebitOrCreditEntryCommand.getGlAccountId()));
            this.validateGLAccountForTransaction(glAccount);
            if (!StringUtils.isBlank((CharSequence)singleDebitOrCreditEntryCommand.getComments())) {
                comments = singleDebitOrCreditEntryCommand.getComments();
            }
            JournalEntry glJournalEntry = JournalEntry.createNew((Office)office, null, (GLAccount)glAccount, (String)currencyCode, (String)transactionId, (boolean)true, (LocalDate)transactionDate, (JournalEntryType)type, (BigDecimal)singleDebitOrCreditEntryCommand.getAmount(), (String)comments, null, null, null, null, null, null, null);
            this.helper.persistJournalEntry(glJournalEntry);
            JournalEntry contraEntry = JournalEntry.createNew((Office)office, null, (GLAccount)contraAccount, (String)currencyCode, (String)transactionId, (boolean)true, (LocalDate)transactionDate, (JournalEntryType)contraType, (BigDecimal)singleDebitOrCreditEntryCommand.getAmount(), (String)comments, null, null, null, null, null, null, null);
            this.helper.persistJournalEntry(contraEntry);
        }
    }

    private JournalEntryType getContraType(JournalEntryType type) {
        JournalEntryType contraType = type.isCreditType() ? JournalEntryType.DEBIT : JournalEntryType.CREDIT;
        return contraType;
    }

    private void validateJournalEntriesArePostedBefore(Long contraId) {
        List transactionIds = this.glJournalEntryRepository.findNonContraTransactionIds(contraId);
        if (!CollectionUtils.isEmpty((Collection)transactionIds)) {
            throw new GeneralPlatformDomainRuleException("error.msg.journalentry.defining.openingbalance.not.allowed", "Defining Opening balances not allowed after journal entries posted", new Object[]{transactionIds});
        }
    }

    public void createJournalEntriesForClientTransactions(Map<String, Object> accountingBridgeData) {
        ClientTransactionDTO clientTransactionDTO = this.helper.populateClientTransactionDtoFromMap(accountingBridgeData);
        this.accountingProcessorForClientTransactions.createJournalEntriesForClientTransaction(clientTransactionDTO);
    }

    @Transactional
    public void createJournalEntriesForLoanTransaction(LoanTransaction loanTransaction, boolean isAccountTransfer, boolean isLoanToLoanTransfer) {
        Loan loan = loanTransaction.getLoan();
        if (!(loan.isCashBasedAccountingEnabledOnLoanProduct().booleanValue() || loan.isUpfrontAccrualAccountingEnabledOnLoanProduct().booleanValue() || loan.isPeriodicAccrualAccountingEnabledOnLoanProduct().booleanValue())) {
            return;
        }
        AccountingBridgeDataDTO accountingBridgeData = this.createAccountingBridgeDataForSingleTransaction(loanTransaction, isAccountTransfer);
        if (isLoanToLoanTransfer) {
            accountingBridgeData.getNewLoanTransactions().forEach(tx -> tx.setLoanToLoanTransfer(true));
        }
        this.createJournalEntriesForLoan(accountingBridgeData);
    }

    @Transactional
    public void createJournalEntriesForExternalOwnerTransfer(Loan loan, ExternalAssetOwnerTransfer externalAssetOwnerTransfer, ExternalAssetOwner previousOwner) {
        boolean isBuyback = externalAssetOwnerTransfer.getStatus().name().contains("BUYBACK");
        if (isBuyback) {
            this.accountingService.createJournalEntriesForBuybackAssetTransfer(loan, externalAssetOwnerTransfer);
        } else {
            this.accountingService.createJournalEntriesForSaleAssetTransfer(loan, externalAssetOwnerTransfer, previousOwner);
        }
    }

    private AccountingBridgeDataDTO createAccountingBridgeDataForSingleTransaction(LoanTransaction loanTransaction, boolean isAccountTransfer) {
        Loan loan = loanTransaction.getLoan();
        String currencyCode = loan.getCurrencyCode();
        AccountingBridgeLoanTransactionDTO transactionDTO = this.convertToAccountingBridgeTransaction(loanTransaction);
        ArrayList<AccountingBridgeLoanTransactionDTO> transactions = new ArrayList<AccountingBridgeLoanTransactionDTO>();
        transactions.add(transactionDTO);
        boolean wasChargedOffAtTransactionTime = loan.isChargedOff();
        if (loan.isChargedOff() && loan.getChargedOffOnDate() != null && loanTransaction.getTransactionDate().isBefore(loan.getChargedOffOnDate())) {
            wasChargedOffAtTransactionTime = false;
        }
        List buydownFeeAdvancedMappingData = null;
        List capitalizedIncomeAdvancedMappingData = null;
        if (loanTransaction.isBuyDownFeeAmortization()) {
            buydownFeeAdvancedMappingData = this.getLoanTransactionClassificationId(loanTransaction);
        } else if (loanTransaction.isCapitalizedIncomeAmortization()) {
            capitalizedIncomeAdvancedMappingData = this.getLoanTransactionClassificationId(loanTransaction);
        }
        return new AccountingBridgeDataDTO((Long)loan.getId(), loan.productId(), loan.getOfficeId(), currencyCode, loan.getSummary().getTotalInterestCharged(), loan.isCashBasedAccountingEnabledOnLoanProduct().booleanValue(), loan.isUpfrontAccrualAccountingEnabledOnLoanProduct().booleanValue(), loan.isPeriodicAccrualAccountingEnabledOnLoanProduct().booleanValue(), isAccountTransfer, wasChargedOffAtTransactionTime, loan.isFraud(), loan.fetchChargeOffReasonId(), loan.isClosedWrittenOff(), transactions, loan.getLoanProductRelatedDetail().isMerchantBuyDownFee(), buydownFeeAdvancedMappingData, capitalizedIncomeAdvancedMappingData);
    }

    private List<AdvancedMappingtDTO> getLoanTransactionClassificationId(LoanTransaction loanTransaction) {
        ArrayList<AdvancedMappingtDTO> advancedMappingData = new ArrayList<AdvancedMappingtDTO>();
        if (loanTransaction.isCapitalizedIncomeAmortization() || loanTransaction.isBuyDownFeeAmortization()) {
            List loanTransactionAllocations = this.loanAmortizationAllocationMappingRepository.fetchLoanTransactionAllocationByAmortizationLoanTransactionId((Long)loanTransaction.getId(), (Long)loanTransaction.getLoan().getId());
            loanTransactionAllocations.forEach(loanTransactionAllocation -> {
                BigDecimal allocationAmount;
                CodeValue classification = this.loanTransactionRepository.fetchClassificationCodeValueByTransactionId(loanTransactionAllocation.getBaseLoanTransactionId());
                BigDecimal bigDecimal = allocationAmount = loanTransactionAllocation.getAmortizationType().equals((Object)AmortizationType.AM) ? loanTransactionAllocation.getAmount() : loanTransactionAllocation.getAmount().negate();
                if (classification != null) {
                    advancedMappingData.add(new AdvancedMappingtDTO((Long)classification.getId(), allocationAmount));
                } else {
                    advancedMappingData.add(new AdvancedMappingtDTO(null, allocationAmount));
                }
            });
        }
        return advancedMappingData;
    }

    private AccountingBridgeLoanTransactionDTO convertToAccountingBridgeTransaction(LoanTransaction loanTransaction) {
        LoanTransactionRelation loanTransactionRelation;
        MonetaryCurrency currency = loanTransaction.getLoan().getCurrency();
        AccountingBridgeLoanTransactionDTO transactionDTO = new AccountingBridgeLoanTransactionDTO();
        transactionDTO.setId((Long)loanTransaction.getId());
        transactionDTO.setOfficeId((Long)loanTransaction.getOffice().getId());
        transactionDTO.setType(LoanEnumerations.transactionType((LoanTransactionType)loanTransaction.getTypeOf()));
        transactionDTO.setReversed(loanTransaction.isReversed());
        transactionDTO.setDate(loanTransaction.getTransactionDate());
        transactionDTO.setCurrencyCode(currency.getCode());
        transactionDTO.setAmount(loanTransaction.getAmount());
        transactionDTO.setNetDisbursalAmount(loanTransaction.getLoan().getNetDisbursalAmount());
        if (transactionDTO.getType().isChargeback() && (loanTransaction.getLoan().getCreditAllocationRules() == null || loanTransaction.getLoan().getCreditAllocationRules().isEmpty())) {
            transactionDTO.setPrincipalPortion(loanTransaction.getAmount());
        } else {
            transactionDTO.setPrincipalPortion(loanTransaction.getPrincipalPortion());
        }
        transactionDTO.setInterestPortion(loanTransaction.getInterestPortion());
        transactionDTO.setFeeChargesPortion(loanTransaction.getFeeChargesPortion());
        transactionDTO.setPenaltyChargesPortion(loanTransaction.getPenaltyChargesPortion());
        transactionDTO.setOverPaymentPortion(loanTransaction.getOverPaymentPortion());
        if (transactionDTO.getType().isChargeRefund()) {
            transactionDTO.setChargeRefundChargeType(loanTransaction.getChargeRefundChargeType());
        }
        if (loanTransaction.getPaymentDetail() != null) {
            transactionDTO.setPaymentTypeId((Long)loanTransaction.getPaymentDetail().getPaymentType().getId());
        }
        if (!loanTransaction.getLoanChargesPaid().isEmpty()) {
            ArrayList<LoanChargePaidByDTO> loanChargesPaidData = new ArrayList<LoanChargePaidByDTO>();
            for (LoanChargePaidBy chargePaidBy : loanTransaction.getLoanChargesPaid()) {
                LoanChargePaidByDTO loanChargePaidData = new LoanChargePaidByDTO();
                loanChargePaidData.setChargeId((Long)chargePaidBy.getLoanCharge().getCharge().getId());
                loanChargePaidData.setIsPenalty(Boolean.valueOf(chargePaidBy.getLoanCharge().isPenaltyCharge()));
                loanChargePaidData.setLoanChargeId((Long)chargePaidBy.getLoanCharge().getId());
                loanChargePaidData.setAmount(chargePaidBy.getAmount());
                loanChargePaidData.setInstallmentNumber(chargePaidBy.getInstallmentNumber());
                loanChargesPaidData.add(loanChargePaidData);
            }
            transactionDTO.setLoanChargesPaid(loanChargesPaidData);
        }
        if (transactionDTO.getType().isChargeback() && loanTransaction.getOverPaymentPortion() != null && loanTransaction.getOverPaymentPortion().compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal principalPaid = loanTransaction.getOverPaymentPortion();
            BigDecimal feePaid = BigDecimal.ZERO;
            BigDecimal penaltyPaid = BigDecimal.ZERO;
            if (!loanTransaction.getLoanTransactionToRepaymentScheduleMappings().isEmpty()) {
                principalPaid = loanTransaction.getLoanTransactionToRepaymentScheduleMappings().stream().map(mapping -> Optional.ofNullable(mapping.getPrincipalPortion()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
                feePaid = loanTransaction.getLoanTransactionToRepaymentScheduleMappings().stream().map(mapping -> Optional.ofNullable(mapping.getFeeChargesPortion()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
                penaltyPaid = loanTransaction.getLoanTransactionToRepaymentScheduleMappings().stream().map(mapping -> Optional.ofNullable(mapping.getPenaltyChargesPortion()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            transactionDTO.setPrincipalPaid(principalPaid);
            transactionDTO.setFeePaid(feePaid);
            transactionDTO.setPenaltyPaid(penaltyPaid);
        }
        if ((loanTransactionRelation = (LoanTransactionRelation)loanTransaction.getLoanTransactionRelations().stream().filter(e -> LoanTransactionRelationTypeEnum.CHARGE_ADJUSTMENT.equals((Object)e.getRelationType())).findAny().orElse(null)) != null) {
            LoanCharge loanCharge = loanTransactionRelation.getToCharge();
            transactionDTO.setLoanChargeData(loanCharge.toData());
        }
        transactionDTO.setLoanToLoanTransfer(false);
        return transactionDTO;
    }

    @Generated
    public JournalEntryWritePlatformServiceJpaRepositoryImpl(GLClosureRepository glClosureRepository, GLAccountRepository glAccountRepository, JournalEntryRepository glJournalEntryRepository, OfficeRepositoryWrapper officeRepositoryWrapper, AccountingProcessorForLoanFactory accountingProcessorForLoanFactory, AccountingProcessorForSavingsFactory accountingProcessorForSavingsFactory, AccountingProcessorForSharesFactory accountingProcessorForSharesFactory, AccountingProcessorHelper helper, JournalEntryCommandFromApiJsonDeserializer fromApiJsonDeserializer, AccountingRuleRepository accountingRuleRepository, GLAccountReadPlatformService glAccountReadPlatformService, OrganisationCurrencyRepositoryWrapper organisationCurrencyRepository, PlatformSecurityContext context, PaymentDetailWritePlatformService paymentDetailWritePlatformService, FinancialActivityAccountRepositoryWrapper financialActivityAccountRepositoryWrapper, CashBasedAccountingProcessorForClientTransactions accountingProcessorForClientTransactions, ConfigurationReadPlatformService configurationReadPlatformService, AccountingService accountingService, ExternalAssetOwnerRepository externalAssetOwnerRepository, LoanAmortizationAllocationMappingRepository loanAmortizationAllocationMappingRepository, LoanTransactionRepository loanTransactionRepository) {
        this.glClosureRepository = glClosureRepository;
        this.glAccountRepository = glAccountRepository;
        this.glJournalEntryRepository = glJournalEntryRepository;
        this.officeRepositoryWrapper = officeRepositoryWrapper;
        this.accountingProcessorForLoanFactory = accountingProcessorForLoanFactory;
        this.accountingProcessorForSavingsFactory = accountingProcessorForSavingsFactory;
        this.accountingProcessorForSharesFactory = accountingProcessorForSharesFactory;
        this.helper = helper;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.accountingRuleRepository = accountingRuleRepository;
        this.glAccountReadPlatformService = glAccountReadPlatformService;
        this.organisationCurrencyRepository = organisationCurrencyRepository;
        this.context = context;
        this.paymentDetailWritePlatformService = paymentDetailWritePlatformService;
        this.financialActivityAccountRepositoryWrapper = financialActivityAccountRepositoryWrapper;
        this.accountingProcessorForClientTransactions = accountingProcessorForClientTransactions;
        this.configurationReadPlatformService = configurationReadPlatformService;
        this.accountingService = accountingService;
        this.externalAssetOwnerRepository = externalAssetOwnerRepository;
        this.loanAmortizationAllocationMappingRepository = loanAmortizationAllocationMappingRepository;
        this.loanTransactionRepository = loanTransactionRepository;
    }
}

