/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.core.InMemorySamplingService;
import org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.core.NoopSamplingService;
import org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.core.SamplingConfiguration;
import org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.core.SamplingService;
import org.springframework.stereotype.Component;

@Component
public class SamplingServiceFactory {
    private final Map<Class<?>, SamplingService> services = new ConcurrentHashMap();
    private final SamplingConfiguration samplingConfiguration;

    public SamplingService forClass(Class<?> contextClass) {
        return this.services.computeIfAbsent(contextClass, cc -> {
            if (this.samplingConfiguration.isSamplingEnabled() && this.samplingConfiguration.isSamplingConfiguredForClass(contextClass)) {
                return new InMemorySamplingService(this.samplingConfiguration.getSamplingRate());
            }
            return new NoopSamplingService();
        });
    }

    public void doWithAll(Consumer<Map<Class<?>, SamplingService>> c) {
        c.accept(Map.copyOf(this.services));
    }

    @Generated
    public SamplingServiceFactory(SamplingConfiguration samplingConfiguration) {
        this.samplingConfiguration = samplingConfiguration;
    }
}

