/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.creditbureau.serialization;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class CreditBureauConfigurationCommandFromApiJsonDeserializer {
    public static final String CONFIGKEY = "configkey";
    public static final String VALUE = "value";
    public static final String DESCRIPTION = "description";
    private static final Set<String> SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("configkey", "value", "description"));
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public CreditBureauConfigurationCommandFromApiJsonDeserializer(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForCreate(String json, Long creditBureauId) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("CREDITBUREAU_CONFIGURATION");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        baseDataValidator.reset().value((Object)creditBureauId).notBlank().integerGreaterThanZero();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        String configkey = this.fromApiJsonHelper.extractStringNamed(CONFIGKEY, element);
        baseDataValidator.reset().parameter(CONFIGKEY).value((Object)configkey).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String value = this.fromApiJsonHelper.extractStringNamed(VALUE, element);
        baseDataValidator.reset().parameter(VALUE).value((Object)value).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String description = this.fromApiJsonHelper.extractStringNamed(DESCRIPTION, element);
        baseDataValidator.reset().parameter(DESCRIPTION).value((Object)description).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("config");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        if (this.fromApiJsonHelper.parameterExists(VALUE, element)) {
            String value = this.fromApiJsonHelper.extractStringNamed(VALUE, element);
            baseDataValidator.reset().parameter(VALUE).value((Object)value).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists(DESCRIPTION, element)) {
            String description = this.fromApiJsonHelper.extractStringNamed(DESCRIPTION, element);
            baseDataValidator.reset().parameter(DESCRIPTION).value((Object)description).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }
}

