/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.mix.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.sql.Date;
import lombok.Generated;
import org.apache.fineract.mix.data.XBRLData;
import org.apache.fineract.mix.service.XBRLBuilder;
import org.apache.fineract.mix.service.XBRLResultService;
import org.springframework.stereotype.Component;

@Path(value="/v1/mixreport")
@Component
@Tag(name="Mix Report", description="")
public class MixReportApiResource {
    private final XBRLResultService xbrlResultService;
    private final XBRLBuilder xbrlBuilder;

    @GET
    @Produces(value={"application/xml"})
    public String retrieveXBRLReport(@QueryParam(value="startDate") Date startDate, @QueryParam(value="endDate") Date endDate, @QueryParam(value="currency") String currency) {
        XBRLData data = this.xbrlResultService.getXBRLResult(startDate, endDate, currency);
        return this.xbrlBuilder.build(data);
    }

    @Generated
    public MixReportApiResource(XBRLResultService xbrlResultService, XBRLBuilder xbrlBuilder) {
        this.xbrlResultService = xbrlResultService;
        this.xbrlBuilder = xbrlBuilder;
    }
}

