/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.notification.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.notification.api.NotificationApiResourceSwagger;
import org.apache.fineract.notification.data.NotificationData;
import org.apache.fineract.notification.service.NotificationReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/notifications")
@Component
@Tag(name="Notification", description="")
public class NotificationApiResource {
    private final PlatformSecurityContext context;
    private final NotificationReadPlatformService notificationReadPlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final ToApiJsonSerializer<NotificationData> toApiJsonSerializer;
    private final SqlValidator sqlValidator;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=NotificationApiResourceSwagger.GetNotificationsResponse.class))})})
    public String getAllNotifications(@Context UriInfo uriInfo, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder, @QueryParam(value="isRead") @Parameter(description="isRead") boolean isRead) {
        this.context.authenticatedUser();
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        SearchParameters searchParameters = SearchParameters.builder().limit(limit).offset(offset).orderBy(orderBy).sortOrder(sortOrder).build();
        Page notificationData = !isRead ? this.notificationReadPlatformService.getAllUnreadNotifications(searchParameters) : this.notificationReadPlatformService.getAllNotifications(searchParameters);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, notificationData);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void update() {
        this.context.authenticatedUser();
        this.notificationReadPlatformService.updateNotificationReadStatus();
    }

    @Generated
    public NotificationApiResource(PlatformSecurityContext context, NotificationReadPlatformService notificationReadPlatformService, ApiRequestParameterHelper apiRequestParameterHelper, ToApiJsonSerializer<NotificationData> toApiJsonSerializer, SqlValidator sqlValidator) {
        this.context = context;
        this.notificationReadPlatformService = notificationReadPlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.sqlValidator = sqlValidator;
    }
}

