/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.notification.eventandlistener;

import jakarta.jms.Destination;
import java.io.Serializable;
import lombok.Generated;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.fineract.infrastructure.core.condition.EnableFineractEventsCondition;
import org.apache.fineract.notification.data.NotificationData;
import org.apache.fineract.notification.eventandlistener.NotificationEventPublisher;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Profile;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"activeMqEnabled"})
@Conditional(value={EnableFineractEventsCondition.class})
public class ActiveMQNotificationEventPublisher
implements NotificationEventPublisher {
    private final JmsTemplate jmsTemplate;

    public void broadcastNotification(NotificationData notificationData) {
        ActiveMQQueue queue = new ActiveMQQueue("NotificationQueue");
        this.jmsTemplate.send((Destination)queue, session -> session.createObjectMessage((Serializable)notificationData));
    }

    @Generated
    public ActiveMQNotificationEventPublisher(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }
}

