/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service.reamortization;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.impl.ChangeOperation;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleType;
import org.springframework.stereotype.Component;

@Component
public class LoanReAmortizationValidator {
    public void validateReAmortize(Loan loan, JsonCommand command) {
        this.validateReAmortizeRequest(command);
        this.validateReAmortizeBusinessRules(loan);
    }

    private void validateReAmortizeRequest(JsonCommand command) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.reAmortization");
        String externalId = command.stringValueOfParameterNamedAllowingNull("externalId");
        baseDataValidator.reset().parameter("externalId").ignoreIfNull().value((Object)externalId).notExceedingLengthOf(Integer.valueOf(100));
        this.throwExceptionIfValidationErrorsExist(dataValidationErrors);
    }

    private void validateReAmortizeBusinessRules(Loan loan) {
        if (DateUtils.isAfter((LocalDate)DateUtils.getBusinessLocalDate(), (LocalDate)loan.getMaturityDate())) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reamortize.cannot.be.submitted.after.maturity", "Loan cannot be re-amortized after maturity", new Object[]{loan.getId()});
        }
        LoanScheduleType loanScheduleType = LoanScheduleType.valueOf((String)loan.getLoanProductRelatedDetail().getLoanScheduleType().name());
        boolean isProgressiveSchedule = LoanScheduleType.PROGRESSIVE.equals((Object)loanScheduleType);
        String transactionProcessingStrategyCode = loan.getTransactionProcessingStrategyCode();
        boolean isAdvancedPaymentSchedule = "advanced-payment-allocation-strategy".equals(transactionProcessingStrategyCode);
        if (!isProgressiveSchedule || !isAdvancedPaymentSchedule) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reamortize.supported.only.for.progressive.loan.schedule.type", "Loan reamortization is only available for progressive repayment schedule and Advanced payment allocation strategy", new Object[]{loan.getId()});
        }
        if (loan.isInterestBearing()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reamortize.supported.only.for.non.interest.loans", "Loan reamortization is only available for non-interest bearing loans", new Object[]{loan.getId()});
        }
        if (!loan.getStatus().isActive()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reamortize.supported.only.for.active.loans", "Loan reamortization can only be done on active loans", new Object[]{loan.getId()});
        }
        boolean isReAmortizationTransactionForTodayPresent = loan.getLoanTransactions().stream().anyMatch(tx -> tx.getTypeOf().isReAmortize() && tx.getTransactionDate().equals(DateUtils.getBusinessLocalDate()));
        if (isReAmortizationTransactionForTodayPresent) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reamortize.reamortize.transaction.already.present.for.today", "Loan reamortization can only be done once a day. There has already been a reamortization done for today", new Object[]{loan.getId()});
        }
    }

    public void validateUndoReAmortize(Loan loan, JsonCommand command) {
        this.validateUndoReAmortizeBusinessRules(loan);
    }

    private void validateUndoReAmortizeBusinessRules(Loan loan) {
        Optional<LoanTransaction> optionalReAmortizationTx = loan.getLoanTransactions().stream().filter(tx -> tx.getTypeOf().isReAmortize()).min(Comparator.comparing(LoanTransaction::getTransactionDate));
        if (optionalReAmortizationTx.isEmpty()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reamortize.reamortization.transaction.missing", "Undoing a reamortization can only be done if there was a reamortization already", new Object[]{loan.getId()});
        }
        boolean repaymentExistsAfterReAmortization = loan.getLoanTransactions().stream().anyMatch(tx -> tx.getTypeOf().isRepaymentType() && !tx.isReversed() && this.transactionHappenedAfterOther(tx, (LoanTransaction)optionalReAmortizationTx.get()));
        if (repaymentExistsAfterReAmortization) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reamortize.repayment.exists.after.reamortization", "Undoing a reamortization can only be done if there hasn't been any repayment afterwards", new Object[]{loan.getId()});
        }
    }

    private void throwExceptionIfValidationErrorsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    private boolean transactionHappenedAfterOther(LoanTransaction transaction, LoanTransaction otherTransaction) {
        return new ChangeOperation(transaction).compareTo(new ChangeOperation(otherTransaction)) > 0;
    }
}

