/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.dataqueries.api.ReportsApiResourceSwagger;
import org.apache.fineract.infrastructure.dataqueries.data.ReportData;
import org.apache.fineract.infrastructure.dataqueries.service.ReadReportingService;
import org.apache.fineract.infrastructure.report.provider.ReportingProcessServiceProvider;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.stereotype.Component;

@Path(value="/v1/reports")
@Component
@Tag(name="Reports", description="Non-core reports can be added, updated and deleted.")
public class ReportsApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "reportName", "reportType", "reportSubType", "reportCategory", "description", "reportSql", "coreReport", "useReport", "reportParameters"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "REPORT";
    private final PlatformSecurityContext context;
    private final ToApiJsonSerializer<ReportData> toApiJsonSerializer;
    private final ReadReportingService readReportingService;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final ReportingProcessServiceProvider reportingProcessServiceProvider;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Reports", description="Lists all reports and their parameters.\n\nExample Request:\n\nreports")
    @ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ReportsApiResourceSwagger.GetReportsResponse.class)))})
    public String retrieveReportList(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Collection result = this.readReportingService.retrieveReportList();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, result, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Report\n", description="Example Requests:\n\nreports/1\n\n\nreports/1?template=true")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ReportsApiResourceSwagger.GetReportsResponse.class))})})
    public String retrieveReport(@PathParam(value="id") @Parameter(description="id") Long id, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ReportData result = this.readReportingService.retrieveReport(id);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (settings.isTemplate()) {
            result.appendedTemplate(this.readReportingService.getAllowedParameters(), this.reportingProcessServiceProvider.findAllReportingTypes());
        }
        return this.toApiJsonSerializer.serialize(settings, (Object)result, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Report Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed description Lists\n\nExample Request : \n\nreports/template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ReportsApiResourceSwagger.GetReportsTemplateResponse.class))})})
    public String retrieveOfficeTemplate(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ReportData result = new ReportData();
        result.appendedTemplate(this.readReportingService.getAllowedParameters(), this.reportingProcessServiceProvider.findAllReportingTypes());
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)result, RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Report", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ReportsApiResourceSwagger.PostRepostRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ReportsApiResourceSwagger.PostReportsResponse.class))})})
    public String createReport(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createReport().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Report", description="Only the useReport description can be updated for core reports.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ReportsApiResourceSwagger.PutReportRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ReportsApiResourceSwagger.PutReportResponse.class))})})
    public String updateReport(@PathParam(value="id") @Parameter(description="id") Long id, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateReport(id).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Report", description="Only non-core reports can be deleted.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ReportsApiResourceSwagger.DeleteReportsResponse.class))})})
    public String deleteReport(@PathParam(value="id") @Parameter(description="id") Long id) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteReport(id).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public ReportsApiResource(PlatformSecurityContext context, ToApiJsonSerializer<ReportData> toApiJsonSerializer, ReadReportingService readReportingService, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ApiRequestParameterHelper apiRequestParameterHelper, ReportingProcessServiceProvider reportingProcessServiceProvider) {
        this.context = context;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.readReportingService = readReportingService;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.reportingProcessServiceProvider = reportingProcessServiceProvider;
    }
}

