/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.hooks.service;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.hooks.data.EventResultSetExtractor;
import org.apache.fineract.infrastructure.hooks.data.Grouping;
import org.apache.fineract.infrastructure.hooks.data.HookData;
import org.apache.fineract.infrastructure.hooks.domain.Hook;
import org.apache.fineract.infrastructure.hooks.domain.HookRepository;
import org.apache.fineract.infrastructure.hooks.exception.HookNotFoundException;
import org.apache.fineract.infrastructure.hooks.service.HookReadPlatformService;
import org.apache.fineract.infrastructure.hooks.service.HookReadPlatformServiceImpl;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class HookReadPlatformServiceImpl
implements HookReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final HookRepository hookRepository;
    private final PlatformSecurityContext context;

    public Collection<HookData> retrieveAllHooks() {
        this.context.authenticatedUser();
        HookMapper rm = new HookMapper(this.jdbcTemplate);
        String sql = "select " + rm.schema() + " order by h.name";
        return this.jdbcTemplate.query(sql, (RowMapper)rm);
    }

    public HookData retrieveHook(Long hookId) {
        try {
            this.context.authenticatedUser();
            HookMapper rm = new HookMapper(this.jdbcTemplate);
            String sql = "select " + rm.schema() + " where h.id = ?";
            return (HookData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{hookId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new HookNotFoundException(hookId, e);
        }
    }

    @Cacheable(value={"hooks"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat('HK')")
    public List<Hook> retrieveHooksByEvent(String entityName, String actionName) {
        return this.hookRepository.findAllHooksListeningToEvent(entityName, actionName);
    }

    public HookData retrieveNewHookDetails(String templateName) {
        List templateData;
        this.context.authenticatedUser();
        TemplateMapper rm = new TemplateMapper(this.jdbcTemplate);
        if (templateName == null) {
            String sql = "select " + rm.schema() + " order by s.name";
            templateData = this.jdbcTemplate.query(sql, (RowMapper)rm);
        } else {
            String sql = "select " + rm.schema() + " where s.name = ? order by s.name";
            templateData = this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{templateName});
        }
        List events = this.getTemplateForEvents();
        return HookData.template((List)templateData, (List)events);
    }

    private List<Grouping> getTemplateForEvents() {
        String sql = "select p.grouping, p.entity_name, p.action_name from m_permission p  where p.action_name NOT LIKE '%CHECKER%' AND p.action_name NOT LIKE '%READ%'  order by p.grouping, p.entity_name ";
        EventResultSetExtractor extractor = new EventResultSetExtractor();
        return (List)this.jdbcTemplate.query("select p.grouping, p.entity_name, p.action_name from m_permission p  where p.action_name NOT LIKE '%CHECKER%' AND p.action_name NOT LIKE '%READ%'  order by p.grouping, p.entity_name ", (ResultSetExtractor)extractor);
    }

    @Generated
    public HookReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, HookRepository hookRepository, PlatformSecurityContext context) {
        this.jdbcTemplate = jdbcTemplate;
        this.hookRepository = hookRepository;
        this.context = context;
    }
}

