/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service.aggregationjob.listener;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.businessdate.domain.BusinessDateType;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.jobs.service.aggregationjob.domain.JournalEntryAggregationTrackingRepository;
import org.apache.fineract.infrastructure.jobs.service.aggregationjob.services.JournalEntryAggregationWriterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.stereotype.Component;

@Component
public class JournalEntryAggregationJobListener
implements JobExecutionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JournalEntryAggregationJobListener.class);
    private static final List<String> successJobStatus = List.of(ExitStatus.COMPLETED.getExitCode(), ExitStatus.NOOP.getExitCode());
    private final FineractProperties fineractProperties;
    private final JournalEntryAggregationTrackingRepository journalEntryAggregationTrackingRepository;
    private final JournalEntryAggregationWriterService journalEntryAggregationWriterService;

    public void beforeJob(JobExecution jobExecution) {
        log.info("Journal Entry Aggregation Job Started  jobName={}, jobExecutionId={}", (Object)"JOURNAL_ENTRY_AGGREGATION", (Object)jobExecution.getId());
        LocalDate providedAggregatedOnDate = (LocalDate)jobExecution.getExecutionContext().get("aggregatedOnDate");
        LocalDate aggregatedOnDate = providedAggregatedOnDate != null ? providedAggregatedOnDate.minusDays(this.fineractProperties.getJob().getJournalEntryAggregation().getExcludeRecentNDays().intValue()) : ThreadLocalContextUtil.getBusinessDateByType((BusinessDateType)BusinessDateType.BUSINESS_DATE).minusDays(this.fineractProperties.getJob().getJournalEntryAggregation().getExcludeRecentNDays().intValue());
        LocalDate lastAggregatedOnDate = this.journalEntryAggregationTrackingRepository.findLatestAggregatedOnDate();
        this.initializeDates(jobExecution, aggregatedOnDate, lastAggregatedOnDate);
    }

    private void initializeDates(JobExecution jobExecution, LocalDate aggregatedOnDate, LocalDate lastAggregatedOnDate) {
        jobExecution.getExecutionContext().put("aggregatedOnDate", (Object)aggregatedOnDate);
        jobExecution.getExecutionContext().put("aggregatedOnDateTo", (Object)aggregatedOnDate);
        if (lastAggregatedOnDate == null) {
            jobExecution.getExecutionContext().put("lastAggregatedOnDate", null);
            jobExecution.getExecutionContext().put("aggregatedOnDateFrom", (Object)LocalDate.of(1970, 1, 1));
        } else {
            jobExecution.getExecutionContext().put("lastAggregatedOnDate", (Object)lastAggregatedOnDate);
            jobExecution.getExecutionContext().put("aggregatedOnDateFrom", (Object)lastAggregatedOnDate);
        }
    }

    public void afterJob(JobExecution jobExecution) {
        if (!successJobStatus.contains(jobExecution.getExitStatus().getExitCode())) {
            this.journalEntryAggregationWriterService.rollbackJournalEntrySummary(jobExecution.getId());
            this.journalEntryAggregationWriterService.rollbackJournalEntryTracking(jobExecution.getId());
        }
        this.logJobExecutionSummary(jobExecution);
    }

    private void logJobExecutionSummary(JobExecution jobExecution) {
        LocalDate aggregatedOnDateFrom = (LocalDate)jobExecution.getExecutionContext().get("aggregatedOnDateFrom");
        LocalDate aggregatedOnDateTo = (LocalDate)jobExecution.getExecutionContext().get("aggregatedOnDateTo");
        Long jobExecutionId = jobExecution.getId();
        Long recordProcessCount = jobExecution.getStepExecutions().stream().filter(stepExecution -> stepExecution.getStepName().equals("JournalEntryAggregation Summary Insert - Step")).mapToLong(StepExecution::getWriteCount).sum();
        Instant startDateTime = jobExecution.getStartTime() != null ? jobExecution.getStartTime().toInstant(ZoneOffset.UTC) : null;
        Instant endDateTime = jobExecution.getEndTime() != null ? jobExecution.getEndTime().toInstant(ZoneOffset.UTC) : null;
        long jobDuration = 0L;
        Long startDateTimeMilliSecond = null;
        Long endDateTimeMilliSecond = null;
        if (startDateTime != null && endDateTime != null) {
            startDateTimeMilliSecond = startDateTime.toEpochMilli();
            endDateTimeMilliSecond = endDateTime.toEpochMilli();
            jobDuration = startDateTime.until(endDateTime, ChronoUnit.MINUTES);
        }
        log.info("Execution Summary for jobName={}, aggregatedDateFrom={}, aggregatedDateTo={}, totalRecordProcessCount={}, startTime={}, endTime={}, startTime_ms={}, endTime_ms={}, jobExecutionId={}, jobExecutionDurationInMinutes={}, tenantId={}", new Object[]{"JOURNAL_ENTRY_AGGREGATION", aggregatedOnDateFrom, aggregatedOnDateTo, recordProcessCount, startDateTime, endDateTime, startDateTimeMilliSecond, endDateTimeMilliSecond, jobExecutionId, jobDuration, ThreadLocalContextUtil.getTenant().getTenantIdentifier()});
    }

    @Generated
    public JournalEntryAggregationJobListener(FineractProperties fineractProperties, JournalEntryAggregationTrackingRepository journalEntryAggregationTrackingRepository, JournalEntryAggregationWriterService journalEntryAggregationWriterService) {
        this.fineractProperties = fineractProperties;
        this.journalEntryAggregationTrackingRepository = journalEntryAggregationTrackingRepository;
        this.journalEntryAggregationWriterService = journalEntryAggregationWriterService;
    }
}

