/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.data;

import com.google.gson.JsonElement;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccountTransfersDetailDataValidator {
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public AccountTransfersDetailDataValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validate(JsonCommand command, DataValidatorBuilder baseDataValidator) {
        JsonElement element = command.parsedJson();
        Long fromOfficeId = this.fromApiJsonHelper.extractLongNamed("fromOfficeId", element);
        baseDataValidator.reset().parameter("fromOfficeId").value((Object)fromOfficeId).notNull().integerGreaterThanZero();
        Long fromClientId = this.fromApiJsonHelper.extractLongNamed("fromClientId", element);
        baseDataValidator.reset().parameter("fromClientId").value((Object)fromClientId).notNull().integerGreaterThanZero();
        Long fromAccountId = this.fromApiJsonHelper.extractLongNamed("fromAccountId", element);
        baseDataValidator.reset().parameter("fromAccountId").value((Object)fromAccountId).notNull().integerGreaterThanZero();
        Integer fromAccountType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("fromAccountType", element);
        baseDataValidator.reset().parameter("fromAccountType").value((Object)fromAccountType).notNull().isOneOfTheseValues(new Object[]{1, 2});
        Long toOfficeId = this.fromApiJsonHelper.extractLongNamed("toOfficeId", element);
        baseDataValidator.reset().parameter("toOfficeId").value((Object)toOfficeId).notNull().integerGreaterThanZero();
        Long toClientId = this.fromApiJsonHelper.extractLongNamed("toClientId", element);
        baseDataValidator.reset().parameter("toClientId").value((Object)toClientId).notNull().integerGreaterThanZero();
        Long toAccountId = this.fromApiJsonHelper.extractLongNamed("toAccountId", element);
        baseDataValidator.reset().parameter("toAccountId").value((Object)toAccountId).notNull().integerGreaterThanZero();
        Integer toAccountType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("toAccountType", element);
        baseDataValidator.reset().parameter("toAccountType").value((Object)toAccountType).notNull().isOneOfTheseValues(new Object[]{1, 2});
    }
}

