/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.meeting.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MeetingDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private static final Set<String> MEETING_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("meetingDate", "locale", "dateFormat", "calendarId", "clientsAttendance"));

    @Autowired
    public MeetingDataValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForCreate(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)MEETING_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("meeting");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String meetingDateStr = this.fromApiJsonHelper.extractStringNamed("meetingDate", element);
        baseDataValidator.reset().parameter("meetingDate").value((Object)meetingDateStr).notBlank();
        if (!StringUtils.isBlank((CharSequence)meetingDateStr)) {
            LocalDate meetingDate = this.fromApiJsonHelper.extractLocalDateNamed("meetingDate", element);
            baseDataValidator.reset().parameter("meetingDate").value((Object)meetingDate).notNull();
        }
        Long calendarId = this.fromApiJsonHelper.extractLongNamed("calendarId", element);
        baseDataValidator.reset().parameter("calendarId").value((Object)calendarId).notNull();
        this.validateAttendanceDetails(element, baseDataValidator);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForUpdate(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)MEETING_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("meeting");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        if (this.fromApiJsonHelper.parameterExists("meetingDate", element)) {
            String meetingDateStr = this.fromApiJsonHelper.extractStringNamed("meetingDate", element);
            baseDataValidator.reset().parameter("meetingDate").value((Object)meetingDateStr).notBlank();
            if (!StringUtils.isBlank((CharSequence)meetingDateStr)) {
                LocalDate meetingDate = this.fromApiJsonHelper.extractLocalDateNamed("meetingDate", element);
                baseDataValidator.reset().parameter("meetingDate").value((Object)meetingDate).notNull();
            }
        }
        if (this.fromApiJsonHelper.parameterExists("calendarId", element)) {
            Long calendarId = this.fromApiJsonHelper.extractLongNamed("calendarId", element);
            baseDataValidator.reset().parameter("calendarId").value((Object)calendarId).notNull();
        }
        this.validateAttendanceDetails(element, baseDataValidator);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForUpdateAttendance(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)MEETING_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("meeting");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        this.validateAttendanceDetails(element, baseDataValidator);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    private void validateAttendanceDetails(JsonElement element, DataValidatorBuilder baseDataValidator) {
        JsonObject topLevelJsonElement = element.getAsJsonObject();
        if (element.isJsonObject() && topLevelJsonElement.has("clientsAttendance") && topLevelJsonElement.get("clientsAttendance").isJsonArray()) {
            JsonArray array = topLevelJsonElement.get("clientsAttendance").getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject attendanceElement = array.get(i).getAsJsonObject();
                Long clientId = this.fromApiJsonHelper.extractLongNamed("clientId", (JsonElement)attendanceElement);
                Long attendanceType = this.fromApiJsonHelper.extractLongNamed("attendanceType", (JsonElement)attendanceElement);
                baseDataValidator.reset().parameter("clientsAttendance[" + i + "].clientId").value((Object)clientId).notNull().integerGreaterThanZero();
                baseDataValidator.reset().parameter("clientsAttendance[" + i + "].attendanceType").value((Object)attendanceType).notNull().integerGreaterThanZero();
            }
        }
    }
}

