/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.loanaccount.data;

import com.google.gson.JsonElement;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.ApiParameterHelper;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.exception.UnsupportedParameterException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SelfLoansDataValidator {
    private static final Set<String> allowedAssociationParameters = new HashSet<String>(Arrays.asList("repaymentSchedule", "futureSchedule", "originalSchedule", "transactions", "charges", "guarantors", "collateral", "linkedAccount", "multiDisburseDetails"));
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public SelfLoansDataValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateRetrieveLoan(UriInfo uriInfo) {
        ArrayList<String> unsupportedParams = new ArrayList<String>();
        Set associationParameters = ApiParameterHelper.extractAssociationsForResponseIfProvided((MultivaluedMap)uriInfo.getQueryParameters());
        if (!associationParameters.isEmpty()) {
            associationParameters.removeAll(allowedAssociationParameters);
            if (!associationParameters.isEmpty()) {
                unsupportedParams.addAll(associationParameters);
            }
        }
        if (uriInfo.getQueryParameters().getFirst((Object)"exclude") != null) {
            unsupportedParams.add("exclude");
        }
        this.throwExceptionIfReqd(unsupportedParams);
    }

    public void validateRetrieveTransaction(UriInfo uriInfo) {
        ArrayList unsupportedParams = new ArrayList();
        this.validateTemplate(uriInfo, unsupportedParams);
        this.throwExceptionIfReqd(unsupportedParams);
    }

    public HashMap<String, Object> validateLoanApplication(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String loanTypeParameterName = "loanType";
        String loanTypeStr = this.fromApiJsonHelper.extractStringNamed("loanType", element);
        baseDataValidator.reset().parameter("loanType").value((Object)loanTypeStr).notNull().isOneOfTheseStringValues(new Object[]{"individual"});
        String clientIdParameterName = "clientId";
        String clientId = this.fromApiJsonHelper.extractStringNamed("clientId", element);
        baseDataValidator.reset().parameter("clientId").value((Object)clientId).notNull().longGreaterThanZero();
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        HashMap<String, Object> retAttr = new HashMap<String, Object>();
        retAttr.put("clientId", Long.parseLong(clientId));
        return retAttr;
    }

    public HashMap<String, Object> validateModifyLoanApplication(String json) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String loanTypeParameterName = "loanType";
        if (this.fromApiJsonHelper.parameterExists("loanType", element)) {
            String loanTypeStr = this.fromApiJsonHelper.extractStringNamed("loanType", element);
            baseDataValidator.reset().parameter("loanType").value((Object)loanTypeStr).notNull().isOneOfTheseStringValues(new Object[]{"individual"});
        }
        String clientIdParameterName = "clientId";
        String clientId = null;
        if (this.fromApiJsonHelper.parameterExists("clientId", element)) {
            clientId = this.fromApiJsonHelper.extractStringNamed("clientId", element);
            baseDataValidator.reset().parameter("clientId").value((Object)clientId).notNull().longGreaterThanZero();
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        HashMap<String, Object> retAttr = new HashMap<String, Object>();
        if (clientId != null) {
            retAttr.put("clientId", Long.parseLong(clientId));
        }
        return retAttr;
    }

    private void throwExceptionIfReqd(List<String> unsupportedParams) {
        if (unsupportedParams.size() > 0) {
            throw new UnsupportedParameterException(unsupportedParams);
        }
    }

    private void validateTemplate(UriInfo uriInfo, List<String> unsupportedParams) {
        boolean templateRequest = ApiParameterHelper.template((MultivaluedMap)uriInfo.getQueryParameters());
        if (templateRequest) {
            unsupportedParams.add("template");
        }
    }
}

