/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.plan.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.agents.api.context.RunnerContext;
import org.apache.flink.agents.api.event.ToolRequestEvent;
import org.apache.flink.agents.api.event.ToolResponseEvent;
import org.apache.flink.agents.api.resource.ResourceType;
import org.apache.flink.agents.api.tools.Tool;
import org.apache.flink.agents.api.tools.ToolParameters;
import org.apache.flink.agents.api.tools.ToolResponse;
import org.apache.flink.agents.plan.JavaFunction;
import org.apache.flink.agents.plan.actions.Action;

public class ToolCallAction {
    public static Action getToolCallAction() throws Exception {
        return new Action("tool_call_action", new JavaFunction(ToolCallAction.class, "processToolRequest", new Class[]{ToolRequestEvent.class, RunnerContext.class}), List.of(ToolRequestEvent.class.getName()));
    }

    public static void processToolRequest(ToolRequestEvent event, RunnerContext ctx) {
        HashMap<String, Boolean> success = new HashMap<String, Boolean>();
        HashMap<String, String> error = new HashMap<String, String>();
        HashMap<String, ToolResponse> responses = new HashMap<String, ToolResponse>();
        HashMap<String, String> externalIds = new HashMap<String, String>();
        for (Map<String, Object> toolCall : event.getToolCalls()) {
            String id = String.valueOf(toolCall.get("id"));
            Map function = (Map)toolCall.get("function");
            String name = (String)function.get("name");
            Map arguments = (Map)function.get("arguments");
            if (toolCall.containsKey("original_id")) {
                externalIds.put(id, (String)toolCall.get("original_id"));
            }
            Tool tool = null;
            try {
                tool = (Tool)ctx.getResource(name, ResourceType.TOOL);
            }
            catch (Exception e) {
                success.put(id, false);
                responses.put(id, ToolResponse.error(String.format("Tool %s does not exist.", name)));
                error.put(id, e.getMessage());
            }
            if (tool == null) continue;
            try {
                ToolResponse response = tool.call(new ToolParameters(arguments));
                success.put(id, true);
                responses.put(id, response);
            }
            catch (Exception e) {
                success.put(id, false);
                responses.put(id, ToolResponse.error(String.format("Tool %s execute failed.", name)));
                error.put(id, e.getMessage());
            }
        }
        ctx.sendEvent(new ToolResponseEvent(event.getId(), responses, success, error, externalIds));
    }
}

