/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.kafka.common.security.auth.SaslExtensionsCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslClientProvider;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslServerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthBearerLoginModule
implements LoginModule {
    public static final String OAUTHBEARER_MECHANISM = "OAUTHBEARER";
    private static final Logger log = LoggerFactory.getLogger(OAuthBearerLoginModule.class);
    private static final SaslExtensions EMPTY_EXTENSIONS = new SaslExtensions(Collections.emptyMap());
    private Subject subject = null;
    private AuthenticateCallbackHandler callbackHandler = null;
    private OAuthBearerToken tokenRequiringCommit = null;
    private OAuthBearerToken myCommittedToken = null;
    private SaslExtensions extensionsRequiringCommit = null;
    private SaslExtensions myCommittedExtensions = null;
    private LoginState loginState;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = Objects.requireNonNull(subject);
        if (!(Objects.requireNonNull(callbackHandler) instanceof AuthenticateCallbackHandler)) {
            throw new IllegalArgumentException(String.format("Callback handler must be castable to %s: %s", AuthenticateCallbackHandler.class.getName(), callbackHandler.getClass().getName()));
        }
        this.callbackHandler = (AuthenticateCallbackHandler)callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.loginState == LoginState.LOGGED_IN_NOT_COMMITTED) {
            if (this.tokenRequiringCommit != null) {
                throw new IllegalStateException(String.format("Already have an uncommitted token with private credential token count=%d", this.committedTokenCount()));
            }
            throw new IllegalStateException("Already logged in without a token");
        }
        if (this.loginState == LoginState.COMMITTED) {
            if (this.myCommittedToken != null) {
                throw new IllegalStateException(String.format("Already have a committed token with private credential token count=%d; must login on another login context or logout here first before reusing the same login context", this.committedTokenCount()));
            }
            throw new IllegalStateException("Login has already been committed without a token");
        }
        this.identifyToken();
        if (this.tokenRequiringCommit != null) {
            this.identifyExtensions();
        } else {
            log.debug("Logged in without a token, this login cannot be used to establish client connections");
        }
        this.loginState = LoginState.LOGGED_IN_NOT_COMMITTED;
        log.debug("Login succeeded; invoke commit() to commit it; current committed token count={}", (Object)this.committedTokenCount());
        return true;
    }

    private void identifyToken() throws LoginException {
        OAuthBearerTokenCallback tokenCallback = new OAuthBearerTokenCallback();
        try {
            this.callbackHandler.handle(new Callback[]{tokenCallback});
        }
        catch (IOException | UnsupportedCallbackException e) {
            log.error(e.getMessage(), e);
            throw new LoginException("An internal error occurred while retrieving token from callback handler");
        }
        this.tokenRequiringCommit = tokenCallback.token();
        if (tokenCallback.errorCode() != null) {
            log.info("Login failed: {} : {} (URI={})", tokenCallback.errorCode(), tokenCallback.errorDescription(), tokenCallback.errorUri());
            throw new LoginException(tokenCallback.errorDescription());
        }
    }

    private void identifyExtensions() throws LoginException {
        SaslExtensionsCallback extensionsCallback = new SaslExtensionsCallback();
        try {
            this.callbackHandler.handle(new Callback[]{extensionsCallback});
            this.extensionsRequiringCommit = extensionsCallback.extensions();
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
            throw new LoginException("An internal error occurred while retrieving SASL extensions from callback handler");
        }
        catch (UnsupportedCallbackException e) {
            this.extensionsRequiringCommit = EMPTY_EXTENSIONS;
            log.debug("CallbackHandler {} does not support SASL extensions. No extensions will be added", (Object)this.callbackHandler.getClass().getName());
        }
        if (this.extensionsRequiringCommit == null) {
            log.error("SASL Extensions cannot be null. Check whether your callback handler is explicitly setting them as null.");
            throw new LoginException("Extensions cannot be null.");
        }
    }

    @Override
    public boolean logout() {
        if (this.loginState == LoginState.LOGGED_IN_NOT_COMMITTED) {
            throw new IllegalStateException("Cannot call logout() immediately after login(); need to first invoke commit() or abort()");
        }
        if (this.loginState != LoginState.COMMITTED) {
            log.debug("Nothing here to log out");
            return false;
        }
        if (this.myCommittedToken != null) {
            log.trace("Logging out my token; current committed token count = {}", (Object)this.committedTokenCount());
            Iterator<Object> iterator = this.subject.getPrivateCredentials().iterator();
            while (iterator.hasNext()) {
                Object privateCredential = iterator.next();
                if (privateCredential != this.myCommittedToken) continue;
                iterator.remove();
                this.myCommittedToken = null;
                break;
            }
            log.debug("Done logging out my token; committed token count is now {}", (Object)this.committedTokenCount());
        } else {
            log.debug("No tokens to logout for this login");
        }
        if (this.myCommittedExtensions != null) {
            log.trace("Logging out my extensions");
            if (this.subject.getPublicCredentials().removeIf(e -> this.myCommittedExtensions == e)) {
                this.myCommittedExtensions = null;
            }
            log.debug("Done logging out my extensions");
        } else {
            log.debug("No extensions to logout for this login");
        }
        this.loginState = LoginState.NOT_LOGGED_IN;
        return true;
    }

    @Override
    public boolean commit() {
        if (this.loginState != LoginState.LOGGED_IN_NOT_COMMITTED) {
            log.debug("Nothing here to commit");
            return false;
        }
        if (this.tokenRequiringCommit != null) {
            log.trace("Committing my token; current committed token count = {}", (Object)this.committedTokenCount());
            this.subject.getPrivateCredentials().add(this.tokenRequiringCommit);
            this.myCommittedToken = this.tokenRequiringCommit;
            this.tokenRequiringCommit = null;
            log.debug("Done committing my token; committed token count is now {}", (Object)this.committedTokenCount());
        } else {
            log.debug("No tokens to commit, this login cannot be used to establish client connections");
        }
        if (this.extensionsRequiringCommit != null) {
            this.subject.getPublicCredentials().add(this.extensionsRequiringCommit);
            this.myCommittedExtensions = this.extensionsRequiringCommit;
            this.extensionsRequiringCommit = null;
        }
        this.loginState = LoginState.COMMITTED;
        return true;
    }

    @Override
    public boolean abort() {
        if (this.loginState == LoginState.LOGGED_IN_NOT_COMMITTED) {
            log.debug("Login aborted");
            this.tokenRequiringCommit = null;
            this.extensionsRequiringCommit = null;
            this.loginState = LoginState.NOT_LOGGED_IN;
            return true;
        }
        log.debug("Nothing here to abort");
        return false;
    }

    private int committedTokenCount() {
        return this.subject.getPrivateCredentials(OAuthBearerToken.class).size();
    }

    static {
        OAuthBearerSaslClientProvider.initialize();
        OAuthBearerSaslServerProvider.initialize();
    }

    private static enum LoginState {
        NOT_LOGGED_IN,
        LOGGED_IN_NOT_COMMITTED,
        COMMITTED;

    }
}

