/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1;

import java.util.function.Function;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.security.ResourcePermission;

public class ProtobufOperationContext<OperationRequest, OperationResponse> {
    private final ProtobufOperationHandler<OperationRequest, OperationResponse> operationHandler;
    private final Function<ClientProtocol.Message, OperationRequest> fromRequest;
    private final Function<OperationResponse, ClientProtocol.Message.Builder> toResponse;
    private final Function<ClientProtocol.ErrorResponse, ClientProtocol.Message.Builder> toErrorResponse;

    public ProtobufOperationContext(Function<ClientProtocol.Message, OperationRequest> fromRequest, ProtobufOperationHandler<OperationRequest, OperationResponse> operationHandler, Function<OperationResponse, ClientProtocol.Message.Builder> toResponse) {
        this.operationHandler = operationHandler;
        this.fromRequest = fromRequest;
        this.toResponse = toResponse;
        this.toErrorResponse = this::makeErrorBuilder;
    }

    protected ClientProtocol.Message.Builder makeErrorBuilder(ClientProtocol.ErrorResponse errorResponse) {
        return ClientProtocol.Message.newBuilder().setErrorResponse(errorResponse);
    }

    public ProtobufOperationHandler<OperationRequest, OperationResponse> getOperationHandler() {
        return this.operationHandler;
    }

    public Function<ClientProtocol.Message, OperationRequest> getFromRequest() {
        return this.fromRequest;
    }

    public Function<OperationResponse, ClientProtocol.Message.Builder> getToResponse() {
        return this.toResponse;
    }

    public Function<ClientProtocol.ErrorResponse, ClientProtocol.Message.Builder> getToErrorResponse() {
        return this.toErrorResponse;
    }

    @FunctionalInterface
    public static interface PermissionFunction<OperationRequest> {
        public ResourcePermission apply(OperationRequest var1, ProtobufSerializationService var2) throws DecodingException;
    }
}

