/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.security.SecureFunctionService;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.FunctionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.Success;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.EncodingException;
import org.apache.geode.internal.protocol.protobuf.v1.state.exception.ConnectionStateException;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ExecuteFunctionOnRegionRequestOperationHandler
implements ProtobufOperationHandler<FunctionAPI.ExecuteFunctionOnRegionRequest, FunctionAPI.ExecuteFunctionOnRegionResponse> {
    private static final Logger logger = LogService.getLogger();

    @Override
    public Result<FunctionAPI.ExecuteFunctionOnRegionResponse> process(ProtobufSerializationService serializationService, FunctionAPI.ExecuteFunctionOnRegionRequest request, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException, ConnectionStateException, EncodingException, DecodingException {
        String functionID = request.getFunctionID();
        String regionName = request.getRegion();
        Object arguments = this.getFunctionArguments(request, serializationService);
        Set<Object> filter = this.parseFilter(serializationService, request);
        SecureFunctionService functionService = messageExecutionContext.getSecureCache().getFunctionService();
        List<Object> results = functionService.executeFunctionOnRegion(functionID, regionName, arguments, filter);
        FunctionAPI.ExecuteFunctionOnRegionResponse.Builder responseMessage = FunctionAPI.ExecuteFunctionOnRegionResponse.newBuilder();
        for (Object result : results) {
            responseMessage.addResults(serializationService.encode(result));
        }
        return Success.of(responseMessage.build());
    }

    private Set<Object> parseFilter(ProtobufSerializationService serializationService, FunctionAPI.ExecuteFunctionOnRegionRequest request) throws DecodingException {
        List<BasicTypes.EncodedValue> encodedFilter = request.getKeyFilterList();
        HashSet<Object> filter = new HashSet<Object>();
        for (BasicTypes.EncodedValue filterKey : encodedFilter) {
            filter.add(serializationService.decode(filterKey));
        }
        return filter;
    }

    private Object getFunctionArguments(FunctionAPI.ExecuteFunctionOnRegionRequest request, ProtobufSerializationService serializationService) throws DecodingException {
        if (request.hasArguments()) {
            return serializationService.decode(request.getArguments());
        }
        return null;
    }
}

