/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Cache;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.cli.Disabled;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.CommandManagerAware;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.VersionCommand;
import org.apache.geode.management.internal.cli.help.Helper;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.util.ClasspathScanLoadHelper;
import org.springframework.shell.converters.EnumConverter;
import org.springframework.shell.converters.SimpleFileConverter;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;

public class CommandManager {
    private static final String USER_CMD_PACKAGES_PROPERTY = "gemfire.user-command-packages";
    private static final String USER_CMD_PACKAGES_ENV_VARIABLE = "GEMFIRE_USER_COMMAND_PACKAGES";
    private final Helper helper = new Helper();
    private final List<Converter<?>> converters = new ArrayList();
    private final List<CommandMarker> commandMarkers = new ArrayList<CommandMarker>();
    private Properties cacheProperties;
    private LogWrapper logWrapper;
    private InternalCache cache;
    @Immutable
    private static final List<Class> SHL_CONVERTERS_TOSKIP = Collections.unmodifiableList(Arrays.asList(SimpleFileConverter.class, EnumConverter.class));

    public CommandManager() {
        this(null, null);
    }

    public CommandManager(Properties cacheProperties, InternalCache cache) {
        if (cacheProperties != null) {
            this.cacheProperties = cacheProperties;
        }
        this.cache = cache;
        this.logWrapper = LogWrapper.getInstance((Cache)cache);
        this.loadCommands();
    }

    private static void raiseExceptionIfEmpty(Set<Class<?>> foundClasses, String errorFor) throws IllegalStateException {
        if (foundClasses == null || foundClasses.isEmpty()) {
            throw new IllegalStateException("Required " + errorFor + " classes were not loaded. Check logs for errors.");
        }
    }

    private Set<String> getUserCommandPackages() {
        String cacheUserCmdPackages;
        HashSet<String> userCommandPackages = new HashSet<String>();
        ArrayList<String> userCommandSources = new ArrayList<String>();
        if (System.getProperty(USER_CMD_PACKAGES_PROPERTY) != null) {
            userCommandSources.add(System.getProperty(USER_CMD_PACKAGES_PROPERTY));
        }
        if (System.getenv().containsKey(USER_CMD_PACKAGES_ENV_VARIABLE)) {
            userCommandSources.add(System.getenv().get(USER_CMD_PACKAGES_ENV_VARIABLE));
        }
        if (this.cacheProperties != null && (cacheUserCmdPackages = this.cacheProperties.getProperty("user-command-packages")) != null && !cacheUserCmdPackages.isEmpty()) {
            userCommandSources.add(cacheUserCmdPackages);
        }
        for (String source : userCommandSources) {
            userCommandPackages.addAll(Arrays.asList(source.split(",")));
        }
        return userCommandPackages;
    }

    private void loadUserCommands(ClasspathScanLoadHelper scanner, Set<String> restrictedToPackages) {
        if (restrictedToPackages.size() == 0) {
            return;
        }
        try {
            Set foundClasses = scanner.scanPackagesForClassesImplementing(CommandMarker.class, restrictedToPackages.toArray(new String[0]));
            for (Class klass : foundClasses) {
                try {
                    this.add((CommandMarker)klass.newInstance());
                }
                catch (Exception e) {
                    this.logWrapper.warning("Could not load User Commands from: " + klass + " due to " + e.getLocalizedMessage());
                }
            }
            CommandManager.raiseExceptionIfEmpty(foundClasses, "User Command");
        }
        catch (IllegalStateException e) {
            this.logWrapper.warning(e.getMessage(), e);
            throw e;
        }
    }

    private void loadPluginCommands() {
        ServiceLoader<CommandMarker> loader = ServiceLoader.load(CommandMarker.class, ClassPathLoader.getLatest().asClassLoader());
        Iterator<CommandMarker> iterator = loader.iterator();
        try {
            while (iterator.hasNext()) {
                try {
                    this.add(iterator.next());
                }
                catch (Throwable t) {
                    this.logWrapper.warning("Could not load plugin command: " + t.getMessage());
                }
            }
        }
        catch (Throwable th) {
            this.logWrapper.severe("Could not load plugin commands in the latest classLoader.", th);
        }
    }

    private void loadCommands() {
        Set<String> userCommandPackages = this.getUserCommandPackages();
        HashSet<String> packagesToScan = new HashSet<String>(userCommandPackages);
        packagesToScan.add("org.apache.geode.management.internal.cli.converters");
        packagesToScan.add("org.springframework.shell.converters");
        packagesToScan.add(GfshCommand.class.getPackage().getName());
        packagesToScan.add(VersionCommand.class.getPackage().getName());
        try (ClasspathScanLoadHelper scanner = new ClasspathScanLoadHelper(packagesToScan);){
            this.loadUserCommands(scanner, userCommandPackages);
            this.loadPluginCommands();
            this.loadGeodeCommands(scanner);
            this.loadConverters(scanner);
        }
    }

    private void loadConverters(ClasspathScanLoadHelper scanner) {
        try {
            Set foundClasses = scanner.scanPackagesForClassesImplementing(Converter.class, new String[]{"org.apache.geode.management.internal.cli.converters"});
            for (Class klass : foundClasses) {
                try {
                    Converter object = (Converter)klass.newInstance();
                    this.add(object);
                }
                catch (Exception e) {
                    this.logWrapper.warning("Could not load Converter from: " + klass + " due to " + e.getLocalizedMessage());
                }
            }
            CommandManager.raiseExceptionIfEmpty(foundClasses, "Converters");
            foundClasses = scanner.scanPackagesForClassesImplementing(Converter.class, new String[]{"org.springframework.shell.converters"});
            for (Class klass : foundClasses) {
                if (SHL_CONVERTERS_TOSKIP.contains(klass)) continue;
                try {
                    this.add((Converter)klass.newInstance());
                }
                catch (Exception e) {
                    this.logWrapper.warning("Could not load Converter from: " + klass + " due to " + e.getLocalizedMessage());
                }
            }
            CommandManager.raiseExceptionIfEmpty(foundClasses, "Basic Converters");
        }
        catch (IllegalStateException e) {
            this.logWrapper.warning(e.getMessage(), e);
            throw e;
        }
    }

    private void loadGeodeCommands(ClasspathScanLoadHelper scanner) {
        try {
            Set foundClasses = scanner.scanPackagesForClassesImplementing(CommandMarker.class, new String[]{GfshCommand.class.getPackage().getName(), VersionCommand.class.getPackage().getName()});
            for (Class klass : foundClasses) {
                try {
                    this.add((CommandMarker)klass.newInstance());
                }
                catch (Exception e) {
                    this.logWrapper.warning("Could not load Command from: " + klass + " due to " + e.getLocalizedMessage());
                }
            }
            CommandManager.raiseExceptionIfEmpty(foundClasses, "Commands");
        }
        catch (IllegalStateException e) {
            this.logWrapper.warning(e.getMessage(), e);
            throw e;
        }
    }

    public List<Converter<?>> getConverters() {
        return this.converters;
    }

    public List<CommandMarker> getCommandMarkers() {
        return this.commandMarkers;
    }

    private void add(Converter<?> converter) {
        if (CommandManagerAware.class.isAssignableFrom(converter.getClass())) {
            ((CommandManagerAware)((Object)converter)).setCommandManager(this);
        }
        this.converters.add(converter);
    }

    void add(CommandMarker commandMarker) {
        Disabled classDisabled = commandMarker.getClass().getAnnotation(Disabled.class);
        if (classDisabled != null && (classDisabled.unlessPropertyIsSet().isEmpty() || System.getProperty(classDisabled.unlessPropertyIsSet()) == null)) {
            return;
        }
        if (GfshCommand.class.isAssignableFrom(commandMarker.getClass())) {
            ((GfshCommand)commandMarker).setCache((Cache)this.cache);
        }
        if (CommandManagerAware.class.isAssignableFrom(commandMarker.getClass())) {
            ((CommandManagerAware)((Object)commandMarker)).setCommandManager(this);
        }
        this.commandMarkers.add(commandMarker);
        for (Method method : commandMarker.getClass().getMethods()) {
            CliCommand cliCommand = method.getAnnotation(CliCommand.class);
            CliAvailabilityIndicator availability = method.getAnnotation(CliAvailabilityIndicator.class);
            if (cliCommand == null && availability == null) continue;
            if (cliCommand != null) {
                this.helper.addCommand(cliCommand, method);
            }
            if (availability == null) continue;
            this.helper.addAvailabilityIndicator(availability, new MethodTarget(method, commandMarker));
        }
    }

    public Helper getHelper() {
        return this.helper;
    }

    public String obtainHelp(String buffer) {
        int terminalWidth = -1;
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh != null) {
            terminalWidth = gfsh.getTerminalWidth();
        }
        return this.helper.getHelp(buffer, terminalWidth);
    }

    public String obtainHint(String topic) {
        return this.helper.getHint(topic);
    }
}

