/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashSet;
import java.util.Properties;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.management.internal.cli.domain.DiskStoreDetails;

public class ListDiskStoresFunction
implements InternalFunction<Void> {
    public void init(Properties props) {
    }

    public String getId() {
        return this.getClass().getName();
    }

    public void execute(FunctionContext<Void> context) {
        HashSet<DiskStoreDetails> memberDiskStores = new HashSet<DiskStoreDetails>();
        try {
            Cache cache = context.getCache();
            if (cache instanceof InternalCache) {
                InternalCache gemfireCache = (InternalCache)cache;
                InternalDistributedMember member = gemfireCache.getMyId();
                for (DiskStore memberDiskStore : gemfireCache.listDiskStoresIncludingRegionOwned()) {
                    memberDiskStores.add(new DiskStoreDetails(memberDiskStore.getDiskStoreUUID(), memberDiskStore.getName(), member.getId(), member.getName()));
                }
            }
            context.getResultSender().lastResult(memberDiskStores);
        }
        catch (Exception e) {
            context.getResultSender().sendException((Throwable)e);
        }
    }
}

