/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal.pooling;

import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SplittableRandom;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.client.AllConnectionsInUseException;
import org.apache.geode.cache.client.NoAvailableServersException;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.ServerRefusedConnectionException;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionFactory;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.EndpointManager;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.pooling.AvailableConnectionManager;
import org.apache.geode.cache.client.internal.pooling.ConnectionAccounting;
import org.apache.geode.cache.client.internal.pooling.ConnectionManager;
import org.apache.geode.cache.client.internal.pooling.PooledConnection;
import org.apache.geode.distributed.PoolCancelledException;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.PoolManagerImpl;
import org.apache.geode.internal.cache.PoolStats;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class ConnectionManagerImpl
implements ConnectionManager {
    private static final Logger logger = LogService.getLogger();
    private static final int NOT_WAITING = -1;
    public static final String BORROW_CONN_ERROR_MSG = "Could not create a new connection to server ";
    public static final String UNEXPECTED_SOCKET_CLOSED_MSG = "Pool unexpected closed socket on server";
    public static final String SOCKET_TIME_OUT_MSG = "socket timed out on client";
    private final String poolName;
    private final PoolStats poolStats;
    private final long prefillRetry;
    private final AvailableConnectionManager availableConnectionManager = new AvailableConnectionManager();
    protected final ConnectionMap allConnectionsMap = new ConnectionMap();
    private final EndpointManager endpointManager;
    private final long idleTimeout;
    private final long idleTimeoutNanos;
    private final int lifetimeTimeout;
    private final long lifetimeTimeoutNanos;
    private final InternalLogWriter securityLogWriter;
    protected final CancelCriterion cancelCriterion;
    private final ConnectionAccounting connectionAccounting;
    private ScheduledExecutorService backgroundProcessor;
    private ScheduledExecutorService loadConditioningProcessor;
    private ConnectionFactory connectionFactory;
    private boolean haveIdleExpireConnectionsTask;
    private final AtomicBoolean havePrefillTask = new AtomicBoolean(false);
    private boolean keepAlive = false;
    protected final AtomicBoolean shuttingDown = new AtomicBoolean(false);
    private EndpointManager.EndpointListenerAdapter endpointListener;

    static int addVarianceToInterval(int interval) {
        if (1 <= interval) {
            SplittableRandom random = new SplittableRandom();
            int variance = interval < 10 ? 1 : 1 + random.nextInt(interval / 10 - 1);
            int sign = random.nextBoolean() ? 1 : -1;
            return interval + sign * variance;
        }
        return interval;
    }

    public ConnectionManagerImpl(String poolName, ConnectionFactory factory, EndpointManager endpointManager, int maxConnections, int minConnections, long idleTimeout, int lifetimeTimeout, InternalLogWriter securityLogger, long pingInterval, CancelCriterion cancelCriterion, PoolStats poolStats) {
        this.poolName = poolName;
        this.poolStats = poolStats;
        if (maxConnections < minConnections && maxConnections != -1) {
            throw new IllegalArgumentException("Max connections " + maxConnections + " is less than minConnections " + minConnections);
        }
        if (maxConnections <= 0 && maxConnections != -1) {
            throw new IllegalArgumentException("Max connections " + maxConnections + " must be greater than 0");
        }
        if (minConnections < 0) {
            throw new IllegalArgumentException("Min connections " + minConnections + " must be greater than or equals to 0");
        }
        this.connectionFactory = factory;
        this.endpointManager = endpointManager;
        this.connectionAccounting = new ConnectionAccounting(minConnections, maxConnections == -1 ? Integer.MAX_VALUE : maxConnections);
        this.lifetimeTimeout = ConnectionManagerImpl.addVarianceToInterval(lifetimeTimeout);
        this.lifetimeTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(this.lifetimeTimeout);
        if (this.lifetimeTimeout != -1 && (idleTimeout > (long)this.lifetimeTimeout || idleTimeout == -1L)) {
            idleTimeout = this.lifetimeTimeout;
        }
        this.idleTimeout = idleTimeout;
        this.idleTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(this.idleTimeout);
        this.securityLogWriter = securityLogger;
        this.prefillRetry = pingInterval;
        this.cancelCriterion = cancelCriterion;
        this.endpointListener = new EndpointManager.EndpointListenerAdapter(){

            @Override
            public void endpointCrashed(Endpoint endpoint) {
                ConnectionManagerImpl.this.invalidateServer(endpoint);
            }
        };
    }

    private void destroyAndMaybePrefill() {
        this.destroyAndMaybePrefill(1);
    }

    private void destroyAndMaybePrefill(int count) {
        if (this.connectionAccounting.destroyAndIsUnderMinimum(count)) {
            this.startBackgroundPrefill();
        }
    }

    private PooledConnection createPooledConnection() throws NoAvailableServersException, ServerOperationException {
        return this.createPooledConnection(Collections.emptySet());
    }

    private PooledConnection createPooledConnection(Set<ServerLocation> excludedServers) throws NoAvailableServersException, ServerOperationException {
        try {
            return this.addConnection(this.connectionFactory.createClientToServerConnection(excludedServers));
        }
        catch (GemFireSecurityException e) {
            throw new ServerOperationException(e);
        }
        catch (ServerRefusedConnectionException e) {
            throw new NoAvailableServersException(e);
        }
    }

    private PooledConnection createPooledConnection(ServerLocation serverLocation) throws ServerRefusedConnectionException, GemFireSecurityException {
        return this.addConnection(this.connectionFactory.createClientToServerConnection(serverLocation, false));
    }

    private PooledConnection forceCreateConnection(ServerLocation serverLocation) throws ServerRefusedConnectionException, ServerOperationException {
        this.connectionAccounting.create();
        try {
            return this.createPooledConnection(serverLocation);
        }
        catch (GemFireSecurityException e) {
            throw new ServerOperationException(e);
        }
    }

    private PooledConnection forceCreateConnection(Set<ServerLocation> excludedServers) throws NoAvailableServersException, ServerOperationException {
        this.connectionAccounting.create();
        return this.createPooledConnection(excludedServers);
    }

    private boolean checkShutdownInterruptedOrTimeout(long timeout) throws PoolCancelledException {
        if (this.shuttingDown.get()) {
            throw new PoolCancelledException();
        }
        if (Thread.currentThread().isInterrupted()) {
            return true;
        }
        return timeout <= System.nanoTime();
    }

    private long beginConnectionWaitStatIfNotStarted(long waitStart) {
        if (-1L == waitStart) {
            return this.getPoolStats().beginConnectionWait();
        }
        return waitStart;
    }

    private void endConnectionWaitStatIfStarted(long waitStart) {
        if (-1L != waitStart) {
            this.getPoolStats().endConnectionWait(waitStart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection borrowConnection(long acquireTimeout) throws AllConnectionsInUseException, NoAvailableServersException, ServerOperationException {
        long waitStart = -1L;
        try {
            long timeout = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(acquireTimeout);
            while (true) {
                Connection connection;
                if (null != (connection = this.availableConnectionManager.useFirst())) {
                    Connection connection2 = connection;
                    return connection2;
                }
                if (this.connectionAccounting.tryCreate()) {
                    try {
                        connection = this.createPooledConnection();
                        if (null != connection) {
                            Connection connection3 = connection;
                            return connection3;
                        }
                        throw new NoAvailableServersException();
                    }
                    finally {
                        if (connection == null) {
                            this.connectionAccounting.cancelTryCreate();
                            if (this.connectionAccounting.isUnderMinimum()) {
                                this.startBackgroundPrefill();
                            }
                        }
                    }
                }
                if (this.checkShutdownInterruptedOrTimeout(timeout)) {
                    break;
                }
                waitStart = this.beginConnectionWaitStatIfNotStarted(waitStart);
                Thread.yield();
            }
        }
        finally {
            this.endConnectionWaitStatIfStarted(waitStart);
        }
        this.cancelCriterion.checkCancelInProgress(null);
        throw new AllConnectionsInUseException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection borrowConnection(ServerLocation server, long acquireTimeout, boolean onlyUseExistingCnx) throws AllConnectionsInUseException, NoAvailableServersException, ServerConnectivityException {
        logger.trace("Connection borrowConnection single hop connection");
        long waitStart = -1L;
        try {
            long timeout = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(acquireTimeout);
            while (true) {
                Connection connection;
                if (null != (connection = this.availableConnectionManager.useFirst(c -> c.getServer().equals(server)))) {
                    Connection connection2 = connection;
                    return connection2;
                }
                if (!onlyUseExistingCnx) {
                    connection = this.forceCreateConnection(server);
                    if (null != connection) {
                        Connection connection3 = connection;
                        return connection3;
                    }
                    throw new ServerConnectivityException(BORROW_CONN_ERROR_MSG + server);
                }
                if (this.checkShutdownInterruptedOrTimeout(timeout)) {
                    break;
                }
                waitStart = this.beginConnectionWaitStatIfNotStarted(waitStart);
                Thread.yield();
            }
        }
        finally {
            this.endConnectionWaitStatIfStarted(waitStart);
        }
        this.cancelCriterion.checkCancelInProgress(null);
        throw new AllConnectionsInUseException();
    }

    @Override
    public Connection exchangeConnection(Connection oldConnection, Set<ServerLocation> excludedServers) throws AllConnectionsInUseException {
        try {
            Connection connection = this.availableConnectionManager.useFirst(c -> !excludedServers.contains(c.getServer()));
            if (null != connection) {
                Connection connection2 = connection;
                return connection2;
            }
            connection = this.forceCreateConnection(excludedServers);
            if (null != connection) {
                Connection connection3 = connection;
                return connection3;
            }
            throw new NoAvailableServersException();
        }
        finally {
            this.returnConnection(oldConnection, true, true);
        }
    }

    protected String getPoolName() {
        return this.poolName;
    }

    private PooledConnection addConnection(Connection conn) {
        if (conn == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to create a connection in the allowed time");
            }
            return null;
        }
        PooledConnection pooledConn = new PooledConnection(this, conn);
        this.allConnectionsMap.addConnection(pooledConn);
        if (logger.isDebugEnabled()) {
            logger.debug("Created a new connection. {} Connection count is now {}", (Object)pooledConn, (Object)this.connectionAccounting.getCount());
        }
        return pooledConn;
    }

    private void destroyConnection(PooledConnection connection) {
        if (this.allConnectionsMap.removeConnection(connection)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Invalidating connection {} connection count is now {}", (Object)connection, (Object)this.connectionAccounting.getCount());
            }
            this.destroyAndMaybePrefill();
        }
        connection.internalDestroy();
    }

    private void invalidateServer(Endpoint endpoint) {
        Set<PooledConnection> badConnections = this.allConnectionsMap.removeEndpoint(endpoint);
        if (badConnections == null) {
            return;
        }
        if (this.shuttingDown.get()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Invalidating {} connections to server {}", (Object)badConnections.size(), (Object)endpoint);
        }
        for (PooledConnection conn : badConnections) {
            if (!conn.internalDestroy()) continue;
            this.destroyAndMaybePrefill();
            this.availableConnectionManager.remove(conn);
        }
    }

    @Override
    public void returnConnection(Connection connection) {
        this.returnConnection(connection, true);
    }

    @Override
    public void returnConnection(Connection connection, boolean accessed) {
        this.returnConnection(connection, accessed, false);
    }

    private void returnConnection(Connection connection, boolean accessed, boolean addLast) {
        assert (connection instanceof PooledConnection);
        PooledConnection pooledConn = (PooledConnection)connection;
        if (pooledConn.isDestroyed()) {
            return;
        }
        if (pooledConn.shouldDestroy()) {
            this.destroyConnection(pooledConn);
        } else if (!this.destroyIfOverLimit(pooledConn)) {
            if (addLast) {
                this.availableConnectionManager.addLast(pooledConn, accessed);
            } else {
                this.availableConnectionManager.addFirst(pooledConn, accessed);
            }
        }
    }

    private boolean destroyIfOverLimit(PooledConnection connection) {
        if (this.connectionAccounting.tryDestroy()) {
            if (this.allConnectionsMap.removeConnection(connection)) {
                try {
                    PoolImpl localpool = (PoolImpl)PoolManagerImpl.getPMI().find(this.poolName);
                    boolean durable = false;
                    if (localpool != null) {
                        durable = localpool.isDurableClient();
                    }
                    connection.internalClose(durable || this.keepAlive);
                }
                catch (Exception e) {
                    logger.warn(String.format("Error closing connection %s", connection), (Throwable)e);
                }
            } else {
                this.connectionAccounting.cancelTryDestroy();
            }
            return true;
        }
        return false;
    }

    @Override
    public void start(ScheduledExecutorService backgroundProcessor) {
        this.backgroundProcessor = backgroundProcessor;
        String name = "poolLoadConditioningMonitor-" + this.getPoolName();
        this.loadConditioningProcessor = LoggingExecutors.newScheduledThreadPool((String)name, (int)1, (boolean)false);
        this.endpointManager.addListener(this.endpointListener);
        this.startBackgroundPrefill();
    }

    @Override
    public void close(boolean keepAlive) {
        if (logger.isDebugEnabled()) {
            logger.debug("Shutting down connection manager with keepAlive {}", (Object)keepAlive);
        }
        this.keepAlive = keepAlive;
        this.endpointManager.removeListener(this.endpointListener);
        if (!this.shuttingDown.compareAndSet(false, true)) {
            return;
        }
        try {
            if (this.loadConditioningProcessor != null) {
                this.loadConditioningProcessor.shutdown();
                if (!this.loadConditioningProcessor.awaitTermination(PoolImpl.SHUTDOWN_TIMEOUT, TimeUnit.MILLISECONDS)) {
                    logger.warn("Timeout waiting for load conditioning tasks to complete");
                }
            }
        }
        catch (RuntimeException e) {
            logger.error("Error stopping loadConditioningProcessor", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error("Interrupted stopping loadConditioningProcessor", (Throwable)e);
        }
        this.allConnectionsMap.close(keepAlive);
    }

    @Override
    public void emergencyClose() {
        this.shuttingDown.set(true);
        if (this.loadConditioningProcessor != null) {
            this.loadConditioningProcessor.shutdown();
        }
        this.allConnectionsMap.emergencyClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startBackgroundExpiration() {
        if (this.idleTimeout >= 0L) {
            ConnectionMap connectionMap = this.allConnectionsMap;
            synchronized (connectionMap) {
                if (!this.haveIdleExpireConnectionsTask) {
                    this.haveIdleExpireConnectionsTask = true;
                    try {
                        this.backgroundProcessor.schedule(new IdleExpireConnectionsTask(), this.idleTimeout, TimeUnit.MILLISECONDS);
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected void startBackgroundPrefill() {
        if (this.havePrefillTask.compareAndSet(false, true)) {
            try {
                this.backgroundProcessor.execute(new PrefillConnectionsTask());
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    private void prefill() {
        try {
            while (this.connectionAccounting.isUnderMinimum()) {
                if (this.cancelCriterion.isCancelInProgress()) {
                    return;
                }
                boolean createdConnection = this.prefillConnection();
                if (createdConnection) continue;
                return;
            }
        }
        catch (Throwable t) {
            this.cancelCriterion.checkCancelInProgress(t);
            if (t.getCause() != null) {
                t = t.getCause();
            }
            this.logInfo("Error prefilling connections", t);
        }
    }

    @Override
    public int getConnectionCount() {
        return this.connectionAccounting.getCount();
    }

    protected PoolStats getPoolStats() {
        return this.poolStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prefillConnection() {
        if (this.shuttingDown.get()) {
            return false;
        }
        if (this.connectionAccounting.tryPrefill()) {
            boolean bl;
            block15: {
                PooledConnection connection;
                block13: {
                    boolean bl2;
                    block14: {
                        connection = null;
                        connection = this.createPooledConnection();
                        if (connection != null) break block13;
                        bl2 = false;
                        if (connection != null) break block14;
                        this.connectionAccounting.cancelTryPrefill();
                        if (logger.isDebugEnabled()) {
                            logger.debug("Unable to prefill pool to minimum, connection count is now {}", new Supplier[]{this::getConnectionCount});
                        }
                    }
                    return bl2;
                }
                try {
                    this.getPoolStats().incPrefillConnect();
                    this.availableConnectionManager.addLast(connection, false);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Prefilled connection {} connection count is now {}", (Object)connection, (Object)this.connectionAccounting.getCount());
                    }
                    bl = true;
                    if (connection != null) break block15;
                }
                catch (ServerConnectivityException ex) {
                    boolean bl3;
                    block16: {
                        try {
                            logger.info(String.format("Unable to prefill pool to minimum because: %s", ex.getMessage()));
                            bl3 = false;
                            if (connection != null) break block16;
                            this.connectionAccounting.cancelTryPrefill();
                        }
                        catch (Throwable throwable) {
                            if (connection == null) {
                                this.connectionAccounting.cancelTryPrefill();
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Unable to prefill pool to minimum, connection count is now {}", new Supplier[]{this::getConnectionCount});
                                }
                            }
                            throw throwable;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("Unable to prefill pool to minimum, connection count is now {}", new Supplier[]{this::getConnectionCount});
                        }
                    }
                    return bl3;
                }
                this.connectionAccounting.cancelTryPrefill();
                if (logger.isDebugEnabled()) {
                    logger.debug("Unable to prefill pool to minimum, connection count is now {}", new Supplier[]{this::getConnectionCount});
                }
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerReplacementConnection(Connection con, ServerLocation currentServer) {
        boolean retry;
        do {
            retry = false;
            PooledConnection target = this.allConnectionsMap.findReplacementTarget(currentServer);
            if (target == null) continue;
            Endpoint targetEP = target.getEndpoint();
            boolean interrupted = false;
            try {
                if (target.switchConnection(con)) {
                    this.getPoolStats().incLoadConditioningDisconnect();
                    this.allConnectionsMap.addReplacedCnx(target, targetEP);
                    return;
                }
                retry = true;
            }
            catch (InterruptedException e) {
                interrupted = true;
                this.cancelCriterion.checkCancelInProgress(e);
                retry = false;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        } while (retry);
        this.getPoolStats().incLoadConditioningReplaceTimeouts();
        con.destroy();
    }

    private boolean createLifetimeReplacementConnection(ServerLocation currentServer) {
        HashSet<ServerLocation> excludedServers = new HashSet<ServerLocation>();
        while (true) {
            ServerLocation sl;
            if ((sl = this.connectionFactory.findBestServer(currentServer, excludedServers)) == null || sl.equals(currentServer)) {
                this.allConnectionsMap.extendLifeOfCnxToServer(currentServer);
                break;
            }
            if (!this.allConnectionsMap.hasExpiredCnxToServer(currentServer)) break;
            try {
                Connection con = this.connectionFactory.createClientToServerConnection(sl, false);
                if (con != null) {
                    this.getPoolStats().incLoadConditioningConnect();
                    if (this.allConnectionsMap.hasExpiredCnxToServer(currentServer)) {
                        this.offerReplacementConnection(con, currentServer);
                        break;
                    }
                    this.getPoolStats().incLoadConditioningReplaceTimeouts();
                    con.destroy();
                    break;
                }
            }
            catch (GemFireSecurityException e) {
                this.securityLogWriter.warning(String.format("Security exception connecting to server '%s': %s", sl, e));
            }
            catch (ServerRefusedConnectionException srce) {
                logger.warn("Server '{}' refused new connection: {}", (Object)sl, (Object)srce.getMessage());
            }
            excludedServers.add(sl);
        }
        return this.allConnectionsMap.checkForReschedule(true);
    }

    private void logInfo(String message, Throwable t) {
        if (t instanceof GemFireSecurityException) {
            this.securityLogWriter.info(String.format("%s : %s", message, t), t);
        } else {
            logger.info(String.format("%s : %s", message, t), t);
        }
    }

    private static class ClosedPoolConnectionList
    extends ArrayList<PooledConnection> {
        private ClosedPoolConnectionList() {
        }

        @Override
        public PooledConnection set(int index, PooledConnection element) {
            throw new CacheClosedException("This pool has been closed");
        }

        @Override
        public boolean add(PooledConnection element) {
            throw new CacheClosedException("This pool has been closed");
        }

        @Override
        public void add(int index, PooledConnection element) {
            throw new CacheClosedException("This pool has been closed");
        }

        @Override
        public PooledConnection remove(int index) {
            throw new CacheClosedException("This pool has been closed");
        }

        @Override
        public boolean addAll(Collection c) {
            throw new CacheClosedException("This pool has been closed");
        }

        @Override
        public boolean addAll(int index, Collection c) {
            throw new CacheClosedException("This pool has been closed");
        }
    }

    protected class ConnectionMap {
        private final Map<Endpoint, Set<PooledConnection>> map = new HashMap<Endpoint, Set<PooledConnection>>();
        private List<PooledConnection> allConnections = new LinkedList<PooledConnection>();
        private boolean haveLifetimeExpireConnectionsTask;
        volatile boolean closing;

        protected ConnectionMap() {
        }

        synchronized boolean isIdleExpirePossible() {
            return this.allConnections.size() > ConnectionManagerImpl.this.connectionAccounting.getMinimum();
        }

        public synchronized String toString() {
            long now = System.nanoTime();
            StringBuilder sb = new StringBuilder();
            sb.append("<");
            Iterator<PooledConnection> it = this.allConnections.iterator();
            while (it.hasNext()) {
                PooledConnection pc = it.next();
                sb.append(pc.getServer());
                if (pc.shouldDestroy()) {
                    sb.append("-DESTROYED");
                } else if (pc.hasIdleExpired(now, ConnectionManagerImpl.this.idleTimeoutNanos)) {
                    sb.append("-IDLE");
                } else if (pc.remainingLife(now, ConnectionManagerImpl.this.lifetimeTimeoutNanos) <= 0L) {
                    sb.append("-EOL");
                }
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            sb.append(">");
            return sb.toString();
        }

        synchronized void addConnection(PooledConnection connection) {
            if (this.closing) {
                throw new CacheClosedException("This pool is closing");
            }
            ConnectionManagerImpl.this.getPoolStats().incPoolConnections(1);
            this.allConnections.add(connection);
            this.addToEndpointMap(connection);
            if (this.isIdleExpirePossible()) {
                ConnectionManagerImpl.this.startBackgroundExpiration();
            }
            if (ConnectionManagerImpl.this.lifetimeTimeout != -1 && !this.haveLifetimeExpireConnectionsTask && this.checkForReschedule(true)) {
                this.startBackgroundLifetimeExpiration(0L);
            }
        }

        synchronized void addReplacedCnx(PooledConnection con, Endpoint oldEndpoint) {
            if (this.closing) {
                throw new CacheClosedException("This pool is closing");
            }
            if (this.allConnections.remove(con)) {
                this.removeFromEndpointMap(oldEndpoint, con);
                this.addToEndpointMap(con);
                this.allConnections.add(con);
                if (this.isIdleExpirePossible()) {
                    ConnectionManagerImpl.this.startBackgroundExpiration();
                }
            }
        }

        synchronized Set<PooledConnection> removeEndpoint(Endpoint endpoint) {
            Set<PooledConnection> endpointConnections = this.map.remove(endpoint);
            if (endpointConnections != null) {
                int count = 0;
                Iterator<PooledConnection> it = this.allConnections.iterator();
                while (it.hasNext()) {
                    if (!endpointConnections.contains(it.next())) continue;
                    ++count;
                    it.remove();
                }
                if (count != 0) {
                    ConnectionManagerImpl.this.getPoolStats().incPoolConnections(-count);
                }
            }
            return endpointConnections;
        }

        synchronized boolean removeConnection(PooledConnection connection) {
            boolean result = this.allConnections.remove(connection);
            if (result) {
                ConnectionManagerImpl.this.getPoolStats().incPoolConnections(-1);
            }
            this.removeFromEndpointMap(connection);
            return result;
        }

        private synchronized void addToEndpointMap(PooledConnection connection) {
            Set endpointConnections = this.map.computeIfAbsent(connection.getEndpoint(), k -> new HashSet());
            endpointConnections.add(connection);
        }

        private void removeFromEndpointMap(PooledConnection connection) {
            this.removeFromEndpointMap(connection.getEndpoint(), connection);
        }

        private synchronized void removeFromEndpointMap(Endpoint endpoint, PooledConnection connection) {
            Set<PooledConnection> endpointConnections = this.map.get(endpoint);
            if (endpointConnections != null) {
                endpointConnections.remove(connection);
                if (endpointConnections.size() == 0) {
                    this.map.remove(endpoint);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(boolean keepAlive) {
            List<PooledConnection> connections;
            int count = 0;
            ConnectionMap connectionMap = this;
            synchronized (connectionMap) {
                if (this.closing) {
                    return;
                }
                this.closing = true;
                this.map.clear();
                connections = this.allConnections;
                this.allConnections = new ClosedPoolConnectionList();
            }
            for (PooledConnection pc : connections) {
                ++count;
                if (pc.isDestroyed()) continue;
                try {
                    pc.internalClose(keepAlive);
                }
                catch (SocketException se) {
                    logger.info("Error closing connection to server " + pc.getServer(), (Throwable)se);
                }
                catch (Exception e) {
                    logger.warn("Error closing connection to server " + pc.getServer(), (Throwable)e);
                }
            }
            if (count != 0) {
                ConnectionManagerImpl.this.getPoolStats().incPoolConnections(-count);
            }
        }

        public synchronized void emergencyClose() {
            this.closing = true;
            this.map.clear();
            while (!this.allConnections.isEmpty()) {
                PooledConnection pc = this.allConnections.remove(0);
                pc.emergencyClose();
            }
        }

        synchronized PooledConnection findReplacementTarget(ServerLocation currentServer) {
            long now = System.nanoTime();
            for (PooledConnection pc : this.allConnections) {
                if (!currentServer.equals(pc.getServer()) || pc.shouldDestroy() || pc.remainingLife(now, ConnectionManagerImpl.this.lifetimeTimeoutNanos) > 0L) continue;
                this.removeFromEndpointMap(pc);
                return pc;
            }
            return null;
        }

        synchronized boolean hasExpiredCnxToServer(ServerLocation currentServer) {
            if (!this.allConnections.isEmpty()) {
                long now = System.nanoTime();
                for (PooledConnection pc : this.allConnections) {
                    long life;
                    if (pc.shouldDestroy() || !currentServer.equals(pc.getServer()) || (life = pc.remainingLife(now, ConnectionManagerImpl.this.lifetimeTimeoutNanos)) > 0L) continue;
                    return true;
                }
            }
            return false;
        }

        synchronized boolean checkForReschedule(boolean rescheduleOk) {
            if (!this.allConnections.isEmpty()) {
                long now = System.nanoTime();
                for (PooledConnection pc : this.allConnections) {
                    if (pc.hasIdleExpired(now, ConnectionManagerImpl.this.idleTimeoutNanos) || pc.shouldDestroy()) continue;
                    long life = pc.remainingLife(now, ConnectionManagerImpl.this.lifetimeTimeoutNanos);
                    if (life > 0L) {
                        if (rescheduleOk) {
                            this.startBackgroundLifetimeExpiration(life);
                            return false;
                        }
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        synchronized void extendLifeOfCnxToServer(ServerLocation sl) {
            if (!this.allConnections.isEmpty()) {
                PooledConnection pc;
                long now = System.nanoTime();
                Iterator<PooledConnection> it = this.allConnections.iterator();
                while (it.hasNext() && (pc = it.next()).remainingLife(now, ConnectionManagerImpl.this.lifetimeTimeoutNanos) <= 0L) {
                    if (pc.shouldDestroy() || !sl.equals(pc.getEndpoint().getLocation())) continue;
                    it.remove();
                    pc.setBirthDate(now);
                    ConnectionManagerImpl.this.getPoolStats().incLoadConditioningExtensions();
                    this.allConnections.add(pc);
                    break;
                }
            }
        }

        synchronized void startBackgroundLifetimeExpiration(long delay) {
            if (!this.haveLifetimeExpireConnectionsTask) {
                this.haveLifetimeExpireConnectionsTask = true;
                try {
                    LifetimeExpireConnectionsTask task = new LifetimeExpireConnectionsTask();
                    ConnectionManagerImpl.this.loadConditioningProcessor.schedule(task, delay, TimeUnit.NANOSECONDS);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void expireIdleConnections() {
            ArrayList<PooledConnection> toClose;
            int expireCount = 0;
            ConnectionMap connectionMap = this;
            synchronized (connectionMap) {
                ConnectionManagerImpl.this.haveIdleExpireConnectionsTask = false;
                if (ConnectionManagerImpl.this.shuttingDown.get()) {
                    return;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Looking for connections to expire");
                }
                if (!ConnectionManagerImpl.this.connectionAccounting.isOverMinimum()) {
                    return;
                }
                long minRemainingIdle = Long.MAX_VALUE;
                int conCount = ConnectionManagerImpl.this.connectionAccounting.getCount();
                toClose = new ArrayList<PooledConnection>(conCount - ConnectionManagerImpl.this.connectionAccounting.getMinimum());
                Iterator<PooledConnection> it = this.allConnections.iterator();
                while (it.hasNext() && conCount > ConnectionManagerImpl.this.connectionAccounting.getMinimum()) {
                    PooledConnection pc = it.next();
                    if (pc.shouldDestroy()) {
                        --conCount;
                        continue;
                    }
                    long remainingIdle = pc.doIdleTimeout(System.nanoTime(), ConnectionManagerImpl.this.idleTimeoutNanos);
                    if (remainingIdle >= 0L) {
                        if (remainingIdle == 0L) {
                            --conCount;
                            continue;
                        }
                        if (remainingIdle >= minRemainingIdle) continue;
                        minRemainingIdle = remainingIdle;
                        continue;
                    }
                    ++expireCount;
                    --conCount;
                    this.removeFromEndpointMap(pc);
                    toClose.add(pc);
                    it.remove();
                }
                if (conCount > ConnectionManagerImpl.this.connectionAccounting.getMinimum() && minRemainingIdle < Long.MAX_VALUE) {
                    try {
                        ConnectionManagerImpl.this.backgroundProcessor.schedule(new IdleExpireConnectionsTask(), minRemainingIdle, TimeUnit.NANOSECONDS);
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        // empty catch block
                    }
                    ConnectionManagerImpl.this.haveIdleExpireConnectionsTask = true;
                }
            }
            if (expireCount > 0) {
                ConnectionManagerImpl.this.getPoolStats().incIdleExpire(expireCount);
                ConnectionManagerImpl.this.getPoolStats().incPoolConnections(-expireCount);
                ConnectionManagerImpl.this.destroyAndMaybePrefill(expireCount);
            }
            boolean isDebugEnabled = logger.isDebugEnabled();
            for (PooledConnection connection : toClose) {
                if (isDebugEnabled) {
                    logger.debug("Idle connection detected. Expiring connection {}", (Object)connection);
                }
                try {
                    connection.internalClose(false);
                }
                catch (Exception e) {
                    logger.warn("Error expiring connection {}", (Object)connection);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkLifetimes() {
            boolean done;
            ConnectionMap connectionMap = this;
            synchronized (connectionMap) {
                this.haveLifetimeExpireConnectionsTask = false;
                if (ConnectionManagerImpl.this.shuttingDown.get()) {
                    return;
                }
            }
            do {
                ConnectionManagerImpl.this.getPoolStats().incLoadConditioningCheck();
                long firstLife = -1L;
                ServerLocation candidate = null;
                ConnectionMap connectionMap2 = this;
                synchronized (connectionMap2) {
                    if (ConnectionManagerImpl.this.shuttingDown.get()) {
                        return;
                    }
                    long now = System.nanoTime();
                    long life = 0L;
                    boolean idlePossible = this.isIdleExpirePossible();
                    Iterator<PooledConnection> it = this.allConnections.iterator();
                    while (it.hasNext() && life <= 0L && candidate == null) {
                        PooledConnection pc = it.next();
                        life = pc.remainingLife(now, ConnectionManagerImpl.this.lifetimeTimeoutNanos);
                        if (life <= 0L) {
                            boolean idleTimedOut = idlePossible && pc.hasIdleExpired(now, ConnectionManagerImpl.this.idleTimeoutNanos);
                            boolean destroyed = pc.shouldDestroy();
                            if (idleTimedOut || destroyed) continue;
                            candidate = pc.getServer();
                            continue;
                        }
                        firstLife = life;
                    }
                }
                if (candidate != null) {
                    done = !ConnectionManagerImpl.this.createLifetimeReplacementConnection(candidate);
                    continue;
                }
                if (firstLife >= 0L) {
                    this.startBackgroundLifetimeExpiration(firstLife);
                }
                done = true;
            } while (!done);
            this.startBackgroundLifetimeExpiration(ConnectionManagerImpl.this.lifetimeTimeoutNanos);
        }
    }

    protected class PrefillConnectionsTask
    extends PoolImpl.PoolTask {
        protected PrefillConnectionsTask() {
        }

        @Override
        public void run2() {
            if (logger.isTraceEnabled()) {
                logger.trace("Prefill Connections task running");
            }
            ConnectionManagerImpl.this.prefill();
            if (ConnectionManagerImpl.this.connectionAccounting.isUnderMinimum() && !ConnectionManagerImpl.this.cancelCriterion.isCancelInProgress()) {
                try {
                    ConnectionManagerImpl.this.backgroundProcessor.schedule(new PrefillConnectionsTask(), ConnectionManagerImpl.this.prefillRetry, TimeUnit.MILLISECONDS);
                }
                catch (RejectedExecutionException rejectedExecutionException) {}
            } else {
                ConnectionManagerImpl.this.havePrefillTask.set(false);
            }
        }
    }

    protected class IdleExpireConnectionsTask
    implements Runnable {
        protected IdleExpireConnectionsTask() {
        }

        @Override
        public void run() {
            try {
                ConnectionManagerImpl.this.getPoolStats().incIdleCheck();
                ConnectionManagerImpl.this.allConnectionsMap.expireIdleConnections();
            }
            catch (CancelException cancelException) {
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure(e);
                throw e;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.warn(String.format("IdleExpireConnectionsTask <%s> encountered exception", this), t);
            }
        }
    }

    protected class LifetimeExpireConnectionsTask
    implements Runnable {
        protected LifetimeExpireConnectionsTask() {
        }

        @Override
        public void run() {
            try {
                ConnectionManagerImpl.this.allConnectionsMap.checkLifetimes();
            }
            catch (CancelException cancelException) {
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure(e);
                throw e;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.warn(String.format("LoadConditioningTask <%s> encountered exception", this), t);
            }
        }
    }
}

