/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.transaction.TransactionManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.ForcedDisconnectException;
import org.apache.geode.GemFireCacheException;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.LogWriter;
import org.apache.geode.SerializationException;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.SystemFailure;
import org.apache.geode.admin.internal.SystemMemberCacheEventProcessor;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheExistsException;
import org.apache.geode.cache.CacheTransactionManager;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.CacheXmlException;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.DiskStoreFactory;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.GatewayException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.asyncqueue.AsyncEventQueueFactory;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueFactoryImpl;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.asyncqueue.internal.InternalAsyncEventQueue;
import org.apache.geode.cache.client.ClientRegionFactory;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolFactory;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.ClientMetadataService;
import org.apache.geode.cache.client.internal.ClientRegionFactoryImpl;
import org.apache.geode.cache.client.internal.InternalClientCache;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.control.ResourceManager;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.internal.DefaultQueryService;
import org.apache.geode.cache.query.internal.InternalQueryService;
import org.apache.geode.cache.query.internal.QueryMonitor;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.CqServiceProvider;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.snapshot.CacheSnapshotService;
import org.apache.geode.cache.util.GatewayConflictResolver;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewayReceiverFactory;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.cache.wan.GatewaySenderFactory;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.distributed.internal.ResourceEventsListener;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.cache.AddCacheServerProfileMessage;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CacheConfig;
import org.apache.geode.internal.cache.CacheLifecycleListener;
import org.apache.geode.internal.cache.CacheObserverHolder;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.cache.CloseCacheMessage;
import org.apache.geode.internal.cache.ClusterConfigurationLoader;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.DiskStoreAttributes;
import org.apache.geode.internal.cache.DiskStoreFactoryImpl;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.DiskStoreMonitor;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.DynamicRegionFactoryImpl;
import org.apache.geode.internal.cache.ExpirationScheduler;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.HasCachePerfStats;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheForClientAccess;
import org.apache.geode.internal.cache.InternalCacheServer;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.InternalRegionFactory;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PRContainsValueFunction;
import org.apache.geode.internal.cache.PRHARedundancyProvider;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.PoolFactoryImpl;
import org.apache.geode.internal.cache.PoolManagerImpl;
import org.apache.geode.internal.cache.PreferBytesCachedDeserializable;
import org.apache.geode.internal.cache.RegionEntrySynchronizationListener;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.internal.cache.RegionListener;
import org.apache.geode.internal.cache.RemoveCacheServerProfileMessage;
import org.apache.geode.internal.cache.ServerBuilder;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXEntryState;
import org.apache.geode.internal.cache.TXEntryStateFactory;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.TombstoneService;
import org.apache.geode.internal.cache.UpdateAttributesProcessor;
import org.apache.geode.internal.cache.UserSpecifiedRegionAttributes;
import org.apache.geode.internal.cache.backup.BackupService;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.control.ResourceAdvisor;
import org.apache.geode.internal.cache.event.EventTrackerExpiryTask;
import org.apache.geode.internal.cache.eviction.HeapEvictor;
import org.apache.geode.internal.cache.eviction.OffHeapEvictor;
import org.apache.geode.internal.cache.execute.util.FindRestEnabledServersFunction;
import org.apache.geode.internal.cache.extension.ExtensionPoint;
import org.apache.geode.internal.cache.extension.SimpleExtensionPoint;
import org.apache.geode.internal.cache.ha.HARegionQueue;
import org.apache.geode.internal.cache.locks.TXLockService;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentMemberManager;
import org.apache.geode.internal.cache.snapshot.CacheSnapshotServiceImpl;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.GatewaySenderAdvisor;
import org.apache.geode.internal.cache.wan.GatewaySenderQueueEntrySynchronizationListener;
import org.apache.geode.internal.cache.wan.WANServiceProvider;
import org.apache.geode.internal.cache.xmlcache.CacheServerCreation;
import org.apache.geode.internal.cache.xmlcache.CacheXmlGenerator;
import org.apache.geode.internal.cache.xmlcache.CacheXmlParser;
import org.apache.geode.internal.cache.xmlcache.CacheXmlPropertyResolver;
import org.apache.geode.internal.cache.xmlcache.PropertyResolver;
import org.apache.geode.internal.config.ClusterConfigurationNotAvailableException;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.internal.jta.TransactionManagerImpl;
import org.apache.geode.internal.lang.ThrowableUtils;
import org.apache.geode.internal.logging.CoreLoggingExecutors;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.internal.offheap.MemoryAllocator;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.security.SecurityServiceFactory;
import org.apache.geode.internal.sequencelog.SequenceLoggerImpl;
import org.apache.geode.internal.serialization.DSCODE;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.shared.StringPrintWriter;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.internal.statistics.StatisticsClockFactory;
import org.apache.geode.internal.tcp.ConnectionTable;
import org.apache.geode.internal.util.BlobHelper;
import org.apache.geode.internal.util.concurrent.FutureResult;
import org.apache.geode.lang.Identifiable;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.JmxManagerAdvisee;
import org.apache.geode.management.internal.JmxManagerAdvisor;
import org.apache.geode.management.internal.RestAgent;
import org.apache.geode.management.internal.beans.ManagementListener;
import org.apache.geode.management.internal.configuration.domain.Configuration;
import org.apache.geode.management.internal.configuration.messages.ConfigurationResponse;
import org.apache.geode.pdx.JSONFormatter;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.PdxInstanceFactory;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.ReflectionBasedAutoSerializer;
import org.apache.geode.pdx.internal.AutoSerializableManager;
import org.apache.geode.pdx.internal.InternalPdxInstance;
import org.apache.geode.pdx.internal.PdxInstanceFactoryImpl;
import org.apache.geode.pdx.internal.PdxInstanceImpl;
import org.apache.geode.pdx.internal.TypeRegistry;
import org.apache.geode.util.internal.UncheckedUtils;
import org.apache.logging.log4j.Logger;

public class GemFireCacheImpl
implements InternalCache,
InternalClientCache,
HasCachePerfStats,
DistributionAdvisee {
    private static final Logger logger = LogService.getLogger();
    public static final int DEFAULT_LOCK_TIMEOUT = Integer.getInteger("gemfire.Cache.defaultLockTimeout", 60);
    public static final int DEFAULT_LOCK_LEASE = Integer.getInteger("gemfire.Cache.defaultLockLease", 120);
    public static final boolean DEFAULT_COPY_ON_READ = false;
    public static final int DEFAULT_SEARCH_TIMEOUT = Integer.getInteger("gemfire.Cache.defaultSearchTimeout", 300);
    public static final String DEFAULT_POOL_NAME = "DEFAULT";
    @VisibleForTesting
    static final int EVENT_THREAD_LIMIT = Integer.getInteger("gemfire.Cache.EVENT_THREAD_LIMIT", 16);
    @VisibleForTesting
    static final int PURGE_INTERVAL = 1000;
    private static final int QUERY_MONITOR_THREAD_POOL_SIZE = 1;
    private static final int EVENT_QUEUE_LIMIT = Integer.getInteger("gemfire.Cache.EVENT_QUEUE_LIMIT", 4096);
    private static final int FIVE_HOURS_MILLIS = 18000000;
    private static final Pattern DOUBLE_BACKSLASH = Pattern.compile("\\\\");
    private static final boolean DEBUG_CREATION_STACK = false;
    private static final boolean XML_PARAMETERIZATION_ENABLED = !Boolean.getBoolean("gemfire.xml.parameterization.disabled");
    private static final int shutdownAllPoolSize = Integer.getInteger("gemfire.SHUTDOWN_ALL_POOL_SIZE", -1);
    private static final ThreadLocal<GemFireCacheImpl> xmlCache = new ThreadLocal();
    private static final ThreadLocal<Thread> CLOSING_THREAD = new ThreadLocal();
    @MutableForTesting
    public static int MAX_QUERY_EXECUTION_TIME = Integer.getInteger("gemfire.Cache.MAX_QUERY_EXECUTION_TIME", -1);
    @MutableForTesting
    @VisibleForTesting
    public static File testCacheXml;
    @MutableForTesting
    static boolean DELTAS_RECALCULATE_SIZE;
    @MakeNotStatic
    private static final Set<CacheLifecycleListener> cacheLifecycleListeners;
    @MakeNotStatic
    private static boolean queryMonitorRequiredForResourceManager;
    @MakeNotStatic
    private static String defaultDiskStoreName;
    private final boolean queryMonitorDisabledForLowMem = Boolean.getBoolean("gemfire.Cache.DISABLE_QUERY_MONITOR_FOR_LOW_MEMORY");
    private final InternalDistributedSystem system;
    private final DistributionManager dm;
    private final ConcurrentMap<String, InternalRegion> rootRegions;
    private final boolean isClient;
    private final PoolFactory poolFactory;
    private final ConcurrentMap<String, InternalRegion> pathToRegion = new ConcurrentHashMap<String, InternalRegion>();
    private final CachePerfStats cachePerfStats;
    private final Date creationDate;
    private final ExecutorService eventThreadPool;
    private final List<InternalCacheServer> allCacheServers = new CopyOnWriteArrayList<InternalCacheServer>();
    private final List<CacheServer> unmodifiableAllCacheServers = Collections.unmodifiableList(this.allCacheServers);
    private final Object allGatewaySendersLock = new Object();
    private final Set<AsyncEventQueue> allVisibleAsyncEventQueues = new CopyOnWriteArraySet<AsyncEventQueue>();
    private final Set<AsyncEventQueue> allAsyncEventQueues = new CopyOnWriteArraySet<AsyncEventQueue>();
    private final AtomicReference<GatewayReceiver> gatewayReceiver = new AtomicReference();
    private final AtomicReference<InternalCacheServer> gatewayReceiverServer = new AtomicReference();
    private final Set<PartitionedRegion> partitionedRegions = new HashSet<PartitionedRegion>();
    private final ConcurrentMap<String, DistributedRegion> regionsInDestroy = new ConcurrentHashMap<String, DistributedRegion>();
    private final Object allGatewayHubsLock = new Object();
    private final TXManagerImpl transactionManager;
    private final Map<String, RegionAttributes<?, ?>> namedRegionAttributes = Collections.synchronizedMap(new HashMap());
    private final EventTrackerExpiryTask recordedEventSweeper;
    private final TombstoneService tombstoneService;
    private final Object prLockServiceLock = new Object();
    private final Object gatewayLockServiceLock = new Object();
    private final InternalResourceManager resourceManager;
    private final BackupService backupService;
    private final Object heapEvictorLock = new Object();
    private final Object offHeapEvictorLock = new Object();
    private final Object queryMonitorLock = new Object();
    private final PersistentMemberManager persistentMemberManager;
    private final ClientMetadataService clientMetadataService;
    private final AtomicBoolean isShutDownAll = new AtomicBoolean();
    private final CountDownLatch shutDownAllFinished = new CountDownLatch(1);
    private final ResourceAdvisor resourceAdvisor;
    private final JmxManagerAdvisor jmxAdvisor;
    private final int serialNumber;
    private final TXEntryStateFactory txEntryStateFactory;
    private final CacheConfig cacheConfig;
    private final DiskStoreMonitor diskMonitor;
    private final Map<Declarable, Properties> declarablePropertiesMap = new ConcurrentHashMap<Declarable, Properties>();
    private final PropertyResolver resolver;
    private final ExtensionPoint<Cache> extensionPoint = new SimpleExtensionPoint<GemFireCacheImpl>(this, this);
    private final CqService cqService;
    private final Set<RegionListener> regionListeners = ConcurrentHashMap.newKeySet();
    private final Map<Class<? extends CacheService>, CacheService> services = new HashMap<Class<? extends CacheService>, CacheService>();
    private final SecurityService securityService;
    private final Set<RegionEntrySynchronizationListener> synchronizationListeners = ConcurrentHashMap.newKeySet();
    private final ClusterConfigurationLoader ccLoader = new ClusterConfigurationLoader();
    private final StatisticsClock statisticsClock;
    private final ConcurrentMap<String, FutureResult<InternalRegion>> reinitializingRegions = new ConcurrentHashMap<String, FutureResult<InternalRegion>>();
    private final HeapEvictorFactory heapEvictorFactory;
    private final Runnable typeRegistryClose;
    private final java.util.function.Function<InternalCache, String> typeRegistryGetPdxDiskStoreName;
    private final Consumer<PdxSerializer> typeRegistrySetPdxSerializer;
    private final TypeRegistryFactory typeRegistryFactory;
    private final Consumer<Function> functionServiceRegisterFunction;
    private final java.util.function.Function<Object, SystemTimer> systemTimerFactory;
    private final ReplyProcessor21Factory replyProcessor21Factory;
    private final Stopper stopper = new Stopper();
    private final boolean disableDisconnectDsOnCacheClose = Boolean.getBoolean("gemfire.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE");
    private final ConcurrentMap<String, DiskStoreImpl> diskStores = new ConcurrentHashMap<String, DiskStoreImpl>();
    private final ConcurrentMap<String, DiskStoreImpl> regionOwnedDiskStores = new ConcurrentHashMap<String, DiskStoreImpl>();
    private final Object ccpTimerMutex = new Object();
    private final ExpirationScheduler expirationScheduler;
    private final AtomicInteger registerInterestsInProgress = new AtomicInteger();
    private final List<SimpleWaiter> riWaiters = new ArrayList<SimpleWaiter>();
    private final InternalCacheForClientAccess cacheForClients = new InternalCacheForClientAccess(this);
    private volatile ConfigurationResponse configurationResponse;
    private volatile boolean isInitialized;
    private volatile boolean isClosing;
    private final CountDownLatch isClosedLatch = new CountDownLatch(1);
    private volatile Set<GatewaySender> allGatewaySenders = Collections.emptySet();
    private volatile boolean copyOnRead = false;
    private volatile Throwable disconnectCause;
    private volatile DistributedLockService gatewayLockService;
    private volatile QueryMonitor queryMonitor;
    private Pool defaultPool;
    private int lockTimeout = DEFAULT_LOCK_TIMEOUT;
    private int lockLease = DEFAULT_LOCK_LEASE;
    private int searchTimeout = DEFAULT_SEARCH_TIMEOUT;
    private GatewayConflictResolver gatewayConflictResolver;
    private boolean isServer;
    private RestAgent restAgent;
    private boolean isRESTServiceRunning;
    private boolean forcedDisconnect;
    private Exception creationStack;
    private DistributedLockService prLockService;
    private HeapEvictor heapEvictor;
    private OffHeapEvictor offHeapEvictor;
    private ResourceEventsListener resourceEventsListener;
    private boolean keepAlive;
    private SystemTimer ccpTimer;
    private int cancelCount;
    private TypeRegistry pdxRegistry;
    private Declarable initializer;
    private Properties initializerProps;
    private List<File> backupFiles = Collections.emptyList();

    private static native int mlockall(int var0);

    public static void lockMemory() {
        try {
            Native.register((String)Platform.C_LIBRARY_NAME);
            int result = GemFireCacheImpl.mlockall(1);
            if (result == 0) {
                return;
            }
        }
        catch (Throwable t) {
            throw new IllegalStateException("Error trying to lock memory", t);
        }
        int lastError = Native.getLastError();
        String message = "mlockall failed: " + lastError;
        if (lastError == 1 || lastError == 12) {
            message = "Unable to lock memory due to insufficient free space or privileges.  Please check the RLIMIT_MEMLOCK soft resource limit (ulimit -l) and increase the available memory if needed";
        }
        throw new IllegalStateException(message);
    }

    @Deprecated
    public static GemFireCacheImpl getInstance() {
        InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
        if (system == null) {
            return null;
        }
        GemFireCacheImpl cache = (GemFireCacheImpl)system.getCache();
        if (cache == null) {
            return null;
        }
        if (cache.isClosing) {
            return null;
        }
        return cache;
    }

    @Deprecated
    public static GemFireCacheImpl getExisting() {
        GemFireCacheImpl result = GemFireCacheImpl.getInstance();
        if (result != null && !result.isClosing) {
            return result;
        }
        if (result != null) {
            throw result.getCacheClosedException("The cache has been closed.");
        }
        throw new CacheClosedException("A cache has not yet been created.");
    }

    @Deprecated
    public static GemFireCacheImpl getExisting(String reason) {
        GemFireCacheImpl result = GemFireCacheImpl.getInstance();
        if (result == null) {
            throw new CacheClosedException(reason);
        }
        return result;
    }

    @Deprecated
    public static GemFireCacheImpl getForPdx(String reason) {
        InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
        if (system == null) {
            throw new CacheClosedException(reason);
        }
        GemFireCacheImpl cache = (GemFireCacheImpl)system.getCache();
        if (cache == null) {
            throw new CacheClosedException(reason);
        }
        return cache;
    }

    GemFireCacheImpl(boolean isClient, PoolFactory poolFactory, InternalDistributedSystem internalDistributedSystem, CacheConfig cacheConfig, boolean useAsyncEventListeners, TypeRegistry typeRegistry) {
        this(isClient, poolFactory, internalDistributedSystem, cacheConfig, useAsyncEventListeners, typeRegistry, JNDIInvoker::mapTransactions, SecurityServiceFactory::create, () -> PoolManager.getAll().isEmpty(), ManagementListener::new, CqServiceProvider::create, CachePerfStats::new, TXManagerImpl::new, PersistentMemberManager::new, ResourceAdvisor::createResourceAdvisor, JmxManagerAdvisee::new, JmxManagerAdvisor::createJmxManagerAdvisor, InternalResourceManager::createResourceManager, DistributionAdvisor::createSerialNumber, HeapEvictor::new, TypeRegistry::init, TypeRegistry::open, TypeRegistry::close, TypeRegistry::getPdxDiskStoreName, TypeRegistry::setPdxSerializer, TypeRegistry::new, HARegionQueue::setMessageSyncInterval, FunctionService::registerFunction, object -> new SystemTimer((DistributedSystem)object), TombstoneService::initialize, ExpirationScheduler::new, DiskStoreMonitor::new, GatewaySenderQueueEntrySynchronizationListener::new, BackupService::new, ClientMetadataService::new, TXEntryState.getFactory(), ReplyProcessor21::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    GemFireCacheImpl(boolean isClient, PoolFactory poolFactory, InternalDistributedSystem internalDistributedSystem, CacheConfig cacheConfig, boolean useAsyncEventListeners, TypeRegistry typeRegistry, Consumer<DistributedSystem> jndiTransactionMapper, InternalSecurityServiceFactory securityServiceFactory, Supplier<Boolean> isPoolManagerEmpty, java.util.function.Function<InternalDistributedSystem, ManagementListener> managementListenerFactory, java.util.function.Function<InternalCache, CqService> cqServiceFactory, CachePerfStatsFactory cachePerfStatsFactory, TXManagerImplFactory txManagerImplFactory, Supplier<PersistentMemberManager> persistentMemberManagerFactory, java.util.function.Function<DistributionAdvisee, ResourceAdvisor> resourceAdvisorFactory, java.util.function.Function<InternalCacheForClientAccess, JmxManagerAdvisee> jmxManagerAdviseeFactory, java.util.function.Function<JmxManagerAdvisee, JmxManagerAdvisor> jmxManagerAdvisorFactory, java.util.function.Function<InternalCache, InternalResourceManager> internalResourceManagerFactory, Supplier<Integer> serialNumberSupplier, HeapEvictorFactory heapEvictorFactory, Runnable typeRegistryInit, Runnable typeRegistryOpen, Runnable typeRegistryClose, java.util.function.Function<InternalCache, String> typeRegistryGetPdxDiskStoreName, Consumer<PdxSerializer> typeRegistrySetPdxSerializer, TypeRegistryFactory typeRegistryFactory, Consumer<Integer> haRegionQueueSetMessageSyncInterval, Consumer<Function> functionServiceRegisterFunction, java.util.function.Function<Object, SystemTimer> systemTimerFactory, java.util.function.Function<InternalCache, TombstoneService> tombstoneServiceFactory, java.util.function.Function<InternalDistributedSystem, ExpirationScheduler> expirationSchedulerFactory, java.util.function.Function<File, DiskStoreMonitor> diskStoreMonitorFactory, Supplier<RegionEntrySynchronizationListener> gatewaySenderQueueEntrySynchronizationListener, java.util.function.Function<InternalCache, BackupService> backupServiceFactory, java.util.function.Function<Cache, ClientMetadataService> clientMetadataServiceFactory, TXEntryStateFactory txEntryStateFactory, ReplyProcessor21Factory replyProcessor21Factory) {
        this.isClient = isClient;
        this.poolFactory = poolFactory;
        this.cacheConfig = cacheConfig;
        this.pdxRegistry = typeRegistry;
        this.heapEvictorFactory = heapEvictorFactory;
        this.typeRegistryClose = typeRegistryClose;
        this.typeRegistryGetPdxDiskStoreName = typeRegistryGetPdxDiskStoreName;
        this.typeRegistrySetPdxSerializer = typeRegistrySetPdxSerializer;
        this.typeRegistryFactory = typeRegistryFactory;
        this.functionServiceRegisterFunction = functionServiceRegisterFunction;
        this.systemTimerFactory = systemTimerFactory;
        this.replyProcessor21Factory = replyProcessor21Factory;
        Class<GemFireCacheImpl> clazz = GemFireCacheImpl.class;
        synchronized (GemFireCacheImpl.class) {
            Properties userProps;
            jndiTransactionMapper.accept(internalDistributedSystem);
            this.system = internalDistributedSystem;
            this.dm = this.system.getDistributionManager();
            if (!isClient) {
                this.configurationResponse = this.requestSharedConfiguration();
                this.ccLoader.applyClusterPropertiesConfiguration(this.configurationResponse, this.system.getConfig());
                this.securityService = securityServiceFactory.create(this.system.getConfig().getSecurityProps(), cacheConfig);
                this.system.setSecurityService(this.securityService);
            } else {
                this.securityService = SecurityServiceFactory.create();
            }
            DistributionConfig systemConfig = internalDistributedSystem.getConfig();
            if (!this.isClient && isPoolManagerEmpty.get().booleanValue()) {
                boolean disableJmx = systemConfig.getDisableJmx();
                if (disableJmx) {
                    logger.info("Running with JMX disabled.");
                } else {
                    this.resourceEventsListener = managementListenerFactory.apply(this.system);
                    this.system.addResourceListener(this.resourceEventsListener);
                    if (this.system.isLoner()) {
                        logger.info("Running in local mode since no locators were specified.");
                    }
                }
            } else {
                logger.info("Running in client mode");
                this.resourceEventsListener = null;
            }
            if (this.dm.getDMType() == 12) {
                throw new IllegalStateException("Cannot create a Cache in an admin-only VM.");
            }
            this.rootRegions = new ConcurrentHashMap<String, InternalRegion>();
            this.cqService = cqServiceFactory.apply(this);
            this.statisticsClock = StatisticsClockFactory.clock(this.system.getConfig().getEnableTimeStatistics());
            this.cachePerfStats = cachePerfStatsFactory.create(internalDistributedSystem.getStatisticsManager(), this.statisticsClock);
            this.transactionManager = txManagerImplFactory.create(this.cachePerfStats, this, this.statisticsClock);
            this.dm.addMembershipListener(this.transactionManager);
            this.creationDate = new Date();
            this.persistentMemberManager = persistentMemberManagerFactory.get();
            this.eventThreadPool = useAsyncEventListeners ? CoreLoggingExecutors.newThreadPoolWithFixedFeed("Message Event Thread", command -> {
                ConnectionTable.threadWantsSharedResources();
                command.run();
            }, EVENT_THREAD_LIMIT, this.cachePerfStats.getEventPoolHelper(), 1000, this.getThreadMonitorObj(), EVENT_QUEUE_LIMIT) : null;
            this.resourceAdvisor = resourceAdvisorFactory.apply(this);
            this.jmxAdvisor = jmxManagerAdvisorFactory.apply(jmxManagerAdviseeFactory.apply(this.cacheForClients));
            this.resourceManager = internalResourceManagerFactory.apply(this);
            this.serialNumber = serialNumberSupplier.get();
            this.getInternalResourceManager().addResourceListener(InternalResourceManager.ResourceType.HEAP_MEMORY, this.getHeapEvictor());
            if (null != this.getOffHeapStore()) {
                this.getInternalResourceManager().addResourceListener(InternalResourceManager.ResourceType.OFFHEAP_MEMORY, this.getOffHeapEvictor());
            }
            this.recordedEventSweeper = this.createEventTrackerExpiryTask();
            this.tombstoneService = tombstoneServiceFactory.apply(this);
            typeRegistryInit.run();
            this.basicSetPdxSerializer(this.cacheConfig.getPdxSerializer());
            typeRegistryOpen.run();
            if (!this.isClient()) {
                haRegionQueueSetMessageSyncInterval.accept(1);
            }
            functionServiceRegisterFunction.accept(new PRContainsValueFunction());
            this.expirationScheduler = expirationSchedulerFactory.apply(this.system);
            this.txEntryStateFactory = txEntryStateFactory;
            this.resolver = XML_PARAMETERIZATION_ENABLED ? ((userProps = this.system.getConfig().getUserDefinedProps()) != null && !userProps.isEmpty() ? new CacheXmlPropertyResolver(false, 1, userProps) : new CacheXmlPropertyResolver(false, 1, null)) : null;
            SystemFailure.signalCacheCreate();
            this.diskMonitor = diskStoreMonitorFactory.apply(systemConfig.getLogFile());
            this.addRegionEntrySynchronizationListener(gatewaySenderQueueEntrySynchronizationListener.get());
            this.backupService = backupServiceFactory.apply(this);
            // ** MonitorExit[var38_38] (shouldn't be in output)
            this.clientMetadataService = clientMetadataServiceFactory.apply(this);
            return;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GemFireCache[");
        sb.append("id = ").append(System.identityHashCode(this));
        sb.append("; isClosing = ").append(this.isClosing);
        sb.append("; isShutDownAll = ").append(this.isCacheAtShutdownAll());
        sb.append("; created = ").append(this.creationDate);
        sb.append("; server = ").append(this.isServer);
        sb.append("; copyOnRead = ").append(this.copyOnRead);
        sb.append("; lockLease = ").append(this.lockLease);
        sb.append("; lockTimeout = ").append(this.lockTimeout);
        if (this.creationStack != null) {
            sb.append(System.lineSeparator()).append("Creation context:").append(System.lineSeparator());
            sb.append(ExceptionUtils.getStackTrace((Throwable)this.creationStack));
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void throwCacheExistsException() {
        throw new CacheExistsException(this, String.format("%s: An open cache already exists.", this), this.creationStack);
    }

    @Override
    public MeterRegistry getMeterRegistry() {
        return this.system.getMeterRegistry();
    }

    @Override
    public void saveCacheXmlForReconnect() {
        this.prepareForReconnect(pw -> CacheXmlGenerator.generate(this, pw, false));
    }

    protected void prepareForReconnect(Consumer<PrintWriter> xmlGenerator) {
        boolean sharedConfigEnabled = this.getInternalDistributedSystem().getConfig().getUseSharedConfiguration();
        try {
            if (!Boolean.getBoolean("gemfire.autoReconnect-useCacheXMLFile") && !sharedConfigEnabled) {
                try {
                    logger.info("generating XML to rebuild the cache after reconnect completes");
                    StringPrintWriter pw = new StringPrintWriter();
                    xmlGenerator.accept(pw);
                    String cacheXML = pw.toString();
                    this.getCacheConfig().setCacheXMLDescription(cacheXML);
                    logger.info("XML generation completed: {}", (Object)cacheXML);
                }
                catch (CancelException e) {
                    logger.info("Unable to generate XML description for reconnect of cache due to exception", (Throwable)e);
                }
            } else if (sharedConfigEnabled && !this.getCacheServers().isEmpty()) {
                logger.info("saving cache server configuration for use with the cluster-configuration service on reconnect");
                ArrayList<CacheServerCreation> list = new ArrayList<CacheServerCreation>(this.getCacheServers().size());
                for (CacheServer o : this.getCacheServers()) {
                    CacheServerImpl cs = (CacheServerImpl)o;
                    if (!cs.isDefaultServer()) continue;
                    CacheServerCreation bsc = new CacheServerCreation((InternalCache)this, cs);
                    list.add(bsc);
                }
                this.getCacheConfig().setCacheServerCreation(list);
                logger.info("cache server configuration saved");
            }
        }
        catch (Throwable throwable) {
            logger.info("Saving of cache configuration for auto-reconnect has failed.  Auto-reconnect will be disabled since the cache cannot be rebuilt.", throwable);
            this.getInternalDistributedSystem().getConfig().setDisableAutoReconnect(true);
        }
    }

    @Override
    public void reLoadClusterConfiguration() throws IOException, ClassNotFoundException {
        this.configurationResponse = this.requestSharedConfiguration();
        if (this.configurationResponse != null) {
            this.ccLoader.deployJarsReceivedFromClusterConfiguration(this.configurationResponse);
            this.ccLoader.applyClusterPropertiesConfiguration(this.configurationResponse, this.system.getConfig());
            this.ccLoader.applyClusterXmlConfiguration(this, this.configurationResponse, this.system.getConfig().getGroups());
            this.initializeDeclarativeCache();
        }
    }

    private EventTrackerExpiryTask createEventTrackerExpiryTask() {
        long lifetimeInMillis = Long.getLong("gemfire.messageTrackingTimeout", 300000L);
        EventTrackerExpiryTask task = new EventTrackerExpiryTask(lifetimeInMillis);
        this.getCCPTimer().scheduleAtFixedRate(task, lifetimeInMillis, lifetimeInMillis);
        return task;
    }

    @Override
    public SecurityService getSecurityService() {
        return this.securityService;
    }

    @Override
    public boolean isRESTServiceRunning() {
        return this.isRESTServiceRunning;
    }

    @Override
    public void setRESTServiceRunning(boolean isRESTServiceRunning) {
        this.isRESTServiceRunning = isRESTServiceRunning;
    }

    @Override
    @VisibleForTesting
    public RestAgent getRestAgent() {
        return this.restAgent;
    }

    @VisibleForTesting
    ConfigurationResponse requestSharedConfiguration() {
        DistributionConfig config = this.system.getConfig();
        if (!(this.dm instanceof ClusterDistributionManager)) {
            return null;
        }
        if (this.dm.getDMType() == 11 || this.isClient || Locator.getLocator() != null) {
            return null;
        }
        Map<InternalDistributedMember, Collection<String>> locatorsWithClusterConfig = this.getDistributionManager().getAllHostedLocatorsWithSharedConfiguration();
        if (locatorsWithClusterConfig.isEmpty()) {
            logger.info("No locator(s) found with cluster configuration service");
            return null;
        }
        try {
            Properties clusterSecProperties;
            ConfigurationResponse response = this.ccLoader.requestConfigurationFromLocators(this.system.getConfig().getGroups(), locatorsWithClusterConfig.keySet());
            logger.info("Received cluster configuration from the locator");
            logger.info(response.describeConfig());
            Configuration clusterConfig = response.getRequestedConfiguration().get("cluster");
            Properties properties = clusterSecProperties = clusterConfig == null ? new Properties() : clusterConfig.getGemfireProperties();
            if (!config.getUseSharedConfiguration()) {
                if (clusterSecProperties.containsKey("security-manager")) {
                    throw new GemFireConfigException("A server must use cluster configuration when joining a secured cluster.");
                }
                logger.info("The cache has been created with use-cluster-configuration=false. It will not receive any cluster configuration");
                return null;
            }
            Properties serverSecProperties = config.getSecurityProps();
            if (GemFireCacheImpl.isMisConfigured(clusterSecProperties, serverSecProperties, "security-manager") || GemFireCacheImpl.isMisConfigured(clusterSecProperties, serverSecProperties, "security-post-processor")) {
                throw new GemFireConfigException("A server cannot specify its own security-manager or security-post-processor when using cluster configuration");
            }
            return response;
        }
        catch (ClusterConfigurationNotAvailableException e) {
            throw new GemFireConfigException("cluster configuration service not available", e);
        }
        catch (UnknownHostException e) {
            throw new GemFireConfigException(e.getLocalizedMessage(), e);
        }
    }

    @VisibleForTesting
    static boolean isMisConfigured(Properties clusterProps, Properties serverProps, String key) {
        Objects.requireNonNull(clusterProps);
        Objects.requireNonNull(serverProps);
        Objects.requireNonNull(key);
        String clusterPropValue = clusterProps.getProperty(key);
        String serverPropValue = serverProps.getProperty(key);
        if (StringUtils.isBlank((CharSequence)serverPropValue)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)clusterPropValue)) {
            return true;
        }
        return !clusterPropValue.equals(serverPropValue);
    }

    @Override
    public boolean isClient() {
        return this.isClient;
    }

    @Override
    public boolean hasPool() {
        return this.isClient || !GemFireCacheImpl.getAllPools().isEmpty();
    }

    private static Collection<Pool> getAllPools() {
        Collection<Pool> pools = PoolManagerImpl.getPMI().getMap().values();
        Iterator<Pool> itr = pools.iterator();
        while (itr.hasNext()) {
            PoolImpl pool = (PoolImpl)itr.next();
            if (!pool.isUsedByGateway()) continue;
            itr.remove();
        }
        return pools;
    }

    @Override
    public synchronized Pool getDefaultPool() {
        if (this.defaultPool == null) {
            this.determineDefaultPool();
        }
        return this.defaultPool;
    }

    @Override
    public void initialize() {
        for (CacheLifecycleListener listener : cacheLifecycleListeners) {
            listener.cacheCreated(this);
        }
        if (this.isClient()) {
            GemFireCacheImpl.initializeClientRegionShortcuts(this);
        } else {
            GemFireCacheImpl.initializeRegionShortcuts(this);
        }
        ClassPathLoader.setLatestToDefault(this.system.getConfig().getDeployWorkingDir());
        try {
            this.ccLoader.deployJarsReceivedFromClusterConfiguration(this.configurationResponse);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new GemFireConfigException("Exception while deploying the jars received as a part of cluster Configuration", e);
        }
        SystemMemberCacheEventProcessor.send(this, Operation.CACHE_CREATE);
        this.resourceAdvisor.initializationGate();
        this.functionServiceRegisterFunction.accept(new FindRestEnabledServersFunction());
        this.jmxAdvisor.initializationGate();
        this.initializeServices();
        this.system.handleResourceEvent(ResourceEvent.CACHE_CREATE, this);
        this.handleResourceEventsForCacheServices();
        boolean completedCacheXml = false;
        try {
            if (!this.isClient) {
                this.applyJarAndXmlFromClusterConfig();
            }
            this.initializeDeclarativeCache();
            completedCacheXml = true;
        }
        catch (Throwable throwable) {
            logger.error("Cache initialization for " + this.toString() + " failed because:", throwable);
            throw throwable;
        }
        finally {
            if (!completedCacheXml) {
                try {
                    this.close();
                }
                catch (Throwable listener) {}
                this.configurationResponse = null;
            }
        }
        this.system.handleResourceEvent(ResourceEvent.CLUSTER_CONFIGURATION_APPLIED, this);
        this.startColocatedJmxManagerLocator();
        this.startRestAgentServer(this);
        this.isInitialized = true;
    }

    @VisibleForTesting
    void applyJarAndXmlFromClusterConfig() {
        if (this.configurationResponse == null) {
            ClassPathLoader.getLatest().getJarDeployer().loadPreviouslyDeployedJarsFromDisk();
        }
        this.ccLoader.applyClusterXmlConfiguration(this, this.configurationResponse, this.system.getConfig().getGroups());
    }

    private void initializeServices() {
        ServiceLoader<CacheService> loader = ServiceLoader.load(CacheService.class);
        for (CacheService service : loader) {
            try {
                if (!service.init(this)) continue;
                this.services.put(service.getInterface(), service);
                logger.info("Initialized cache service {}", (Object)service.getClass().getName());
            }
            catch (Exception ex) {
                logger.warn("Cache service " + service.getClass().getName() + " failed to initialize", (Throwable)ex);
            }
        }
    }

    private void handleResourceEventsForCacheServices() {
        for (CacheService service : this.services.values()) {
            this.system.handleResourceEvent(ResourceEvent.CACHE_SERVICE_CREATE, service);
        }
    }

    private boolean isServerNode() {
        return this.system.getDistributedMember().getVmKind() != 11 && this.system.getDistributedMember().getVmKind() != 12 && !this.isClient();
    }

    private void startRestAgentServer(InternalCache cache) {
        if (this.system.getConfig().getStartDevRestApi() && this.isServerNode()) {
            this.restAgent = new RestAgent(this.system.getConfig(), this.securityService);
            this.restAgent.start(cache);
        } else {
            this.restAgent = null;
        }
    }

    @Override
    public URL getCacheXmlURL() {
        File defaultFile;
        URL url;
        if (this.getMyId().getVmKind() == 11) {
            return null;
        }
        File xmlFile = testCacheXml;
        if (xmlFile == null) {
            xmlFile = this.system.getConfig().getCacheXmlFile();
        }
        if (xmlFile.getName().isEmpty()) {
            return null;
        }
        if (!xmlFile.exists() || !xmlFile.isFile()) {
            String resource = xmlFile.getPath();
            if ((resource = DOUBLE_BACKSLASH.matcher(resource).replaceAll("/")).length() > 1 && resource.startsWith("/")) {
                resource = resource.substring(1);
            }
            url = ClassPathLoader.getLatest().getResource(this.getClass(), resource);
        } else {
            try {
                url = xmlFile.toURL();
            }
            catch (MalformedURLException ex) {
                throw new CacheXmlException(String.format("Could not convert XML file %s to an URL.", xmlFile), ex);
            }
        }
        if (url == null && !xmlFile.equals(defaultFile = DistributionConfig.DEFAULT_CACHE_XML_FILE)) {
            if (!xmlFile.exists()) {
                throw new CacheXmlException(String.format("Declarative Cache XML file/resource %s does not exist.", xmlFile));
            }
            throw new CacheXmlException(String.format("Declarative XML file %s is not a file.", xmlFile));
        }
        return url;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeDeclarativeCache() throws TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        URL url = this.getCacheXmlURL();
        String cacheXmlDescription = this.cacheConfig.getCacheXMLDescription();
        if (url == null && cacheXmlDescription == null) {
            this.initializePdxRegistry();
            this.readyDynamicRegionFactory();
            return;
        }
        InputStream stream = null;
        try {
            GemFireCacheImpl.logCacheXML(url, cacheXmlDescription);
            if (cacheXmlDescription != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("initializing cache with generated XML: {}", (Object)cacheXmlDescription);
                }
                stream = new StringBufferInputStream(cacheXmlDescription);
            } else {
                stream = url.openStream();
            }
            this.loadCacheXml(stream);
        }
        catch (IOException ex) {
            try {
                throw new CacheXmlException(String.format("While opening Cache XML %s the following error occurred %s", url.toString(), ex));
                catch (CacheXmlException ex2) {
                    throw new CacheXmlException(String.format("While reading Cache XML %s. %s", url, ex2.getMessage()), ex2.getCause());
                }
            }
            catch (Throwable throwable) {
                GemFireCacheImpl.closeQuietly(stream);
                throw throwable;
            }
        }
        GemFireCacheImpl.closeQuietly(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void logCacheXML(URL url, String cacheXmlDescription) {
        block8: {
            block6: {
                if (cacheXmlDescription != null) break block6;
                StringBuilder sb = new StringBuilder();
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new InputStreamReader(url.openStream()));
                    String line = br.readLine();
                    while (line != null) {
                        if (!line.isEmpty()) {
                            sb.append(System.lineSeparator()).append(line);
                        }
                        line = br.readLine();
                    }
                }
                catch (IOException iOException) {
                    GemFireCacheImpl.closeQuietly(br);
                    catch (Throwable throwable) {
                        GemFireCacheImpl.closeQuietly(br);
                        throw throwable;
                    }
                }
                GemFireCacheImpl.closeQuietly(br);
                logger.info("Initializing cache using {}:{}", (Object)url, (Object)sb);
                break block8;
            }
            logger.info("Initializing cache using {}:{}", (Object)"generated description from old cache", (Object)cacheXmlDescription);
        }
    }

    @Override
    public synchronized void initializePdxRegistry() {
        if (this.pdxRegistry == null) {
            this.pdxRegistry = this.getMyId().getVmKind() == 11 ? this.typeRegistryFactory.create(this, true) : this.typeRegistryFactory.create(this, false);
            this.pdxRegistry.initialize();
        }
    }

    @Override
    public void readyDynamicRegionFactory() {
        try {
            ((DynamicRegionFactoryImpl)DynamicRegionFactory.get()).internalInit(this);
        }
        catch (CacheException ce) {
            throw new GemFireCacheException("dynamic region initialization failed", ce);
        }
    }

    @Override
    public DiskStoreFactory createDiskStoreFactory() {
        return new DiskStoreFactoryImpl(this);
    }

    @Override
    public DiskStoreFactory createDiskStoreFactory(DiskStoreAttributes attrs) {
        return new DiskStoreFactoryImpl(this, attrs);
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    @Override
    public boolean forcedDisconnect() {
        return this.forcedDisconnect || this.system.forcedDisconnect();
    }

    @Override
    public CacheClosedException getCacheClosedException(String reason) {
        return this.getCacheClosedException(reason, null);
    }

    @Override
    public CacheClosedException getCacheClosedException(String reason, Throwable cause) {
        CacheClosedException result = cause != null ? new CacheClosedException(reason, cause) : (this.disconnectCause != null ? new CacheClosedException(reason, this.disconnectCause) : new CacheClosedException(reason));
        return result;
    }

    @Override
    @VisibleForTesting
    public Throwable getDisconnectCause() {
        return this.disconnectCause;
    }

    @Override
    public boolean keepDurableSubscriptionsAlive() {
        return this.keepAlive;
    }

    public static void emergencyClose() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null) {
            return;
        }
        InternalDistributedSystem ids = cache.system;
        if (ids != null) {
            ids.emergencyClose();
        }
        cache.disconnectCause = SystemFailure.getFailure();
        cache.isClosing = true;
        for (InternalCacheServer cacheServer : cache.allCacheServers) {
            Acceptor acceptor = cacheServer.getAcceptor();
            if (acceptor == null) continue;
            acceptor.emergencyClose();
        }
        GemFireCacheImpl.closeGateWayReceiverServers(cache);
        PoolManagerImpl.emergencyClose();
        cache.rootRegions.clear();
        cache.partitionedRegions.clear();
    }

    private static void closeGateWayReceiverServers(GemFireCacheImpl cache) {
        Acceptor acceptor;
        InternalCacheServer receiverServer = cache.gatewayReceiverServer.get();
        if (receiverServer != null && (acceptor = receiverServer.getAcceptor()) != null) {
            acceptor.emergencyClose();
        }
    }

    @Override
    public boolean isCacheAtShutdownAll() {
        return this.isShutDownAll.get();
    }

    private void shutdownSubTreeGracefully(Map<String, PartitionedRegion> prSubMap) {
        for (PartitionedRegion pr : prSubMap.values()) {
            this.shutDownOnePRGracefully(pr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutDownAll() {
        if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
            try {
                CacheObserverHolder.getInstance().beforeShutdownAll();
            }
            finally {
                LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = false;
            }
        }
        if (!this.isShutDownAll.compareAndSet(false, true)) {
            try {
                this.shutDownAllFinished.await();
            }
            catch (InterruptedException ignore) {
                logger.debug("Shutdown all interrupted while waiting for another thread to do the shutDownAll");
                Thread.currentThread().interrupt();
            }
            return;
        }
        Class<GemFireCacheImpl> clazz = GemFireCacheImpl.class;
        synchronized (GemFireCacheImpl.class) {
            try {
                boolean testIGE = Boolean.getBoolean("TestInternalGemFireError");
                if (testIGE) {
                    throw new InternalGemFireError("unexpected exception");
                }
                Map<String, Map<String, PartitionedRegion>> prTrees = this.getPRTrees();
                if (prTrees.size() > 1 && shutdownAllPoolSize != 1) {
                    ExecutorService es = this.getShutdownAllExecutorService(prTrees.size());
                    for (Map<String, PartitionedRegion> prSubMap : prTrees.values()) {
                        es.execute(() -> {
                            ConnectionTable.threadWantsSharedResources();
                            this.shutdownSubTreeGracefully(prSubMap);
                        });
                    }
                    es.shutdown();
                    try {
                        es.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException ignore) {
                        logger.debug("Shutdown all interrupted while waiting for PRs to be shutdown gracefully.");
                    }
                } else {
                    for (Map<String, PartitionedRegion> prSubMap : prTrees.values()) {
                        this.shutdownSubTreeGracefully(prSubMap);
                    }
                }
                this.close("Shut down all members", null, false, true, false);
            }
            finally {
                this.shutDownAllFinished.countDown();
            }
            // ** MonitorExit[var1_3] (shouldn't be in output)
            return;
        }
    }

    private ExecutorService getShutdownAllExecutorService(int size) {
        return LoggingExecutors.newFixedThreadPool((String)"ShutdownAll-", (boolean)true, (int)(shutdownAllPoolSize == -1 ? size : shutdownAllPoolSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutDownOnePRGracefully(PartitionedRegion partitionedRegion) {
        boolean acquiredLock = false;
        try {
            partitionedRegion.acquireDestroyLock();
            acquiredLock = true;
            PRHARedundancyProvider pRHARedundancyProvider = partitionedRegion.getRedundancyProvider();
            synchronized (pRHARedundancyProvider) {
                if (partitionedRegion.isDataStore() && partitionedRegion.getDataStore() != null && partitionedRegion.getDataPolicy() == DataPolicy.PERSISTENT_PARTITION) {
                    int numBuckets = partitionedRegion.getTotalNumberOfBuckets();
                    Map[] bucketMaps = (Map[])UncheckedUtils.uncheckedCast((Object)new Map[numBuckets]);
                    PartitionedRegionDataStore dataStore = partitionedRegion.getDataStore();
                    Set<Map.Entry<Integer, BucketRegion>> bucketEntries = dataStore.getAllLocalBuckets();
                    for (Map.Entry<Integer, BucketRegion> e : bucketEntries) {
                        BucketRegion bucket = e.getValue();
                        if (bucket == null || bucket.isDestroyed) continue;
                        bucket.getBucketAdvisor().tryLockIfPrimary();
                        bucketMaps[bucket.getId()] = bucket.getBucketAdvisor().adviseInitializedPersistentMembers();
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("shutDownAll: PR {}: initialized persistent members for {}:{}", (Object)partitionedRegion.getName(), (Object)bucket.getId(), (Object)bucketMaps[bucket.getId()]);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("shutDownAll: All buckets for PR {} are locked.", (Object)partitionedRegion.getName());
                    }
                    partitionedRegion.setShutDownAllStatus(1);
                    new UpdateAttributesProcessor(partitionedRegion).distribute(false);
                    partitionedRegion.getRegionAdvisor().waitForProfileStatus(1);
                    if (logger.isDebugEnabled()) {
                        logger.debug("shutDownAll: PR {}: all bucketLock profiles received.", (Object)partitionedRegion.getName());
                    }
                    if (!partitionedRegion.getAttributes().isDiskSynchronous()) {
                        partitionedRegion.getDiskStore().forceFlush();
                        partitionedRegion.setShutDownAllStatus(2);
                        new UpdateAttributesProcessor(partitionedRegion).distribute(false);
                        partitionedRegion.getRegionAdvisor().waitForProfileStatus(2);
                        if (logger.isDebugEnabled()) {
                            logger.debug("shutDownAll: PR {}: all flush profiles received.", (Object)partitionedRegion.getName());
                        }
                    }
                    Set<InternalDistributedMember> membersToPersistOfflineEqual = partitionedRegion.getRegionAdvisor().adviseDataStore();
                    for (Map.Entry<Integer, BucketRegion> e : bucketEntries) {
                        Map<InternalDistributedMember, PersistentMemberID> persistMap;
                        BucketRegion bucket = e.getValue();
                        if (bucket == null || bucket.isDestroyed || (persistMap = GemFireCacheImpl.getSubMapForLiveMembers(membersToPersistOfflineEqual, bucketMaps[bucket.getId()])) == null) continue;
                        bucket.getPersistenceAdvisor().persistMembersOfflineAndEqual(persistMap);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("shutDownAll: PR {}: persisting bucket {}:{}", (Object)partitionedRegion.getName(), (Object)bucket.getId(), persistMap);
                    }
                    partitionedRegion.setShutDownAllStatus(3);
                    new UpdateAttributesProcessor(partitionedRegion).distribute(false);
                    partitionedRegion.getRegionAdvisor().waitForProfileStatus(3);
                    if (logger.isDebugEnabled()) {
                        logger.debug("shutDownAll: PR {}: all offline_equal profiles received.", (Object)partitionedRegion.getName());
                    }
                }
                RegionEventImpl event = new RegionEventImpl((Region)partitionedRegion, Operation.REGION_CLOSE, null, false, (DistributedMember)this.getMyId(), true);
                try {
                    partitionedRegion.basicDestroyRegion(event, false, false, true);
                }
                catch (CacheWriterException e) {
                    throw new Error("CacheWriterException should not be thrown in localDestroyRegion", e);
                }
                catch (TimeoutException e) {
                    throw new Error("TimeoutException should not be thrown in localDestroyRegion", e);
                }
            }
        }
        catch (CacheClosedException cce) {
            logger.debug("Encounter CacheClosedException when shutDownAll is closing PR: {}:{}", (Object)partitionedRegion.getFullPath(), (Object)cce.getMessage());
        }
        catch (CancelException ce) {
            logger.debug("Encounter CancelException when shutDownAll is closing PR: {}:{}", (Object)partitionedRegion.getFullPath(), (Object)ce.getMessage());
        }
        catch (RegionDestroyedException rde) {
            logger.debug("Encounter CacheDestroyedException when shutDownAll is closing PR: {}:{}", (Object)partitionedRegion.getFullPath(), (Object)rde.getMessage());
        }
        finally {
            if (acquiredLock) {
                partitionedRegion.releaseDestroyLock();
            }
        }
    }

    private static Map<InternalDistributedMember, PersistentMemberID> getSubMapForLiveMembers(Set<InternalDistributedMember> membersToPersistOfflineEqual, Map<InternalDistributedMember, PersistentMemberID> bucketMap) {
        if (bucketMap == null) {
            return null;
        }
        HashMap<InternalDistributedMember, PersistentMemberID> persistMap = new HashMap<InternalDistributedMember, PersistentMemberID>();
        for (InternalDistributedMember member : membersToPersistOfflineEqual) {
            if (!bucketMap.containsKey(member)) continue;
            persistMap.put(member, bucketMap.get(member));
        }
        return persistMap;
    }

    @Override
    public void close() {
        this.close(false);
    }

    @Override
    public void close(String reason, boolean keepAlive, boolean keepDS) {
        this.close(reason, null, keepAlive, keepDS, false);
    }

    @Override
    public void close(boolean keepAlive) {
        this.close("Normal disconnect", null, keepAlive, false, false);
    }

    @Override
    public void close(String reason, Throwable optionalCause) {
        this.close(reason, optionalCause, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DistributedLockService getPartitionedRegionLockService() {
        Object object = this.prLockServiceLock;
        synchronized (object) {
            block6: {
                this.stopper.checkCancelInProgress(null);
                if (this.prLockService == null) {
                    try {
                        this.prLockService = DLockService.create("__PRLS", this.getInternalDistributedSystem(), true, true, true);
                    }
                    catch (IllegalArgumentException e) {
                        this.prLockService = DistributedLockService.getServiceNamed("__PRLS");
                        if (this.prLockService != null) break block6;
                        throw e;
                    }
                }
            }
            return this.prLockService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DistributedLockService getGatewaySenderLockService() {
        if (this.gatewayLockService == null) {
            Object object = this.gatewayLockServiceLock;
            synchronized (object) {
                block7: {
                    this.stopper.checkCancelInProgress(null);
                    if (this.gatewayLockService == null) {
                        try {
                            this.gatewayLockService = DLockService.create("gatewayEventIdIndexMetaData_lockService", this.getInternalDistributedSystem(), true, true, true);
                        }
                        catch (IllegalArgumentException e) {
                            this.gatewayLockService = DistributedLockService.getServiceNamed("gatewayEventIdIndexMetaData_lockService");
                            if (this.gatewayLockService != null) break block7;
                            throw e;
                        }
                    }
                }
            }
        }
        return this.gatewayLockService;
    }

    private void destroyPartitionedRegionLockService() {
        try {
            DistributedLockService.destroy("__PRLS");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void destroyGatewaySenderLockService() {
        if (DistributedLockService.getServiceNamed("gatewayEventIdIndexMetaData_lockService") != null) {
            try {
                DistributedLockService.destroy("gatewayEventIdIndexMetaData_lockService");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public HeapEvictor getHeapEvictor() {
        Object object = this.heapEvictorLock;
        synchronized (object) {
            this.stopper.checkCancelInProgress(null);
            if (this.heapEvictor == null) {
                this.heapEvictor = this.heapEvictorFactory.create(this, this.statisticsClock);
            }
            return this.heapEvictor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public OffHeapEvictor getOffHeapEvictor() {
        Object object = this.offHeapEvictorLock;
        synchronized (object) {
            this.stopper.checkCancelInProgress(null);
            if (this.offHeapEvictor == null) {
                this.offHeapEvictor = new OffHeapEvictor(this, this.statisticsClock);
            }
            return this.offHeapEvictor;
        }
    }

    @VisibleForTesting
    void setOffHeapEvictor(OffHeapEvictor evictor) {
        this.offHeapEvictor = evictor;
    }

    @VisibleForTesting
    void setHeapEvictor(HeapEvictor evictor) {
        this.heapEvictor = evictor;
    }

    @Override
    public PersistentMemberManager getPersistentMemberManager() {
        return this.persistentMemberManager;
    }

    @Override
    public ClientMetadataService getClientMetadataService() {
        this.stopper.checkCancelInProgress(null);
        return this.clientMetadataService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(String reason, Throwable systemFailureCause, boolean keepAlive, boolean keepDS, boolean skipAwait) {
        this.securityService.close();
        if (this.isClosed()) {
            if (!skipAwait && !Thread.currentThread().equals(CLOSING_THREAD.get())) {
                this.waitUntilClosed();
            }
            return;
        }
        if (!keepDS && systemFailureCause == null && (this.isReconnecting() || this.system.getReconnectedSystem() != null)) {
            logger.debug("Cache is shutting down distributed system connection. isReconnecting={} reconnectedSystem={} keepAlive={} keepDS={}", (Object)this.isReconnecting(), (Object)this.system.getReconnectedSystem(), (Object)keepAlive, (Object)keepDS);
            this.system.stopReconnectingNoDisconnect();
            if (this.system.getReconnectedSystem() != null) {
                this.system.getReconnectedSystem().disconnect();
            }
            return;
        }
        Class<GemFireCacheImpl> clazz = GemFireCacheImpl.class;
        synchronized (GemFireCacheImpl.class) {
            if (this.isClosed()) {
                if (!skipAwait && !Thread.currentThread().equals(CLOSING_THREAD.get())) {
                    this.waitUntilClosed();
                }
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return;
            }
            CLOSING_THREAD.set(Thread.currentThread());
            try {
                boolean isDebugEnabled = logger.isDebugEnabled();
                this.system.handleResourceEvent(ResourceEvent.CACHE_REMOVE, this);
                if (this.resourceEventsListener != null) {
                    this.system.removeResourceListener(this.resourceEventsListener);
                    this.resourceEventsListener = null;
                }
                if (systemFailureCause != null) {
                    this.forcedDisconnect = systemFailureCause instanceof ForcedDisconnectException;
                    this.disconnectCause = this.forcedDisconnect ? new ForcedDisconnectException(reason) : systemFailureCause;
                }
                this.keepAlive = keepAlive;
                this.isClosing = true;
                logger.info("{}: Now closing.", (Object)this);
                if (systemFailureCause == null) {
                    PartitionedRegion.clearPRIdMap();
                }
                TXStateProxy tx = null;
                try {
                    Iterator<CacheLifecycleListener> iterator;
                    if (this.transactionManager != null) {
                        tx = this.transactionManager.pauseTransaction();
                    }
                    this.resourceManager.close();
                    try {
                        this.resourceAdvisor.close();
                    }
                    catch (CancelException cancelException) {
                        // empty catch block
                    }
                    try {
                        this.jmxAdvisor.close();
                    }
                    catch (CancelException cancelException) {
                        // empty catch block
                    }
                    for (GatewaySender sender : this.allGatewaySenders) {
                        try {
                            sender.stop();
                            GatewaySenderAdvisor advisor = ((AbstractGatewaySender)sender).getSenderAdvisor();
                            if (advisor == null) continue;
                            if (isDebugEnabled) {
                                logger.debug("Stopping the GatewaySender advisor");
                            }
                            advisor.close();
                        }
                        catch (CancelException advisor) {}
                    }
                    this.destroyGatewaySenderLockService();
                    if (this.eventThreadPool != null) {
                        if (isDebugEnabled) {
                            logger.debug("{}: stopping event thread pool...", (Object)this);
                        }
                        this.eventThreadPool.shutdown();
                    }
                    try {
                        ClientMetadataService cms;
                        block71: {
                            this.stopServers();
                            this.stopServices();
                            if (isDebugEnabled) {
                                logger.debug("{}: clearing partitioned regions...", (Object)this);
                            }
                            iterator = this.partitionedRegions;
                            synchronized (iterator) {
                                int prSize = -this.partitionedRegions.size();
                                this.partitionedRegions.clear();
                                this.getCachePerfStats().incPartitionedRegions(prSize);
                            }
                            this.prepareDiskStoresForClose();
                            Operation op = this.forcedDisconnect ? Operation.FORCED_DISCONNECT : (this.isReconnecting() ? Operation.CACHE_RECONNECT : Operation.CACHE_CLOSE);
                            InternalRegion prRoot = null;
                            for (InternalRegion lr : this.rootRegions.values()) {
                                if (isDebugEnabled) {
                                    logger.debug("{}: processing region {}", (Object)this, (Object)lr.getFullPath());
                                }
                                if ("__PR".equals(lr.getName())) {
                                    prRoot = lr;
                                    continue;
                                }
                                if (lr.getName().contains("_PARALLEL_GATEWAY_SENDER_QUEUE")) continue;
                                if (isDebugEnabled) {
                                    logger.debug("{}: closing region {}...", (Object)this, (Object)lr.getFullPath());
                                }
                                try {
                                    lr.handleCacheClose(op);
                                }
                                catch (RuntimeException e) {
                                    if (!isDebugEnabled && this.forcedDisconnect) continue;
                                    logger.warn(String.format("%s: error closing region %s", this, lr.getFullPath()), (Throwable)e);
                                }
                            }
                            try {
                                if (isDebugEnabled) {
                                    logger.debug("{}: finishing partitioned region close...", (Object)this);
                                }
                                PartitionedRegion.afterRegionsClosedByCacheClose(this);
                                if (prRoot != null) {
                                    prRoot.handleCacheClose(op);
                                }
                            }
                            catch (CancelException e) {
                                logger.warn(String.format("%s: error in last stage of PartitionedRegion cache close", this), (Throwable)e);
                            }
                            this.destroyPartitionedRegionLockService();
                            this.closeDiskStores();
                            this.diskMonitor.close();
                            try {
                                if (isDebugEnabled) {
                                    logger.debug("{}: closing CQ service...", (Object)this);
                                }
                                this.cqService.close();
                            }
                            catch (RuntimeException ignore) {
                                logger.info("Failed to get the CqService, to close during cache close (1).");
                            }
                            PoolManager.close(keepAlive);
                            if (isDebugEnabled) {
                                logger.debug("{}: notifying admins of close...", (Object)this);
                            }
                            try {
                                SystemMemberCacheEventProcessor.send(this, Operation.CACHE_CLOSE);
                            }
                            catch (CancelException ignore) {
                                if (!logger.isDebugEnabled()) break block71;
                                logger.debug("Ignored cancellation while notifying admins");
                            }
                        }
                        if (isDebugEnabled) {
                            logger.debug("{}: stopping destroyed entries processor...", (Object)this);
                        }
                        this.tombstoneService.stop();
                        DistributionManager distributionManager = null;
                        try {
                            distributionManager = this.system.getDistributionManager();
                            distributionManager.removeMembershipListener(this.transactionManager);
                        }
                        catch (CancelException lr) {
                            // empty catch block
                        }
                        if (distributionManager != null) {
                            if (isDebugEnabled) {
                                logger.debug("{}: sending CloseCache to peers...", (Object)this);
                            }
                            Set<InternalDistributedMember> otherMembers = distributionManager.getOtherDistributionManagerIds();
                            ReplyProcessor21 processor = this.replyProcessor21Factory.create(this.system, otherMembers);
                            CloseCacheMessage msg = new CloseCacheMessage();
                            msg.setRecipients(otherMembers);
                            msg.setProcessorId(processor.getProcessorId());
                            distributionManager.putOutgoing(msg);
                            try {
                                processor.waitForReplies();
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (ReplyException replyException) {
                                // empty catch block
                            }
                        }
                        if ((cms = this.clientMetadataService) != null) {
                            cms.close();
                        }
                        this.closeHeapEvictor();
                        this.closeOffHeapEvictor();
                    }
                    catch (CancelException ignore) {
                        this.closeDiskStores();
                    }
                    try {
                        this.cqService.close();
                    }
                    catch (RuntimeException ignore) {
                        logger.info("Failed to get the CqService, to close during cache close (2).");
                    }
                    this.cachePerfStats.close();
                    TXLockService.destroyServices();
                    this.getEventTrackerTask().cancel();
                    iterator = this.ccpTimerMutex;
                    synchronized (iterator) {
                        if (this.ccpTimer != null) {
                            this.ccpTimer.cancel();
                        }
                    }
                    this.expirationScheduler.cancel();
                    if (this.queryMonitor != null) {
                        this.queryMonitor.stopMonitoring();
                    }
                }
                finally {
                    if (this.transactionManager != null) {
                        this.transactionManager.close();
                    }
                    ((DynamicRegionFactoryImpl)DynamicRegionFactory.get()).close();
                    if (this.transactionManager != null) {
                        this.transactionManager.unpauseTransaction(tx);
                    }
                    TXCommitMessage.getTracker().clearForCacheClose();
                }
                TransactionManagerImpl.refresh();
                if (!keepDS && !this.disableDisconnectDsOnCacheClose) {
                    this.system.disconnect();
                }
                this.typeRegistryClose.run();
                this.typeRegistrySetPdxSerializer.accept(null);
                for (CacheLifecycleListener listener : cacheLifecycleListeners) {
                    listener.cacheClosed(this);
                }
                SequenceLoggerImpl.signalCacheClose();
                SystemFailure.signalCacheClose();
                this.isClosedLatch.countDown();
            }
            finally {
                CLOSING_THREAD.remove();
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    private void waitUntilClosed() {
        try {
            this.isClosedLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void stopServices() {
        for (CacheService service : this.services.values()) {
            try {
                service.close();
            }
            catch (Throwable t) {
                logger.warn("Error stopping service " + service, t);
            }
        }
    }

    private void closeOffHeapEvictor() {
        OffHeapEvictor evictor = this.offHeapEvictor;
        if (evictor != null) {
            evictor.close();
        }
    }

    private void closeHeapEvictor() {
        HeapEvictor evictor = this.heapEvictor;
        if (evictor != null) {
            evictor.close();
        }
    }

    @Override
    public boolean isReconnecting() {
        return this.system.isReconnecting();
    }

    @Override
    public boolean waitUntilReconnected(long time, TimeUnit units) throws InterruptedException {
        try {
            boolean systemReconnected = this.system.waitUntilReconnected(time, units);
            if (!systemReconnected) {
                return false;
            }
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            return cache != null && cache.isInitialized();
        }
        catch (CancelException e) {
            throw new CacheClosedException("Cache could not be recreated", e);
        }
    }

    @Override
    public void stopReconnecting() {
        this.system.stopReconnecting();
    }

    @Override
    public Cache getReconnectedCache() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == this || cache != null && !cache.isInitialized()) {
            cache = null;
        }
        return cache;
    }

    private void prepareDiskStoresForClose() {
        String pdxDSName = this.typeRegistryGetPdxDiskStoreName.apply(this);
        DiskStoreImpl pdxDiskStore = null;
        for (DiskStoreImpl dsi : this.diskStores.values()) {
            if (dsi.getName().equals(pdxDSName)) {
                pdxDiskStore = dsi;
                continue;
            }
            dsi.prepareForClose();
        }
        if (pdxDiskStore != null) {
            pdxDiskStore.prepareForClose();
        }
    }

    @Override
    public void addDiskStore(DiskStoreImpl dsi) {
        this.diskStores.put(dsi.getName(), dsi);
        if (!dsi.isOffline()) {
            this.diskMonitor.addDiskStore(dsi);
        }
    }

    @Override
    public void removeDiskStore(DiskStoreImpl diskStore) {
        this.diskStores.remove(diskStore.getName());
        this.regionOwnedDiskStores.remove(diskStore.getName());
        if (!diskStore.getOwnedByRegion()) {
            this.system.handleResourceEvent(ResourceEvent.DISKSTORE_REMOVE, diskStore);
        }
    }

    @Override
    public void addRegionOwnedDiskStore(DiskStoreImpl dsi) {
        this.regionOwnedDiskStores.put(dsi.getName(), dsi);
        if (!dsi.isOffline()) {
            this.diskMonitor.addDiskStore(dsi);
        }
    }

    @Override
    @VisibleForTesting
    public void closeDiskStores() {
        Iterator it = this.diskStores.values().iterator();
        while (it.hasNext()) {
            try {
                DiskStoreImpl dsi = (DiskStoreImpl)it.next();
                if (logger.isDebugEnabled()) {
                    logger.debug("closing {}", (Object)dsi);
                }
                dsi.close();
                this.system.handleResourceEvent(ResourceEvent.DISKSTORE_REMOVE, dsi);
            }
            catch (RuntimeException e) {
                logger.fatal("Cache close caught an exception during disk store close", (Throwable)e);
            }
            it.remove();
        }
    }

    @VisibleForTesting
    public static void setDefaultDiskStoreName(String dsName) {
        defaultDiskStoreName = dsName;
    }

    public static String getDefaultDiskStoreName() {
        return defaultDiskStoreName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiskStoreImpl getOrCreateDefaultDiskStore() {
        DiskStoreImpl result = (DiskStoreImpl)this.findDiskStore(null);
        if (result == null) {
            GemFireCacheImpl gemFireCacheImpl = this;
            synchronized (gemFireCacheImpl) {
                result = (DiskStoreImpl)this.findDiskStore(null);
                if (result == null) {
                    result = (DiskStoreImpl)this.createDiskStoreFactory().create(defaultDiskStoreName);
                }
            }
        }
        return result;
    }

    @Override
    public DiskStore findDiskStore(String name) {
        if (name == null) {
            name = defaultDiskStoreName;
        }
        return (DiskStore)this.diskStores.get(name);
    }

    @Override
    public Collection<DiskStore> listDiskStores() {
        return Collections.unmodifiableCollection(this.diskStores.values());
    }

    @Override
    public Collection<DiskStore> listDiskStoresIncludingRegionOwned() {
        HashSet<DiskStore> allDiskStores = new HashSet<DiskStore>();
        allDiskStores.addAll(this.diskStores.values());
        allDiskStores.addAll(this.regionOwnedDiskStores.values());
        return allDiskStores;
    }

    private void stopServers() {
        block19: {
            boolean isDebugEnabled;
            block18: {
                isDebugEnabled = logger.isDebugEnabled();
                if (isDebugEnabled) {
                    logger.debug("{}: stopping cache servers...", (Object)this);
                }
                boolean stoppedCacheServer = false;
                for (InternalCacheServer cacheServer : this.allCacheServers) {
                    block16: {
                        if (isDebugEnabled) {
                            logger.debug("stopping bridge {}", (Object)cacheServer);
                        }
                        try {
                            cacheServer.stop();
                        }
                        catch (CancelException e) {
                            if (!isDebugEnabled) break block16;
                            logger.debug("Ignored cache closure while closing bridge {}", (Object)cacheServer, (Object)e);
                        }
                    }
                    this.allCacheServers.remove(cacheServer);
                    stoppedCacheServer = true;
                }
                InternalCacheServer receiverServer = this.gatewayReceiverServer.getAndSet(null);
                if (receiverServer != null) {
                    block17: {
                        if (isDebugEnabled) {
                            logger.debug("stopping gateway receiver server {}", (Object)receiverServer);
                        }
                        try {
                            receiverServer.stop();
                        }
                        catch (CancelException e) {
                            if (!isDebugEnabled) break block17;
                            logger.debug("Ignored cache closure while closing gateway receiver server {}", (Object)receiverServer, (Object)e);
                        }
                    }
                    stoppedCacheServer = true;
                }
                if (stoppedCacheServer) {
                    ServerConnection.emptyCommBufferPool();
                }
                if (isDebugEnabled) {
                    logger.debug("{}: stopping HA services...", (Object)this);
                }
                try {
                    HARegionQueue.stopHAServices();
                }
                catch (CancelException e) {
                    if (!isDebugEnabled) break block18;
                    logger.debug("Ignored cache closure while closing HA services", (Throwable)e);
                }
            }
            if (isDebugEnabled) {
                logger.debug("{}: stopping client health monitor...", (Object)this);
            }
            try {
                ClientHealthMonitor.shutdownInstance();
            }
            catch (CancelException e) {
                if (!isDebugEnabled) break block19;
                logger.debug("Ignored cache closure while closing client health monitor", (Throwable)e);
            }
        }
        ClientProxyMembershipID.resetUniqueIdCounter();
    }

    @Override
    public DistributedSystem getDistributedSystem() {
        return this.system;
    }

    @Override
    public InternalDistributedSystem getInternalDistributedSystem() {
        return this.system;
    }

    @Override
    public InternalDistributedMember getMyId() {
        return this.system.getDistributedMember();
    }

    @Override
    public Set<DistributedMember> getMembers() {
        return Collections.unmodifiableSet(this.dm.getOtherNormalDistributionManagerIds());
    }

    @Override
    public Set<DistributedMember> getAdminMembers() {
        return (Set)UncheckedUtils.uncheckedCast(this.dm.getAdminMemberSet());
    }

    @Override
    public Set<DistributedMember> getMembers(Region region) {
        if (region instanceof DistributedRegion) {
            DistributedRegion distributedRegion = (DistributedRegion)region;
            return (Set)UncheckedUtils.uncheckedCast(distributedRegion.getDistributionAdvisor().adviseCacheOp());
        }
        if (region instanceof PartitionedRegion) {
            PartitionedRegion partitionedRegion = (PartitionedRegion)region;
            return (Set)UncheckedUtils.uncheckedCast(partitionedRegion.getRegionAdvisor().adviseAllPRNodes());
        }
        return Collections.emptySet();
    }

    @Override
    public Set<InetSocketAddress> getCurrentServers() {
        Map<String, Pool> pools = PoolManager.getAll();
        HashSet<InetSocketAddress> result = null;
        for (Pool pool : pools.values()) {
            PoolImpl poolImpl = (PoolImpl)pool;
            for (ServerLocation serverLocation : poolImpl.getCurrentServers()) {
                if (result == null) {
                    result = new HashSet<InetSocketAddress>();
                }
                result.add(InetSocketAddress.createUnresolved(serverLocation.getHostName(), serverLocation.getPort()));
            }
        }
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    @Override
    public LogWriter getLogger() {
        return this.system.getLogWriter();
    }

    @Override
    public LogWriter getSecurityLogger() {
        return this.system.getSecurityLogWriter();
    }

    @Override
    public LogWriterI18n getLoggerI18n() {
        return this.system.getInternalLogWriter();
    }

    @Override
    public LogWriterI18n getSecurityLoggerI18n() {
        return this.system.getSecurityInternalLogWriter();
    }

    @Override
    @Deprecated
    public InternalLogWriter getInternalLogWriter() {
        return this.system.getInternalLogWriter();
    }

    @Override
    @Deprecated
    public InternalLogWriter getSecurityInternalLogWriter() {
        return this.system.getSecurityInternalLogWriter();
    }

    @Override
    public EventTrackerExpiryTask getEventTrackerTask() {
        return this.recordedEventSweeper;
    }

    @Override
    public CachePerfStats getCachePerfStats() {
        return this.cachePerfStats;
    }

    @Override
    public String getName() {
        return this.system.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Properties> getDeclarableProperties(String className) {
        ArrayList<Properties> propertiesList = new ArrayList<Properties>();
        Map<Declarable, Properties> map = this.declarablePropertiesMap;
        synchronized (map) {
            for (Map.Entry<Declarable, Properties> entry : this.declarablePropertiesMap.entrySet()) {
                if (!entry.getKey().getClass().getName().equals(className)) continue;
                propertiesList.add(entry.getValue());
            }
        }
        return propertiesList;
    }

    @Override
    public Properties getDeclarableProperties(Declarable declarable) {
        return this.declarablePropertiesMap.get(declarable);
    }

    @Override
    public long getUpTime() {
        return (System.currentTimeMillis() - this.creationDate.getTime()) / 1000L;
    }

    @Override
    public long cacheTimeMillis() {
        if (this.system != null) {
            return this.system.getClock().cacheTimeMillis();
        }
        return System.currentTimeMillis();
    }

    @Override
    public <K, V> Region<K, V> createVMRegion(String name, RegionAttributes<K, V> aRegionAttributes) throws RegionExistsException, TimeoutException {
        return this.createRegion(name, aRegionAttributes);
    }

    private PoolFactory createDefaultPF() {
        PoolFactory defaultPoolFactory = PoolManager.createFactory();
        try {
            String localHostName = LocalHostUtil.getLocalHostName();
            defaultPoolFactory.addServer(localHostName, 40404);
        }
        catch (UnknownHostException ex) {
            throw new IllegalStateException("Could not determine local host name", ex);
        }
        return defaultPoolFactory;
    }

    private Pool findFirstCompatiblePool(Map<String, Pool> pools) {
        PoolFactoryImpl pfi = (PoolFactoryImpl)this.createDefaultPF();
        for (Pool p : pools.values()) {
            if (!((PoolImpl)p).isCompatible(pfi.getPoolAttributes())) continue;
            return p;
        }
        return null;
    }

    private void addLocalHostAsServer(PoolFactory poolFactory) {
        PoolFactoryImpl poolFactoryImpl = (PoolFactoryImpl)poolFactory;
        if (poolFactoryImpl.getPoolAttributes().locators.isEmpty() && poolFactoryImpl.getPoolAttributes().servers.isEmpty()) {
            try {
                String localHostName = LocalHostUtil.getLocalHostName();
                poolFactoryImpl.addServer(localHostName, 40404);
            }
            catch (UnknownHostException ex) {
                throw new IllegalStateException("Could not determine local host name", ex);
            }
        }
    }

    private synchronized void determineDefaultPool() {
        Map<String, Pool> pools;
        if (!this.isClient()) {
            throw new UnsupportedOperationException();
        }
        PoolFactory defaultPoolFactory = this.poolFactory;
        Pool pool = null;
        if (defaultPoolFactory == null) {
            pools = PoolManager.getAll();
            if (pools.isEmpty()) {
                defaultPoolFactory = this.createDefaultPF();
            } else if (pools.size() == 1) {
                pool = pools.values().iterator().next();
            } else {
                pool = this.findFirstCompatiblePool(pools);
                if (pool == null) {
                    this.defaultPool = null;
                    return;
                }
            }
        } else {
            this.addLocalHostAsServer(defaultPoolFactory);
            pools = PoolManager.getAll();
            for (Pool p : pools.values()) {
                if (!((PoolImpl)p).isCompatible(((PoolFactoryImpl)defaultPoolFactory).getPoolAttributes())) continue;
                pool = p;
                break;
            }
        }
        if (pool == null) {
            String poolName = DEFAULT_POOL_NAME;
            int count = 1;
            Map<String, Pool> pools2 = PoolManager.getAll();
            while (pools2.containsKey(poolName)) {
                poolName = DEFAULT_POOL_NAME + count;
                ++count;
            }
            pool = defaultPoolFactory.create(poolName);
        }
        this.defaultPool = pool;
    }

    @Override
    public void validatePoolFactory(PoolFactory poolFactory) {
        if (poolFactory != null && !Objects.equals(this.poolFactory, poolFactory)) {
            throw new IllegalStateException("Existing cache's default pool was not compatible");
        }
    }

    @Override
    public <K, V> Region<K, V> createRegion(String name, RegionAttributes<K, V> aRegionAttributes) throws RegionExistsException, TimeoutException {
        this.throwIfClient();
        return this.basicCreateRegion(name, aRegionAttributes);
    }

    @Override
    public <K, V> Region<K, V> basicCreateRegion(String name, RegionAttributes<K, V> attrs) throws RegionExistsException, TimeoutException {
        try {
            InternalRegionArguments ira = new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false).setSnapshotInputStream(null).setImageTarget(null);
            if (attrs instanceof UserSpecifiedRegionAttributes) {
                ira.setIndexes(((UserSpecifiedRegionAttributes)attrs).getIndexes());
            }
            return this.createVMRegion(name, attrs, ira);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new InternalGemFireError("unexpected exception", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public <K, V> Region<K, V> createVMRegion(String name, RegionAttributes<K, V> p_attrs, InternalRegionArguments internalRegionArgs) throws RegionExistsException, TimeoutException, IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public <K, V> RegionAttributes<K, V> invokeRegionBefore(InternalRegion parent, String name, RegionAttributes<K, V> attrs, InternalRegionArguments internalRegionArgs) {
        for (RegionListener listener : this.regionListeners) {
            attrs = (RegionAttributes)UncheckedUtils.uncheckedCast((Object)listener.beforeCreate(parent, name, attrs, internalRegionArgs));
        }
        return attrs;
    }

    @Override
    public void invokeRegionAfter(InternalRegion region) {
        for (RegionListener listener : this.regionListeners) {
            listener.afterCreate(region);
        }
    }

    @Override
    public void invokeBeforeDestroyed(InternalRegion region) {
        for (RegionListener listener : this.regionListeners) {
            listener.beforeDestroyed(region);
        }
    }

    @Override
    public void invokeCleanupFailedInitialization(InternalRegion region) {
        for (RegionListener listener : this.regionListeners) {
            listener.cleanupFailedInitialization(region);
        }
    }

    @Override
    public <K, V> Region<K, V> getRegion(String path) {
        return this.getRegion(path, false);
    }

    @Override
    public Set<InternalRegion> getAllRegions() {
        HashSet<InternalRegion> result = new HashSet<InternalRegion>();
        for (Region region : this.rootRegions.values()) {
            if (region instanceof PartitionedRegion) {
                PartitionedRegion partitionedRegion = (PartitionedRegion)region;
                PartitionedRegionDataStore dataStore = partitionedRegion.getDataStore();
                if (dataStore == null) continue;
                Set<Map.Entry<Integer, BucketRegion>> bucketEntries = partitionedRegion.getDataStore().getAllLocalBuckets();
                for (Map.Entry<Integer, BucketRegion> entry : bucketEntries) {
                    result.add(entry.getValue());
                }
                continue;
            }
            if (!(region instanceof InternalRegion)) continue;
            InternalRegion internalRegion = (InternalRegion)region;
            result.add(internalRegion);
            result.addAll(internalRegion.basicSubregions(true));
        }
        return result;
    }

    @Override
    public Set<InternalRegion> getApplicationRegions() {
        HashSet<InternalRegion> result = new HashSet<InternalRegion>();
        for (Object region : this.rootRegions.values()) {
            InternalRegion internalRegion = (InternalRegion)region;
            if (internalRegion.isInternalRegion()) continue;
            result.add(internalRegion);
            result.addAll(internalRegion.basicSubregions(true));
        }
        return result;
    }

    @Override
    public boolean hasPersistentRegion() {
        for (InternalRegion region : this.rootRegions.values()) {
            if (region.getDataPolicy().withPersistence()) {
                return true;
            }
            for (InternalRegion subRegion : region.basicSubregions(true)) {
                if (!subRegion.getDataPolicy().withPersistence()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setRegionByPath(String path, InternalRegion r) {
        if (r == null) {
            this.pathToRegion.remove(path);
        } else {
            this.pathToRegion.put(path, r);
        }
    }

    private static void validatePath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException("path cannot be empty");
        }
        if (path.equals("/")) {
            throw new IllegalArgumentException(String.format("path cannot be ' %s '", "/"));
        }
    }

    @Override
    public <K, V> Region<K, V> getRegionByPath(String path) {
        return (Region)UncheckedUtils.uncheckedCast((Object)this.getInternalRegionByPath(path));
    }

    @Override
    public InternalRegion getInternalRegionByPath(String path) {
        GemFireCacheImpl.validatePath(path);
        InternalRegion result = this.getReinitializingRegion(path);
        if (result != null) {
            return result;
        }
        return (InternalRegion)this.pathToRegion.get(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalRegion getRegionByPathForProcessing(String path) {
        Region result = this.getRegionByPath(path);
        if (result == null) {
            this.stopper.checkCancelInProgress(null);
            LocalRegion.InitializationLevel oldLevel = LocalRegion.setThreadInitLevelRequirement(LocalRegion.InitializationLevel.ANY_INIT);
            try {
                String[] pathParts = GemFireCacheImpl.parsePath(path);
                InternalRegion rootRegion = (InternalRegion)this.rootRegions.get(pathParts[0]);
                if (rootRegion == null) {
                    InternalRegion internalRegion = null;
                    return internalRegion;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("GemFireCache.getRegion, calling getSubregion on rootRegion({}): {}", (Object)pathParts[0], (Object)pathParts[1]);
                }
                result = rootRegion.getSubregion(pathParts[1], true);
            }
            finally {
                LocalRegion.setThreadInitLevelRequirement(oldLevel);
            }
        }
        return (InternalRegion)result;
    }

    @Override
    public <K, V> Region<K, V> getRegion(String path, boolean returnDestroyedRegion) {
        this.stopper.checkCancelInProgress(null);
        InternalRegion result = this.getInternalRegionByPath(path);
        if (result != null) {
            result.waitOnInitialization();
            if (!returnDestroyedRegion && result.isDestroyed()) {
                this.stopper.checkCancelInProgress(null);
                return null;
            }
            return (Region)UncheckedUtils.uncheckedCast((Object)result);
        }
        String[] pathParts = GemFireCacheImpl.parsePath(path);
        InternalRegion rootRegion = (InternalRegion)this.rootRegions.get(pathParts[0]);
        if (rootRegion == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("GemFireCache.getRegion, no region found for {}", (Object)pathParts[0]);
            }
            this.stopper.checkCancelInProgress(null);
            return null;
        }
        if (!returnDestroyedRegion && rootRegion.isDestroyed()) {
            this.stopper.checkCancelInProgress(null);
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("GemFireCache.getRegion, calling getSubregion on rootRegion({}): {}", (Object)pathParts[0], (Object)pathParts[1]);
        }
        return (Region)UncheckedUtils.uncheckedCast((Object)rootRegion.getSubregion(pathParts[1], returnDestroyedRegion));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isGlobalRegionInitializing(String fullPath) {
        this.stopper.checkCancelInProgress(null);
        LocalRegion.InitializationLevel oldLevel = LocalRegion.setThreadInitLevelRequirement(LocalRegion.InitializationLevel.ANY_INIT);
        try {
            boolean bl = this.isGlobalRegionInitializing((InternalRegion)this.getRegion(fullPath));
            return bl;
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
        }
    }

    private boolean isGlobalRegionInitializing(InternalRegion region) {
        boolean result;
        boolean bl = result = region != null && region.getScope().isGlobal() && !region.isInitialized();
        if (result && logger.isDebugEnabled()) {
            logger.debug("GemFireCache.isGlobalRegionInitializing ({})", (Object)region.getFullPath());
        }
        return result;
    }

    @Override
    public Set<Region<?, ?>> rootRegions() {
        return this.rootRegions(false);
    }

    @Override
    public Set<Region<?, ?>> rootRegions(boolean includePRAdminRegions) {
        return this.rootRegions(includePRAdminRegions, true);
    }

    private Set<Region<?, ?>> rootRegions(boolean includePRAdminRegions, boolean waitForInit) {
        this.stopper.checkCancelInProgress(null);
        HashSet<InternalRegion> regions = new HashSet<InternalRegion>();
        for (InternalRegion region : this.rootRegions.values()) {
            if (region.isSecret() || region.isUsedForMetaRegion() || !includePRAdminRegions && (region.isUsedForPartitionedRegionAdmin() || region.isUsedForPartitionedRegionBucket())) continue;
            regions.add(region);
        }
        if (waitForInit) {
            Iterator iterator = regions.iterator();
            while (iterator.hasNext()) {
                InternalRegion region;
                region = (InternalRegion)iterator.next();
                if (region.checkForInitialization()) continue;
                iterator.remove();
            }
        }
        return Collections.unmodifiableSet(regions);
    }

    @Override
    public void cleanupForClient(CacheClientNotifier ccn, ClientProxyMembershipID client) {
        try {
            if (this.isClosed()) {
                return;
            }
            for (Region<?, ?> region : this.rootRegions(false, false)) {
                InternalRegion internalRegion = (InternalRegion)region;
                internalRegion.cleanupForClient(ccn, client);
            }
        }
        catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
            // empty catch block
        }
    }

    private boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public boolean isClosed() {
        return this.isClosing;
    }

    @Override
    public int getLockTimeout() {
        return this.lockTimeout;
    }

    @Override
    public void setLockTimeout(int seconds) {
        this.throwIfClient();
        this.stopper.checkCancelInProgress(null);
        this.lockTimeout = seconds;
    }

    @Override
    public int getLockLease() {
        return this.lockLease;
    }

    @Override
    public void setLockLease(int seconds) {
        this.throwIfClient();
        this.stopper.checkCancelInProgress(null);
        this.lockLease = seconds;
    }

    @Override
    public int getSearchTimeout() {
        return this.searchTimeout;
    }

    @Override
    public void setSearchTimeout(int seconds) {
        this.throwIfClient();
        this.stopper.checkCancelInProgress(null);
        this.searchTimeout = seconds;
    }

    @Override
    public int getMessageSyncInterval() {
        return HARegionQueue.getMessageSyncInterval();
    }

    @Override
    public void setMessageSyncInterval(int seconds) {
        this.throwIfClient();
        this.stopper.checkCancelInProgress(null);
        if (seconds < 0) {
            throw new IllegalArgumentException("The 'messageSyncInterval' property for cache cannot be negative");
        }
        HARegionQueue.setMessageSyncInterval(seconds);
    }

    @Override
    public InternalRegion getReinitializingRegion(String fullPath) {
        Future future = (Future)this.reinitializingRegions.get(fullPath);
        if (future == null) {
            return null;
        }
        try {
            InternalRegion region = (InternalRegion)future.get();
            region.waitOnInitialization();
            if (logger.isDebugEnabled()) {
                logger.debug("Returning manifested future for: {}", (Object)fullPath);
            }
            return region;
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            throw new Error("unexpected exception", e);
        }
        catch (CancellationException ignore) {
            logger.debug("future cancelled, returning null");
            return null;
        }
    }

    @Override
    public void regionReinitializing(String fullPath) {
        FutureResult<Stopper> old = this.reinitializingRegions.putIfAbsent(fullPath, new FutureResult<Stopper>(this.stopper));
        if (old != null) {
            throw new IllegalStateException(String.format("Found an existing reinitializing region named %s", fullPath));
        }
    }

    @Override
    public void regionReinitialized(Region<?, ?> region) {
        String regionName = region.getFullPath();
        FutureResult future = (FutureResult)this.reinitializingRegions.get(regionName);
        if (future == null) {
            throw new IllegalStateException(String.format("Could not find a reinitializing region named %s", regionName));
        }
        future.set((InternalRegion)region);
        this.unregisterReinitializingRegion(regionName);
    }

    @Override
    public void unregisterReinitializingRegion(String fullPath) {
        this.reinitializingRegions.remove(fullPath);
    }

    @Override
    public boolean isCopyOnRead() {
        return this.copyOnRead;
    }

    @Override
    public void setCopyOnRead(boolean copyOnRead) {
        this.copyOnRead = copyOnRead;
    }

    @Override
    public boolean getCopyOnRead() {
        return this.copyOnRead;
    }

    @Override
    public boolean removeRoot(InternalRegion rootRgn) {
        String regionName = rootRgn.getName();
        return this.rootRegions.remove(regionName, rootRgn);
    }

    static String[] parsePath(String path) {
        GemFireCacheImpl.validatePath(path);
        String[] result = new String[2];
        result[1] = "";
        int slashIndex = path.indexOf(47);
        if (slashIndex == 0) {
            path = path.substring(1);
            slashIndex = path.indexOf(47);
        }
        result[0] = path;
        if (slashIndex > 0) {
            result[0] = path.substring(0, slashIndex);
            result[1] = path.substring(slashIndex + 1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCacheLifecycleListener(CacheLifecycleListener listener) {
        Class<GemFireCacheImpl> clazz = GemFireCacheImpl.class;
        synchronized (GemFireCacheImpl.class) {
            cacheLifecycleListeners.add(listener);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeCacheLifecycleListener(CacheLifecycleListener listener) {
        Class<GemFireCacheImpl> clazz = GemFireCacheImpl.class;
        synchronized (GemFireCacheImpl.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cacheLifecycleListeners.remove(listener);
        }
    }

    @Override
    public void addRegionListener(RegionListener regionListener) {
        this.regionListeners.add(regionListener);
    }

    @Override
    public void removeRegionListener(RegionListener regionListener) {
        this.regionListeners.remove(regionListener);
    }

    @Override
    public Set<RegionListener> getRegionListeners() {
        return Collections.unmodifiableSet(this.regionListeners);
    }

    @Override
    public <T extends CacheService> T getService(Class<T> clazz) {
        return (T)((CacheService)clazz.cast(this.services.get(clazz)));
    }

    @Override
    public <T extends CacheService> Optional<T> getOptionalService(Class<T> clazz) {
        return Optional.ofNullable(this.getService(clazz));
    }

    @Override
    public Collection<CacheService> getServices() {
        return Collections.unmodifiableCollection(this.services.values());
    }

    @Override
    public CacheTransactionManager getCacheTransactionManager() {
        return this.transactionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SystemTimer getCCPTimer() {
        Object object = this.ccpTimerMutex;
        synchronized (object) {
            if (this.ccpTimer != null) {
                return this.ccpTimer;
            }
            this.ccpTimer = this.systemTimerFactory.apply(this.getDistributedSystem());
            if (this.isClosing) {
                this.ccpTimer.cancel();
            }
            return this.ccpTimer;
        }
    }

    @VisibleForTesting
    void setCCPTimer(SystemTimer ccpTimer) {
        this.ccpTimer = ccpTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeCCPTimer() {
        Object object = this.ccpTimerMutex;
        synchronized (object) {
            if (this.ccpTimer != null) {
                ++this.cancelCount;
                if (this.cancelCount == 1000) {
                    this.cancelCount = 0;
                    this.ccpTimer.timerPurge();
                }
            }
        }
    }

    @Override
    public ExpirationScheduler getExpirationScheduler() {
        return this.expirationScheduler;
    }

    @Override
    public TXManagerImpl getTXMgr() {
        return this.transactionManager;
    }

    @Override
    public Executor getEventThreadPool() {
        return this.eventThreadPool;
    }

    @Override
    public CacheServer addCacheServer() {
        this.throwIfClient();
        this.stopper.checkCancelInProgress(null);
        InternalCacheServer server = new ServerBuilder(this, this.securityService, StatisticsClockFactory.disabledClock()).createServer();
        this.allCacheServers.add(server);
        this.sendAddCacheServerProfileMessage();
        return server;
    }

    @Override
    @VisibleForTesting
    public boolean removeCacheServer(CacheServer cacheServer) {
        boolean removed = this.allCacheServers.remove(cacheServer);
        this.sendRemoveCacheServerProfileMessage();
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGatewaySender(GatewaySender sender) {
        this.throwIfClient();
        this.stopper.checkCancelInProgress(null);
        Object object = this.allGatewaySendersLock;
        synchronized (object) {
            HashSet<GatewaySender> newSenders;
            if (!this.allGatewaySenders.contains(sender)) {
                new UpdateAttributesProcessor((DistributionAdvisee)((Object)sender)).distribute(true);
                newSenders = new HashSet<GatewaySender>(this.allGatewaySenders.size() + 1);
                if (!this.allGatewaySenders.isEmpty()) {
                    newSenders.addAll(this.allGatewaySenders);
                }
            } else {
                throw new IllegalStateException(String.format("A GatewaySender with id %s is already defined in this cache.", sender.getId()));
            }
            newSenders.add(sender);
            this.allGatewaySenders = Collections.unmodifiableSet(newSenders);
        }
        Set<InternalRegion> applicationRegions = this.getApplicationRegions();
        for (InternalRegion region : applicationRegions) {
            Set<String> senders = region.getAllGatewaySenderIds();
            if (!senders.contains(sender.getId()) || sender.isParallel()) continue;
            region.senderCreated();
        }
        if (!sender.isParallel()) {
            Region dynamicMetaRegion = this.getRegion("__DynamicRegions");
            if (dynamicMetaRegion == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug(" The dynamic region is null. ");
                }
            } else {
                dynamicMetaRegion.getAttributesMutator().addGatewaySenderId(sender.getId());
            }
        }
        if (sender.getRemoteDSId() >= 0) {
            this.system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_CREATE, sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGatewaySender(GatewaySender sender) {
        this.throwIfClient();
        this.stopper.checkCancelInProgress(null);
        Object object = this.allGatewaySendersLock;
        synchronized (object) {
            if (this.allGatewaySenders.contains(sender)) {
                new UpdateAttributesProcessor((DistributionAdvisee)((Object)sender), true).distribute(true);
                HashSet<GatewaySender> newSenders = new HashSet<GatewaySender>(this.allGatewaySenders.size() - 1);
                if (!this.allGatewaySenders.isEmpty()) {
                    newSenders.addAll(this.allGatewaySenders);
                }
                newSenders.remove(sender);
                this.allGatewaySenders = Collections.unmodifiableSet(newSenders);
            }
        }
        if (sender.getRemoteDSId() >= 0) {
            this.system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_REMOVE, sender);
        }
    }

    @Override
    public InternalCacheServer addGatewayReceiverServer(GatewayReceiver receiver) {
        this.throwIfClient();
        this.stopper.checkCancelInProgress(null);
        Objects.requireNonNull(receiver, "GatewayReceiver must be supplied to add a server endpoint.");
        Objects.requireNonNull(this.gatewayReceiver.get(), "GatewayReceiver must be added before adding a server endpoint.");
        InternalCacheServer receiverServer = new ServerBuilder(this, this.securityService, StatisticsClockFactory.disabledClock()).forGatewayReceiver(receiver).createServer();
        this.gatewayReceiverServer.set(receiverServer);
        this.sendAddCacheServerProfileMessage();
        return receiverServer;
    }

    @Override
    public boolean removeGatewayReceiverServer(InternalCacheServer receiverServer) {
        boolean removed = this.gatewayReceiverServer.compareAndSet(receiverServer, null);
        this.sendRemoveCacheServerProfileMessage();
        return removed;
    }

    @Override
    public void addGatewayReceiver(GatewayReceiver receiver) {
        this.throwIfClient();
        this.stopper.checkCancelInProgress(null);
        Objects.requireNonNull(receiver, "GatewayReceiver must be supplied.");
        this.gatewayReceiver.set(receiver);
    }

    @Override
    public void removeGatewayReceiver(GatewayReceiver receiver) {
        this.throwIfClient();
        this.stopper.checkCancelInProgress(null);
        this.gatewayReceiver.set(null);
    }

    @Override
    public void addAsyncEventQueue(AsyncEventQueueImpl asyncQueue) {
        this.allAsyncEventQueues.add(asyncQueue);
        if (!asyncQueue.isMetaQueue()) {
            this.allVisibleAsyncEventQueues.add(asyncQueue);
        }
        this.system.handleResourceEvent(ResourceEvent.ASYNCEVENTQUEUE_CREATE, asyncQueue);
    }

    @Override
    public Set<GatewaySender> getGatewaySenders() {
        HashSet<GatewaySender> senders = new HashSet<GatewaySender>();
        for (GatewaySender sender : this.allGatewaySenders) {
            if (((AbstractGatewaySender)sender).isForInternalUse()) continue;
            senders.add(sender);
        }
        return senders;
    }

    @Override
    public Set<GatewaySender> getAllGatewaySenders() {
        return this.allGatewaySenders;
    }

    @Override
    public GatewaySender getGatewaySender(String id) {
        for (GatewaySender sender : this.allGatewaySenders) {
            if (!sender.getId().equals(id)) continue;
            return sender;
        }
        return null;
    }

    @Override
    public Set<GatewayReceiver> getGatewayReceivers() {
        GatewayReceiver receiver = this.gatewayReceiver.get();
        if (receiver == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(receiver);
    }

    @Override
    public Set<AsyncEventQueue> getAsyncEventQueues() {
        return this.getAsyncEventQueues(true);
    }

    @Override
    @VisibleForTesting
    public Set<AsyncEventQueue> getAsyncEventQueues(boolean visibleOnly) {
        return visibleOnly ? this.allVisibleAsyncEventQueues : this.allAsyncEventQueues;
    }

    @Override
    public AsyncEventQueue getAsyncEventQueue(String id) {
        for (AsyncEventQueue asyncEventQueue : this.allAsyncEventQueues) {
            if (!asyncEventQueue.getId().equals(id)) continue;
            return asyncEventQueue;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAsyncEventQueue(AsyncEventQueue asyncQueue) {
        this.throwIfClient();
        if (asyncQueue instanceof InternalAsyncEventQueue) {
            this.removeGatewaySender(((InternalAsyncEventQueue)asyncQueue).getSender());
        }
        Object object = this.allGatewaySendersLock;
        synchronized (object) {
            this.allAsyncEventQueues.remove(asyncQueue);
            this.allVisibleAsyncEventQueues.remove(asyncQueue);
        }
        this.system.handleResourceEvent(ResourceEvent.ASYNCEVENTQUEUE_REMOVE, asyncQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayConflictResolver getGatewayConflictResolver() {
        Object object = this.allGatewayHubsLock;
        synchronized (object) {
            return this.gatewayConflictResolver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGatewayConflictResolver(GatewayConflictResolver resolver) {
        Object object = this.allGatewayHubsLock;
        synchronized (object) {
            this.gatewayConflictResolver = resolver;
        }
    }

    @Override
    public List<CacheServer> getCacheServers() {
        return this.unmodifiableAllCacheServers;
    }

    @Override
    public List<InternalCacheServer> getCacheServersAndGatewayReceiver() {
        ArrayList<InternalCacheServer> allServers = new ArrayList<InternalCacheServer>(this.allCacheServers);
        InternalCacheServer receiverServer = this.gatewayReceiverServer.get();
        if (receiverServer != null) {
            allServers.add(receiverServer);
        }
        return Collections.unmodifiableList(allServers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitionedRegion(PartitionedRegion region) {
        Set<PartitionedRegion> set = this.partitionedRegions;
        synchronized (set) {
            if (region.isDestroyed()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("GemFireCache#addPartitionedRegion did not add destroyed {}", (Object)region);
                }
                return;
            }
            if (this.partitionedRegions.add(region)) {
                this.getCachePerfStats().incPartitionedRegions(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PartitionedRegion> getPartitionedRegions() {
        Set<PartitionedRegion> set = this.partitionedRegions;
        synchronized (set) {
            return new HashSet<PartitionedRegion>(this.partitionedRegions);
        }
    }

    private Map<String, Map<String, PartitionedRegion>> getPRTrees() {
        Map<String, PartitionedRegion> prMap = this.getPartitionedRegionMap();
        boolean hasColocatedRegion = false;
        for (PartitionedRegion pr : prMap.values()) {
            List<PartitionedRegion> childList = ColocationHelper.getColocatedChildRegions(pr);
            if (childList == null || childList.isEmpty()) continue;
            hasColocatedRegion = true;
            break;
        }
        TreeMap<String, Map<String, PartitionedRegion>> prTrees = new TreeMap<String, Map<String, PartitionedRegion>>();
        if (hasColocatedRegion) {
            Map<String, PartitionedRegion> orderedPrMap = this.orderByColocation(prMap);
            prTrees.put("ROOT", orderedPrMap);
        } else {
            for (PartitionedRegion pr : prMap.values()) {
                String rootName = pr.getRoot().getName();
                Map prSubMap = prTrees.computeIfAbsent(rootName, k -> new TreeMap());
                prSubMap.put(pr.getFullPath(), pr);
            }
        }
        return prTrees;
    }

    private Map<String, PartitionedRegion> getPartitionedRegionMap() {
        TreeMap<String, PartitionedRegion> prMap = new TreeMap<String, PartitionedRegion>();
        for (Map.Entry entry : this.pathToRegion.entrySet()) {
            String regionName = (String)entry.getKey();
            InternalRegion region = (InternalRegion)entry.getValue();
            if (!(region instanceof PartitionedRegion)) continue;
            try {
                Region pr = this.getRegion(regionName);
                if (!(pr instanceof PartitionedRegion)) continue;
                prMap.put(regionName, (PartitionedRegion)pr);
            }
            catch (CancelException cancelException) {}
        }
        return prMap;
    }

    private Map<String, PartitionedRegion> orderByColocation(Map<String, PartitionedRegion> prMap) {
        LinkedHashMap<String, PartitionedRegion> orderedPrMap = new LinkedHashMap<String, PartitionedRegion>();
        for (PartitionedRegion pr : prMap.values()) {
            this.addColocatedChildRecursively(orderedPrMap, pr);
        }
        return orderedPrMap;
    }

    private void addColocatedChildRecursively(Map<String, PartitionedRegion> prMap, PartitionedRegion pr) {
        for (PartitionedRegion colocatedRegion : ColocationHelper.getColocatedChildRegions(pr)) {
            this.addColocatedChildRecursively(prMap, colocatedRegion);
        }
        prMap.put(pr.getFullPath(), pr);
    }

    @Override
    public boolean requiresNotificationFromPR(PartitionedRegion region) {
        InternalCacheServer receiverServer;
        boolean hasSerialSenders = this.hasSerialSenders(region);
        if (!hasSerialSenders) {
            for (InternalCacheServer server : this.allCacheServers) {
                if (server.getNotifyBySubscription()) continue;
                hasSerialSenders = true;
                break;
            }
        }
        if (!hasSerialSenders && (receiverServer = this.gatewayReceiverServer.get()) != null && !receiverServer.getNotifyBySubscription()) {
            hasSerialSenders = true;
        }
        return hasSerialSenders;
    }

    private boolean hasSerialSenders(InternalRegion region) {
        boolean hasSenders = false;
        Set<String> senders = region.getAllGatewaySenderIds();
        for (String sender : senders) {
            GatewaySender gatewaySender = this.getGatewaySender(sender);
            if (gatewaySender == null || gatewaySender.isParallel()) continue;
            hasSenders = true;
            break;
        }
        return hasSenders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePartitionedRegion(PartitionedRegion region) {
        Set<PartitionedRegion> set = this.partitionedRegions;
        synchronized (set) {
            if (this.partitionedRegions.remove(region)) {
                this.getCachePerfStats().incPartitionedRegions(-1);
            }
        }
    }

    @Override
    public void setIsServer(boolean isServer) {
        this.throwIfClient();
        this.stopper.checkCancelInProgress(null);
        this.isServer = isServer;
    }

    @Override
    public boolean isServer() {
        if (this.isClient()) {
            return false;
        }
        this.stopper.checkCancelInProgress(null);
        return this.isServer || !this.allCacheServers.isEmpty();
    }

    @Override
    public QueryService getQueryService() {
        if (!this.isClient()) {
            return this.getLocalQueryService();
        }
        Pool defaultPool = this.getDefaultPool();
        if (defaultPool == null) {
            throw new IllegalStateException("Client cache does not have a default pool. Use getQueryService(String poolName) instead.");
        }
        return defaultPool.getQueryService();
    }

    @Override
    public InternalQueryService getInternalQueryService() {
        return (InternalQueryService)this.getQueryService();
    }

    @Override
    public JSONFormatter getJsonFormatter() {
        return new JSONFormatter();
    }

    @Override
    public QueryService getLocalQueryService() {
        return new DefaultQueryService(this);
    }

    @Override
    public Context getJNDIContext() {
        return JNDIInvoker.getJNDIContext();
    }

    @Override
    public TransactionManager getJTATransactionManager() {
        return JNDIInvoker.getTransactionManager();
    }

    @Override
    public FilterProfile getFilterProfile(String regionName) {
        InternalRegion r = (InternalRegion)this.getRegion(regionName, true);
        if (r != null) {
            return r.getFilterProfile();
        }
        return null;
    }

    @Override
    public <K, V> RegionAttributes<K, V> getRegionAttributes(String id) {
        return (RegionAttributes)UncheckedUtils.uncheckedCast(this.namedRegionAttributes.get(id));
    }

    @Override
    public <K, V> void setRegionAttributes(String id, RegionAttributes<K, V> attrs) {
        if (attrs == null) {
            this.namedRegionAttributes.remove(id);
        } else {
            this.namedRegionAttributes.put(id, attrs);
        }
    }

    @Override
    public <K, V> Map<String, RegionAttributes<K, V>> listRegionAttributes() {
        return Collections.unmodifiableMap((Map)UncheckedUtils.uncheckedCast(this.namedRegionAttributes));
    }

    @Override
    public void loadCacheXml(InputStream is) throws TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        GemFireCacheImpl oldValue = xmlCache.get();
        xmlCache.set(this);
        BufferedReader reader = null;
        StringWriter stringWriter = null;
        OutputStreamWriter writer = null;
        try {
            CacheXmlParser xml;
            if (XML_PARAMETERIZATION_ENABLED) {
                int numChars;
                reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.ISO_8859_1));
                stringWriter = new StringWriter();
                char[] buffer = new char[1024];
                while ((numChars = reader.read(buffer)) != -1) {
                    ((Writer)stringWriter).write(buffer, 0, numChars);
                }
                String replacedXmlString = this.resolver.processUnresolvableString(((Object)stringWriter).toString());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                writer = new OutputStreamWriter((OutputStream)baos, StandardCharsets.ISO_8859_1);
                writer.write(replacedXmlString);
                writer.flush();
                xml = CacheXmlParser.parse(new ByteArrayInputStream(baos.toByteArray()));
            } else {
                xml = CacheXmlParser.parse(is);
            }
            xml.create(this);
            xmlCache.set(oldValue);
        }
        catch (IOException e) {
            try {
                throw new CacheXmlException("Input Stream could not be read for system property substitutions.", e);
            }
            catch (Throwable throwable) {
                xmlCache.set(oldValue);
                GemFireCacheImpl.closeQuietly(reader);
                GemFireCacheImpl.closeQuietly(stringWriter);
                GemFireCacheImpl.closeQuietly(writer);
                throw throwable;
            }
        }
        GemFireCacheImpl.closeQuietly(reader);
        GemFireCacheImpl.closeQuietly(stringWriter);
        GemFireCacheImpl.closeQuietly(writer);
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void readyForEvents() {
        if (this.isClient() && Objects.nonNull(this.system) && Objects.nonNull(this.system.getConfig()) && !Objects.equals("", Objects.toString(this.system.getConfig().getDurableClientId(), "")) && Objects.isNull(this.defaultPool)) {
            this.determineDefaultPool();
        }
        PoolManagerImpl.readyForEvents(this.system, false);
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.getInternalResourceManager(true);
    }

    @Override
    public InternalResourceManager getInternalResourceManager() {
        return this.getInternalResourceManager(true);
    }

    @Override
    public InternalResourceManager getInternalResourceManager(boolean checkCancellationInProgress) {
        if (checkCancellationInProgress) {
            this.stopper.checkCancelInProgress(null);
        }
        return this.resourceManager;
    }

    @Override
    public void setBackupFiles(List<File> backups) {
        this.backupFiles = backups;
    }

    @Override
    public List<File> getBackupFiles() {
        return Collections.unmodifiableList(this.backupFiles);
    }

    @Override
    public BackupService getBackupService() {
        return this.backupService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerInterestCompleted() {
        if (this.isClosing) {
            return;
        }
        int numInProgress = this.registerInterestsInProgress.decrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("registerInterestCompleted: new value = {}", (Object)numInProgress);
        }
        if (numInProgress == 0) {
            List<SimpleWaiter> list = this.riWaiters;
            synchronized (list) {
                numInProgress = this.registerInterestsInProgress.get();
                if (numInProgress == 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("registerInterestCompleted: Signalling end of register-interest");
                    }
                    for (SimpleWaiter sw : this.riWaiters) {
                        sw.doNotify();
                    }
                    this.riWaiters.clear();
                }
            }
        }
    }

    @Override
    public void registerInterestStarted() {
        int newVal = this.registerInterestsInProgress.incrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("registerInterestsStarted: new count = {}", (Object)newVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForRegisterInterestsInProgress() {
        this.getCancelCriterion().checkCancelInProgress(null);
        int count = this.registerInterestsInProgress.get();
        if (count > 0) {
            SimpleWaiter simpleWaiter = null;
            List<SimpleWaiter> list = this.riWaiters;
            synchronized (list) {
                count = this.registerInterestsInProgress.get();
                if (count > 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("waitForRegisterInterestsInProgress: count ={}", (Object)count);
                    }
                    simpleWaiter = new SimpleWaiter();
                    this.riWaiters.add(simpleWaiter);
                }
            }
            if (simpleWaiter != null) {
                simpleWaiter.doWait();
            }
        }
    }

    @Override
    public void setQueryMonitorRequiredForResourceManager(boolean required) {
        queryMonitorRequiredForResourceManager = required;
    }

    @Override
    public boolean isQueryMonitorDisabledForLowMemory() {
        return this.queryMonitorDisabledForLowMem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryMonitor getQueryMonitor() {
        boolean monitorRequired;
        boolean bl = monitorRequired = !this.queryMonitorDisabledForLowMem && queryMonitorRequiredForResourceManager;
        if (MAX_QUERY_EXECUTION_TIME <= 0 && !monitorRequired) {
            return null;
        }
        QueryMonitor tempQueryMonitor = this.queryMonitor;
        if (tempQueryMonitor == null) {
            Object object = this.queryMonitorLock;
            synchronized (object) {
                if (tempQueryMonitor == null) {
                    int maxTime = MAX_QUERY_EXECUTION_TIME;
                    if (monitorRequired && maxTime < 0) {
                        maxTime = 18000000;
                    }
                    tempQueryMonitor = new QueryMonitor((ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, runnable -> new LoggingThread("QueryMonitor Thread", runnable)), this, maxTime);
                    if (logger.isDebugEnabled()) {
                        logger.debug("QueryMonitor thread started.");
                    }
                    this.queryMonitor = tempQueryMonitor;
                }
            }
        }
        return tempQueryMonitor;
    }

    private void sendAddCacheServerProfileMessage() {
        Set<InternalDistributedMember> otherMembers = this.dm.getOtherDistributionManagerIds();
        AddCacheServerProfileMessage message = new AddCacheServerProfileMessage();
        message.operateOnLocalCache(this);
        if (!otherMembers.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Sending add cache server profile message to other members.");
            }
            ReplyProcessor21 replyProcessor = new ReplyProcessor21(this.dm, otherMembers);
            message.setRecipients(otherMembers);
            message.processorId = replyProcessor.getProcessorId();
            this.dm.putOutgoing(message);
            try {
                replyProcessor.waitForReplies();
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void sendRemoveCacheServerProfileMessage() {
        Set<InternalDistributedMember> otherMembers = this.dm.getOtherDistributionManagerIds();
        RemoveCacheServerProfileMessage message = new RemoveCacheServerProfileMessage();
        message.operateOnLocalCache(this);
        otherMembers.removeIf(member -> Version.GEODE_1_5_0.compareTo(member.getVersionOrdinalObject()) > 0);
        if (!otherMembers.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Sending remove cache server profile message to other members.");
            }
            ReplyProcessor21 replyProcessor = new ReplyProcessor21(this.dm, otherMembers);
            message.setRecipients(otherMembers);
            message.processorId = replyProcessor.getProcessorId();
            this.dm.putOutgoing(message);
            try {
                replyProcessor.waitForReplies();
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public TXManagerImpl getTxManager() {
        return this.transactionManager;
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(RegionShortcut shortcut) {
        this.throwIfClient();
        return new InternalRegionFactory((InternalCache)this, shortcut);
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory() {
        this.throwIfClient();
        return new InternalRegionFactory(this);
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(String regionAttributesId) {
        this.throwIfClient();
        return new InternalRegionFactory((InternalCache)this, regionAttributesId);
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(RegionAttributes<K, V> regionAttributes) {
        this.throwIfClient();
        return new InternalRegionFactory<K, V>((InternalCache)this, regionAttributes);
    }

    @Override
    public <K, V> ClientRegionFactory<K, V> createClientRegionFactory(ClientRegionShortcut shortcut) {
        return new ClientRegionFactoryImpl((InternalClientCache)this, shortcut);
    }

    @Override
    public <K, V> ClientRegionFactory<K, V> createClientRegionFactory(String regionAttributesId) {
        return new ClientRegionFactoryImpl((InternalClientCache)this, regionAttributesId);
    }

    @Override
    public QueryService getQueryService(String poolName) {
        Pool pool = PoolManager.find(poolName);
        if (pool == null) {
            throw new IllegalStateException("Could not find a pool named " + poolName);
        }
        return pool.getQueryService();
    }

    @Override
    public RegionService createAuthenticatedView(Properties userSecurityProperties) {
        Pool pool = this.getDefaultPool();
        if (pool == null) {
            throw new IllegalStateException("This cache does not have a default pool");
        }
        return GemFireCacheImpl.createAuthenticatedCacheView(pool, userSecurityProperties);
    }

    @Override
    public RegionService createAuthenticatedView(Properties userSecurityProperties, String poolName) {
        Pool pool = PoolManager.find(poolName);
        if (pool == null) {
            throw new IllegalStateException("Pool " + poolName + " does not exist");
        }
        return GemFireCacheImpl.createAuthenticatedCacheView(pool, userSecurityProperties);
    }

    private static RegionService createAuthenticatedCacheView(Pool pool, Properties properties) {
        if (pool.getMultiuserAuthentication()) {
            return ((PoolImpl)pool).createAuthenticatedCacheView(properties);
        }
        throw new IllegalStateException("The pool " + pool.getName() + " did not have multiuser-authentication set to true");
    }

    public static void initializeRegionShortcuts(Cache cache) {
        block25: for (RegionShortcut shortcut : RegionShortcut.values()) {
            switch (shortcut) {
                case PARTITION: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    af.setPartitionAttributes(paf.create());
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case PARTITION_REDUNDANT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(1);
                    af.setPartitionAttributes(paf.create());
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case PARTITION_PERSISTENT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    af.setPartitionAttributes(paf.create());
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case PARTITION_REDUNDANT_PERSISTENT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(1);
                    af.setPartitionAttributes(paf.create());
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case PARTITION_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    af.setPartitionAttributes(paf.create());
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case PARTITION_REDUNDANT_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(1);
                    af.setPartitionAttributes(paf.create());
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case PARTITION_PERSISTENT_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    af.setPartitionAttributes(paf.create());
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case PARTITION_REDUNDANT_PERSISTENT_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(1);
                    af.setPartitionAttributes(paf.create());
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case PARTITION_HEAP_LRU: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    af.setPartitionAttributes(paf.create());
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes());
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case PARTITION_REDUNDANT_HEAP_LRU: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(1);
                    af.setPartitionAttributes(paf.create());
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes());
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case REPLICATE: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.REPLICATE);
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case REPLICATE_PERSISTENT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case REPLICATE_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.REPLICATE);
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case REPLICATE_PERSISTENT_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case REPLICATE_HEAP_LRU: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.REPLICATE);
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes());
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case LOCAL: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setScope(Scope.LOCAL);
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case LOCAL_PERSISTENT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    af.setScope(Scope.LOCAL);
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case LOCAL_HEAP_LRU: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setScope(Scope.LOCAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes());
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case LOCAL_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setScope(Scope.LOCAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case LOCAL_PERSISTENT_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    af.setScope(Scope.LOCAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case PARTITION_PROXY: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setLocalMaxMemory(0);
                    af.setPartitionAttributes(paf.create());
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case PARTITION_PROXY_REDUNDANT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setLocalMaxMemory(0);
                    paf.setRedundantCopies(1);
                    af.setPartitionAttributes(paf.create());
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                case REPLICATE_PROXY: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.EMPTY);
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block25;
                }
                default: {
                    throw new IllegalStateException("unhandled enum " + (Object)((Object)shortcut));
                }
            }
        }
    }

    public static void initializeClientRegionShortcuts(Cache cache) {
        block11: for (ClientRegionShortcut shortcut : ClientRegionShortcut.values()) {
            switch (shortcut) {
                case LOCAL: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block11;
                }
                case LOCAL_PERSISTENT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block11;
                }
                case LOCAL_HEAP_LRU: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes());
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block11;
                }
                case LOCAL_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block11;
                }
                case LOCAL_PERSISTENT_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    cache.setRegionAttributes(shortcut.toString(), af.create());
                    continue block11;
                }
                case PROXY: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.EMPTY);
                    UserSpecifiedRegionAttributes attributes = (UserSpecifiedRegionAttributes)af.create();
                    attributes.requiresPoolName = true;
                    cache.setRegionAttributes(shortcut.toString(), attributes);
                    continue block11;
                }
                case CACHING_PROXY: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    UserSpecifiedRegionAttributes attributes = (UserSpecifiedRegionAttributes)af.create();
                    attributes.requiresPoolName = true;
                    cache.setRegionAttributes(shortcut.toString(), attributes);
                    continue block11;
                }
                case CACHING_PROXY_HEAP_LRU: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes());
                    UserSpecifiedRegionAttributes attributes = (UserSpecifiedRegionAttributes)af.create();
                    attributes.requiresPoolName = true;
                    cache.setRegionAttributes(shortcut.toString(), attributes);
                    continue block11;
                }
                case CACHING_PROXY_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    UserSpecifiedRegionAttributes attributes = (UserSpecifiedRegionAttributes)af.create();
                    attributes.requiresPoolName = true;
                    cache.setRegionAttributes(shortcut.toString(), attributes);
                    continue block11;
                }
                default: {
                    throw new IllegalStateException("unhandled enum " + (Object)((Object)shortcut));
                }
            }
        }
    }

    @Override
    public void beginDestroy(String path, DistributedRegion region) {
        this.regionsInDestroy.putIfAbsent(path, region);
    }

    @Override
    public void endDestroy(String path, DistributedRegion region) {
        this.regionsInDestroy.remove(path, region);
    }

    @Override
    public DistributedRegion getRegionInDestroy(String path) {
        return (DistributedRegion)this.regionsInDestroy.get(path);
    }

    @Override
    public TombstoneService getTombstoneService() {
        return this.tombstoneService;
    }

    @Override
    public TypeRegistry getPdxRegistry() {
        return this.pdxRegistry;
    }

    @Override
    public boolean getPdxReadSerialized() {
        return this.cacheConfig.pdxReadSerialized;
    }

    @Override
    public PdxSerializer getPdxSerializer() {
        return this.cacheConfig.pdxSerializer;
    }

    @Override
    public String getPdxDiskStore() {
        return this.cacheConfig.pdxDiskStore;
    }

    @Override
    public boolean getPdxPersistent() {
        return this.cacheConfig.pdxPersistent;
    }

    @Override
    public boolean getPdxIgnoreUnreadFields() {
        return this.cacheConfig.pdxIgnoreUnreadFields;
    }

    @Override
    public boolean getPdxReadSerializedByAnyGemFireServices() {
        TypeRegistry pdxRegistry = this.getPdxRegistry();
        boolean pdxReadSerializedOverridden = false;
        if (pdxRegistry != null) {
            pdxReadSerializedOverridden = pdxRegistry.getPdxReadSerializedOverride();
        }
        return (this.getPdxReadSerialized() || pdxReadSerializedOverridden) && PdxInstanceImpl.getPdxReadSerialized();
    }

    @Override
    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    @Override
    public DistributionManager getDistributionManager() {
        return this.dm;
    }

    @Override
    public GatewaySenderFactory createGatewaySenderFactory() {
        return WANServiceProvider.createGatewaySenderFactory(this);
    }

    @Override
    public GatewayReceiverFactory createGatewayReceiverFactory() {
        return WANServiceProvider.createGatewayReceiverFactory(this);
    }

    @Override
    public AsyncEventQueueFactory createAsyncEventQueueFactory() {
        return new AsyncEventQueueFactoryImpl(this);
    }

    @Override
    public DistributionAdvisor getDistributionAdvisor() {
        return this.getResourceAdvisor();
    }

    @Override
    public ResourceAdvisor getResourceAdvisor() {
        return this.resourceAdvisor;
    }

    @Override
    public DistributionAdvisor.Profile getProfile() {
        return this.resourceAdvisor.createProfile();
    }

    @Override
    public DistributionAdvisee getParentAdvisee() {
        return null;
    }

    @Override
    public InternalDistributedSystem getSystem() {
        return this.system;
    }

    @Override
    public String getFullPath() {
        return "ResourceManager";
    }

    @Override
    public void fillInProfile(DistributionAdvisor.Profile profile) {
        this.resourceManager.fillInProfile(profile);
    }

    @Override
    public int getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public TXEntryStateFactory getTXEntryStateFactory() {
        return this.txEntryStateFactory;
    }

    @VisibleForTesting
    public void setPdxSerializer(PdxSerializer serializer) {
        this.cacheConfig.setPdxSerializer(serializer);
        this.basicSetPdxSerializer(serializer);
    }

    private void basicSetPdxSerializer(PdxSerializer serializer) {
        AutoSerializableManager autoSerializableManager;
        this.typeRegistrySetPdxSerializer.accept(serializer);
        if (serializer instanceof ReflectionBasedAutoSerializer && (autoSerializableManager = (AutoSerializableManager)((ReflectionBasedAutoSerializer)serializer).getManager()) != null) {
            autoSerializableManager.setRegionService(this);
        }
    }

    @Override
    public void setReadSerializedForCurrentThread(boolean value) {
        PdxInstanceImpl.setPdxReadSerialized(value);
        this.setPdxReadSerializedOverride(value);
    }

    @Override
    @Deprecated
    @VisibleForTesting
    public void setReadSerializedForTest(boolean value) {
        this.cacheConfig.setPdxReadSerialized(value);
    }

    @Override
    public void setDeclarativeCacheConfig(CacheConfig cacheConfig) {
        this.cacheConfig.setDeclarativeConfig(cacheConfig);
        this.basicSetPdxSerializer(this.cacheConfig.getPdxSerializer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDeclarableProperties(Map<Declarable, Properties> mapOfNewDeclarableProps) {
        Map<Declarable, Properties> map = this.declarablePropertiesMap;
        synchronized (map) {
            for (Map.Entry<Declarable, Properties> newEntry : mapOfNewDeclarableProps.entrySet()) {
                Class<?> clazz = newEntry.getKey().getClass();
                Declarable matchingDeclarable = null;
                for (Map.Entry<Declarable, Properties> oldEntry : this.declarablePropertiesMap.entrySet()) {
                    BiPredicate<Declarable, Declarable> isKeyIdentifiableAndSameIdPredicate = (oldKey, newKey) -> newKey instanceof Identifiable && ((Identifiable)oldKey).getId().equals(((Identifiable)newKey).getId());
                    Supplier<Boolean> isKeyClassSame = () -> clazz.getName().equals(((Declarable)oldEntry.getKey()).getClass().getName());
                    Supplier<Boolean> isValueEqual = () -> ((Properties)newEntry.getValue()).equals(oldEntry.getValue());
                    Supplier<Boolean> isKeyIdentifiableAndSameId = () -> isKeyIdentifiableAndSameIdPredicate.test((Declarable)oldEntry.getKey(), (Declarable)newEntry.getKey());
                    if (!isKeyClassSame.get().booleanValue() || !isValueEqual.get().booleanValue() && !isKeyIdentifiableAndSameId.get().booleanValue()) continue;
                    matchingDeclarable = oldEntry.getKey();
                    break;
                }
                if (matchingDeclarable != null) {
                    this.declarablePropertiesMap.remove(matchingDeclarable);
                }
                this.declarablePropertiesMap.put(newEntry.getKey(), newEntry.getValue());
            }
        }
    }

    @Override
    public Declarable getInitializer() {
        return this.initializer;
    }

    @Override
    public Properties getInitializerProps() {
        return this.initializerProps;
    }

    @Override
    public void setInitializer(Declarable initializer, Properties initializerProps) {
        this.initializer = initializer;
        this.initializerProps = initializerProps;
    }

    @Override
    public PdxInstanceFactory createPdxInstanceFactory(String className) {
        return PdxInstanceFactoryImpl.newCreator(className, true, this);
    }

    @Override
    public PdxInstanceFactory createPdxInstanceFactory(String className, boolean expectDomainClass) {
        return PdxInstanceFactoryImpl.newCreator(className, expectDomainClass, this);
    }

    @Override
    public PdxInstance createPdxEnum(String className, String enumName, int enumOrdinal) {
        return PdxInstanceFactoryImpl.createPdxEnum(className, enumName, enumOrdinal, this);
    }

    @Override
    public JmxManagerAdvisor getJmxManagerAdvisor() {
        return this.jmxAdvisor;
    }

    @Override
    public CacheSnapshotService getSnapshotService() {
        return new CacheSnapshotServiceImpl(this);
    }

    private void startColocatedJmxManagerLocator() {
        InternalLocator loc = InternalLocator.getLocator();
        if (loc != null) {
            loc.startJmxManagerLocationService(this);
        }
    }

    @Override
    public MemoryAllocator getOffHeapStore() {
        return this.getSystem().getOffHeapStore();
    }

    @Override
    public DiskStoreMonitor getDiskStoreMonitor() {
        return this.diskMonitor;
    }

    @Override
    public ExtensionPoint<Cache> getExtensionPoint() {
        return this.extensionPoint;
    }

    @Override
    public CqService getCqService() {
        return this.cqService;
    }

    private void addRegionEntrySynchronizationListener(RegionEntrySynchronizationListener listener) {
        this.synchronizationListeners.add(listener);
    }

    @Override
    public void invokeRegionEntrySynchronizationListenersAfterSynchronization(InternalDistributedMember sender, InternalRegion region, List<InitialImageOperation.Entry> entriesToSynchronize) {
        for (RegionEntrySynchronizationListener listener : this.synchronizationListeners) {
            try {
                listener.afterSynchronization(sender, region, entriesToSynchronize);
            }
            catch (Throwable t) {
                logger.warn(String.format("Caught the following exception attempting to synchronize events from member=%s; regionPath=%s; entriesToSynchronize=%s:", sender, region.getFullPath(), entriesToSynchronize), t);
            }
        }
    }

    @Override
    public Object convertPdxInstanceIfNeeded(Object obj, boolean preferCD) {
        Object result = obj;
        if (obj instanceof InternalPdxInstance) {
            InternalPdxInstance pdxInstance = (InternalPdxInstance)obj;
            if (preferCD) {
                try {
                    result = new PreferBytesCachedDeserializable(pdxInstance.toBytes());
                }
                catch (IOException iOException) {}
            } else if (!this.getPdxReadSerialized()) {
                result = pdxInstance.getObject();
            }
        }
        return result;
    }

    @Override
    public Boolean getPdxReadSerializedOverride() {
        TypeRegistry pdxRegistry = this.getPdxRegistry();
        if (pdxRegistry != null) {
            return pdxRegistry.getPdxReadSerializedOverride();
        }
        return false;
    }

    @Override
    public void setPdxReadSerializedOverride(boolean pdxReadSerialized) {
        TypeRegistry pdxRegistry = this.getPdxRegistry();
        if (pdxRegistry != null) {
            pdxRegistry.setPdxReadSerializedOverride(pdxReadSerialized);
        }
    }

    @Override
    public void registerPdxMetaData(Object instance) {
        try {
            byte[] blob = BlobHelper.serializeToBlob(instance);
            if (blob.length == 0 || blob[0] != DSCODE.PDX.toByte()) {
                throw new SerializationException("The instance is not PDX serializable");
            }
        }
        catch (IOException e) {
            throw new SerializationException("Serialization failed", e);
        }
    }

    private void throwIfClient() {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
    }

    @Override
    public InternalCacheForClientAccess getCacheForProcessingClientRequests() {
        return this.cacheForClients;
    }

    private ThreadsMonitoring getThreadMonitorObj() {
        if (this.dm != null) {
            return this.dm.getThreadMonitoring();
        }
        return null;
    }

    @Override
    public StatisticsClock getStatisticsClock() {
        return this.statisticsClock;
    }

    @VisibleForTesting
    void setDisconnectCause(Throwable disconnectCause) {
        this.disconnectCause = disconnectCause;
    }

    static {
        DELTAS_RECALCULATE_SIZE = Boolean.getBoolean("gemfire.DELTAS_RECALCULATE_SIZE");
        cacheLifecycleListeners = new CopyOnWriteArraySet<CacheLifecycleListener>();
        defaultDiskStoreName = DEFAULT_POOL_NAME;
        String propertyName = "sun.nio.ch.bugLevel";
        String value = System.getProperty(propertyName);
        if (value == null) {
            System.setProperty(propertyName, "");
        }
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface ReplyProcessor21Factory {
        public ReplyProcessor21 create(InternalDistributedSystem var1, Collection<InternalDistributedMember> var2);
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface HeapEvictorFactory {
        public HeapEvictor create(InternalCache var1, StatisticsClock var2);
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface TypeRegistryFactory {
        public TypeRegistry create(InternalCache var1, boolean var2);
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface CachePerfStatsFactory {
        public CachePerfStats create(StatisticsFactory var1, StatisticsClock var2);
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface InternalSecurityServiceFactory {
        public SecurityService create(Properties var1, CacheConfig var2);
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface TXManagerImplFactory {
        public TXManagerImpl create(CachePerfStats var1, InternalCache var2, StatisticsClock var3);
    }

    private class SimpleWaiter {
        private boolean notified;

        private SimpleWaiter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void doWait() {
            SimpleWaiter simpleWaiter = this;
            synchronized (simpleWaiter) {
                while (!this.notified) {
                    GemFireCacheImpl.this.getCancelCriterion().checkCancelInProgress(null);
                    boolean interrupted = Thread.interrupted();
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException ignore) {
                        interrupted = true;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doNotify() {
            SimpleWaiter simpleWaiter = this;
            synchronized (simpleWaiter) {
                this.notified = true;
                this.notifyAll();
            }
        }
    }

    private class Stopper
    extends CancelCriterion {
        private Stopper() {
        }

        @Override
        public String cancelInProgress() {
            String reason = GemFireCacheImpl.this.getDistributedSystem().getCancelCriterion().cancelInProgress();
            if (reason != null) {
                return reason;
            }
            if (GemFireCacheImpl.this.disconnectCause != null) {
                return GemFireCacheImpl.this.disconnectCause.getMessage();
            }
            if (GemFireCacheImpl.this.isClosing) {
                return "The cache is closed.";
            }
            return null;
        }

        @Override
        public RuntimeException generateCancelledException(Throwable throwable) {
            String reason = this.cancelInProgress();
            if (reason == null) {
                return null;
            }
            RuntimeException result = GemFireCacheImpl.this.getDistributedSystem().getCancelCriterion().generateCancelledException(throwable);
            if (result != null) {
                return result;
            }
            if (GemFireCacheImpl.this.disconnectCause == null) {
                return new CacheClosedException(reason, throwable);
            }
            if (throwable == null) {
                return new CacheClosedException(reason, GemFireCacheImpl.this.disconnectCause);
            }
            try {
                ThrowableUtils.setRootCause(throwable, GemFireCacheImpl.this.disconnectCause);
                return new CacheClosedException(reason, throwable);
            }
            catch (IllegalStateException ignore) {
                return new CacheClosedException(reason, GemFireCacheImpl.this.disconnectCause);
            }
        }
    }
}

