/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.internal.cache.execute.CachedResultCollector;

public class ResultCollectorHolder {
    private volatile boolean resultCollected = false;
    private FunctionException exceptionThrown = null;
    private Object objectReturned = null;
    private CachedResultCollector rc;

    public ResultCollectorHolder(CachedResultCollector rc) {
        this.rc = rc;
    }

    public Object getResult() throws FunctionException {
        if (this.resultCollected) {
            if (this.exceptionThrown != null) {
                throw this.exceptionThrown;
            }
            return this.objectReturned;
        }
        this.resultCollected = true;
        try {
            this.objectReturned = this.rc.getResultInternal();
            return this.objectReturned;
        }
        catch (FunctionException e) {
            this.exceptionThrown = e;
            throw e;
        }
    }

    public Object getResult(long timeout, TimeUnit unit) throws FunctionException, InterruptedException {
        if (this.resultCollected) {
            if (this.exceptionThrown != null) {
                throw this.exceptionThrown;
            }
            return this.objectReturned;
        }
        this.resultCollected = true;
        try {
            this.objectReturned = this.rc.getResultInternal(timeout, unit);
            return this.objectReturned;
        }
        catch (FunctionException e) {
            this.exceptionThrown = e;
            throw e;
        }
    }
}

