/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.statistics.StatisticDescriptorImpl;
import org.apache.geode.internal.statistics.StatisticsTypeImpl;

public class StatisticsTypeFactoryImpl
implements StatisticsTypeFactory {
    @Immutable
    private static final StatisticsTypeFactoryImpl singleton = new StatisticsTypeFactoryImpl();
    private final HashMap statTypes = new HashMap();

    public static StatisticsTypeFactory singleton() {
        return singleton;
    }

    protected static void clear() {
        StatisticsTypeFactoryImpl.singleton.statTypes.clear();
    }

    private StatisticsTypeFactoryImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticsType addType(StatisticsType t) {
        StatisticsType result = t;
        HashMap hashMap = this.statTypes;
        synchronized (hashMap) {
            StatisticsType currentValue = this.findType(result.getName());
            if (currentValue == null) {
                this.statTypes.put(result.getName(), result);
            } else if (result.equals(currentValue)) {
                result = currentValue;
            } else {
                throw new IllegalArgumentException(String.format("Statistics type named %s already exists.", result.getName()));
            }
        }
        return result;
    }

    @Override
    public StatisticsType createType(String name, String description, StatisticDescriptor[] stats) {
        return this.addType(new StatisticsTypeImpl(name, description, stats));
    }

    @Override
    public StatisticsType findType(String name) {
        return (StatisticsType)this.statTypes.get(name);
    }

    @Override
    public StatisticsType[] createTypesFromXml(Reader reader) throws IOException {
        return StatisticsTypeImpl.fromXml(reader, this);
    }

    @Override
    public StatisticDescriptor createIntCounter(String name, String description, String units) {
        return this.createLongCounter(name, description, units);
    }

    @Override
    public StatisticDescriptor createLongCounter(String name, String description, String units) {
        return StatisticDescriptorImpl.createLongCounter(name, description, units, true);
    }

    @Override
    public StatisticDescriptor createDoubleCounter(String name, String description, String units) {
        return StatisticDescriptorImpl.createDoubleCounter(name, description, units, true);
    }

    @Override
    public StatisticDescriptor createIntGauge(String name, String description, String units) {
        return this.createLongGauge(name, description, units);
    }

    @Override
    public StatisticDescriptor createLongGauge(String name, String description, String units) {
        return StatisticDescriptorImpl.createLongGauge(name, description, units, false);
    }

    @Override
    public StatisticDescriptor createDoubleGauge(String name, String description, String units) {
        return StatisticDescriptorImpl.createDoubleGauge(name, description, units, false);
    }

    @Override
    public StatisticDescriptor createIntCounter(String name, String description, String units, boolean largerBetter) {
        return this.createLongCounter(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createLongCounter(String name, String description, String units, boolean largerBetter) {
        return StatisticDescriptorImpl.createLongCounter(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createDoubleCounter(String name, String description, String units, boolean largerBetter) {
        return StatisticDescriptorImpl.createDoubleCounter(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createIntGauge(String name, String description, String units, boolean largerBetter) {
        return this.createLongGauge(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createLongGauge(String name, String description, String units, boolean largerBetter) {
        return StatisticDescriptorImpl.createLongGauge(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createDoubleGauge(String name, String description, String units, boolean largerBetter) {
        return StatisticDescriptorImpl.createDoubleGauge(name, description, units, largerBetter);
    }
}

