/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor;

import java.util.Arrays;
import java.util.List;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.Executor;

public class AuthExecutor
implements Executor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the AUTH command is \"AUTH password\""));
            return;
        }
        byte[] password = context.getAuthPassword();
        if (password == null) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Attempting to authenticate when no password has been set"));
            return;
        }
        boolean correct = Arrays.equals(commandElems.get(1), password);
        if (correct) {
            context.setAuthenticationVerified();
            command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), "OK"));
        } else {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Attemping to authenticate with an invalid password"));
        }
    }
}

