/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.util.List;
import java.util.Map;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.redis.internal.AutoCloseableLock;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.hash.HashExecutor;

public class HLenExecutor
extends HashExecutor {
    private final int NOT_EXISTS = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        int size;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the HLEN command is \"HLEN key\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        try (AutoCloseableLock regionLock = this.withRegionLock(context, key);){
            Map<ByteArrayWrapper, ByteArrayWrapper> map = this.getMap(context, key);
            if (map == null) {
                command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
                return;
            }
            size = map.size();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Thread interrupted."));
            return;
        }
        catch (TimeoutException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Timeout acquiring lock. Please try again."));
            return;
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), size));
    }
}

