/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import com.github.davidmoten.geo.LatLong;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.GeoCoder;
import org.apache.geode.redis.internal.executor.sortedset.GeoSortedSetExecutor;

public class GeoPosExecutor
extends GeoSortedSetExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        ByteArrayWrapper key = command.getKey();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the GEOPOS command is \"GEOPOS key member [member...]\""));
            return;
        }
        ArrayList<LatLong> positions = new ArrayList<LatLong>();
        Region<ByteArrayWrapper, ByteArrayWrapper> keyRegion = this.getRegion(context, key);
        for (int i = 2; i < commandElems.size(); ++i) {
            byte[] member = commandElems.get(i);
            ByteArrayWrapper hashWrapper = (ByteArrayWrapper)keyRegion.get((Object)new ByteArrayWrapper(member));
            if (hashWrapper != null) {
                positions.add(GeoCoder.geoPos(hashWrapper.toString()));
                continue;
            }
            positions.add(null);
        }
        this.respondGeoCoordinates(command, context, positions);
    }
}

