/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.redis.internal.AutoCloseableLock;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RegionProvider;
import org.apache.geode.redis.internal.executor.string.StringExecutor;

public class DecrExecutor
extends StringExecutor {
    private final String ERROR_VALUE_NOT_USABLE = "The value at this key cannot be decremented numerically";
    private final String ERROR_OVERFLOW = "This decrementation cannot be performed due to overflow";
    private final byte[] INIT_VALUE_BYTES = Coder.stringToBytes("-1");
    private final int INIT_VALUE_INT = -1;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        long value;
        List<byte[]> commandElems = command.getProcessedCommand();
        RegionProvider rC = context.getRegionProvider();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = rC.getStringsRegion();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the DECR command is \"DECR key\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkAndSetDataType(key, context);
        try (AutoCloseableLock regionLock = this.withRegionLock(context, key);){
            ByteArrayWrapper valueWrapper = (ByteArrayWrapper)r.get((Object)key);
            if (valueWrapper == null) {
                byte[] newValue = this.INIT_VALUE_BYTES;
                r.put((Object)key, (Object)new ByteArrayWrapper(newValue));
                command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), -1));
                return;
            }
            String stringValue = valueWrapper.toString();
            try {
                value = Long.parseLong(stringValue);
            }
            catch (NumberFormatException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The value at this key cannot be decremented numerically"));
                if (regionLock != null) {
                    if (var10_10 != null) {
                        try {
                            regionLock.close();
                        }
                        catch (Throwable throwable) {
                            var10_10.addSuppressed(throwable);
                        }
                    } else {
                        regionLock.close();
                    }
                }
                return;
            }
            if (value == Long.MIN_VALUE) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "This decrementation cannot be performed due to overflow"));
                return;
            }
            stringValue = "" + --value;
            r.put((Object)key, (Object)new ByteArrayWrapper(Coder.stringToBytes(stringValue)));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Thread interrupted."));
            return;
        }
        catch (TimeoutException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Timeout acquiring lock. Please try again."));
            return;
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), value));
    }
}

