/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal.locator.wan;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.cache.client.internal.locator.wan.LocatorMembershipListener;
import org.apache.geode.internal.CopyOnWriteHashSet;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;

public class LocatorHelper {
    public static final Object locatorObject = new Object();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean addLocator(int distributedSystemId, DistributionLocatorId locator, LocatorMembershipListener locatorListener, DistributionLocatorId sourceLocator) {
        ConcurrentHashMap allLocatorsInfo = (ConcurrentHashMap)locatorListener.getAllLocatorsInfo();
        CopyOnWriteHashSet locatorsSet = new CopyOnWriteHashSet();
        locatorsSet.add(locator);
        Set existingValue = allLocatorsInfo.putIfAbsent(distributedSystemId, locatorsSet);
        if (existingValue != null) {
            if (existingValue.contains(locator)) return false;
            existingValue.add(locator);
            LocatorHelper.addServerLocator(distributedSystemId, locatorListener, locator);
            locatorListener.locatorJoined(distributedSystemId, locator, sourceLocator);
            return true;
        } else {
            LocatorHelper.addServerLocator(distributedSystemId, locatorListener, locator);
            locatorListener.locatorJoined(distributedSystemId, locator, sourceLocator);
        }
        return true;
    }

    private static void addServerLocator(Integer distributedSystemId, LocatorMembershipListener locatorListener, DistributionLocatorId locator) {
        ConcurrentHashMap allServerLocatorsInfo = (ConcurrentHashMap)locatorListener.getAllServerLocatorsInfo();
        CopyOnWriteHashSet locatorsSet = new CopyOnWriteHashSet();
        locatorsSet.add(locator.toString());
        Set existingValue = allServerLocatorsInfo.putIfAbsent(distributedSystemId, locatorsSet);
        if (existingValue != null && !existingValue.contains(locator.toString())) {
            existingValue.add(locator.toString());
        }
    }

    public static boolean addExchangedLocators(Map<Integer, Set<DistributionLocatorId>> locators, LocatorMembershipListener locatorListener) {
        ConcurrentHashMap allLocators = (ConcurrentHashMap)locatorListener.getAllLocatorsInfo();
        if (!allLocators.equals(locators)) {
            for (Map.Entry<Integer, Set<DistributionLocatorId>> entry : locators.entrySet()) {
                Set existingValue = allLocators.putIfAbsent(entry.getKey(), new CopyOnWriteHashSet<DistributionLocatorId>(entry.getValue()));
                if (existingValue != null) {
                    Set localLocators = (Set)allLocators.get(entry.getKey());
                    if (localLocators.equals(entry.getValue())) continue;
                    entry.getValue().removeAll(localLocators);
                    for (DistributionLocatorId locator : entry.getValue()) {
                        localLocators.add(locator);
                        LocatorHelper.addServerLocator(entry.getKey(), locatorListener, locator);
                        locatorListener.locatorJoined(entry.getKey(), locator, null);
                    }
                    continue;
                }
                for (DistributionLocatorId locator : entry.getValue()) {
                    LocatorHelper.addServerLocator(entry.getKey(), locatorListener, locator);
                    locatorListener.locatorJoined(entry.getKey(), locator, null);
                }
            }
            return true;
        }
        return false;
    }
}

