/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.api;

import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.api.MembershipConfig;
import org.apache.geode.distributed.internal.membership.api.MembershipConfigurationException;
import org.apache.geode.distributed.internal.membership.api.MembershipLocator;
import org.apache.geode.distributed.internal.membership.api.MembershipLocatorStatistics;
import org.apache.geode.distributed.internal.membership.gms.MembershipLocatorBuilderImpl;
import org.apache.geode.distributed.internal.tcpserver.HostAddress;
import org.apache.geode.distributed.internal.tcpserver.ProtocolChecker;
import org.apache.geode.distributed.internal.tcpserver.TcpHandler;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreator;
import org.apache.geode.internal.serialization.DSFIDSerializer;

public interface MembershipLocatorBuilder<ID extends MemberIdentifier> {
    public MembershipLocatorBuilder<ID> setPort(int var1);

    public MembershipLocatorBuilder<ID> setBindAddress(HostAddress var1);

    public MembershipLocatorBuilder<ID> setConfig(MembershipConfig var1);

    public MembershipLocatorBuilder<ID> setProtocolChecker(ProtocolChecker var1);

    public MembershipLocatorBuilder<ID> setFallbackHandler(TcpHandler var1);

    public MembershipLocatorBuilder<ID> setLocatorsAreCoordinators(boolean var1);

    public MembershipLocatorBuilder<ID> setLocatorStats(MembershipLocatorStatistics var1);

    public MembershipLocator<ID> create() throws UnknownHostException, MembershipConfigurationException;

    public static <ID extends MemberIdentifier> MembershipLocatorBuilder<ID> newLocatorBuilder(TcpSocketCreator socketCreator, DSFIDSerializer serializer, Path workingDirectory, Supplier<ExecutorService> executorServiceSupplier) {
        return new MembershipLocatorBuilderImpl(socketCreator, serializer, workingDirectory, executorServiceSupplier);
    }
}

