/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.directory;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.geode.cache.lucene.internal.directory.FileIndexInput;
import org.apache.geode.cache.lucene.internal.filesystem.File;
import org.apache.geode.cache.lucene.internal.filesystem.FileSystem;
import org.apache.geode.cache.lucene.internal.filesystem.FileSystemStats;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.apache.lucene.store.SingleInstanceLockFactory;

public class RegionDirectory
extends BaseDirectory {
    private final FileSystem fs;

    public RegionDirectory(Map fileAndChunkRegion, FileSystemStats stats) {
        super(new SingleInstanceLockFactory());
        this.fs = new FileSystem(fileAndChunkRegion, stats);
    }

    @Override
    public String[] listAll() throws IOException {
        this.ensureOpen();
        Object[] array = this.fs.listFileNames().toArray(new String[0]);
        Arrays.sort(array);
        return array;
    }

    @Override
    public void deleteFile(String name) throws IOException {
        this.ensureOpen();
        this.fs.deleteFile(name);
    }

    @Override
    public long fileLength(String name) throws IOException {
        this.ensureOpen();
        return this.fs.getFile(name).getLength();
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        File file = this.fs.createFile(name);
        OutputStream out = file.getOutputStream();
        return new OutputStreamIndexOutput(name, name, out, 1000);
    }

    @Override
    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
        String name = prefix + "_temp_" + UUID.randomUUID() + suffix;
        File file = this.fs.createTemporaryFile(name);
        OutputStream out = file.getOutputStream();
        return new OutputStreamIndexOutput(name, name, out, 1000);
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
        this.ensureOpen();
    }

    @Override
    public void syncMetaData() throws IOException {
        this.ensureOpen();
    }

    @Override
    public void rename(String source, String dest) throws IOException {
        this.ensureOpen();
        this.fs.renameFile(source, dest);
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        File file = this.fs.getFile(name);
        return new FileIndexInput(name, file);
    }

    @Override
    public void close() throws IOException {
        this.isOpen = false;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }
}

