/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.xml;

import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.xml.LuceneIndexCreation;
import org.apache.geode.internal.cache.xmlcache.CacheXmlGenerator;
import org.apache.geode.internal.cache.xmlcache.XmlGenerator;
import org.apache.geode.internal.cache.xmlcache.XmlGeneratorUtils;
import org.apache.lucene.analysis.Analyzer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class LuceneIndexXmlGenerator
implements XmlGenerator<Region<?, ?>> {
    private static final AttributesImpl EMPTY = new AttributesImpl();
    private final LuceneIndexCreation index;

    public LuceneIndexXmlGenerator(LuceneIndexCreation index) {
        this.index = index;
    }

    public String getNamespaceUri() {
        return "http://geode.apache.org/schema/lucene";
    }

    public void generate(CacheXmlGenerator cacheXmlGenerator) throws SAXException {
        ContentHandler handler = cacheXmlGenerator.getContentHandler();
        handler.startPrefixMapping("lucene", "http://geode.apache.org/schema/lucene");
        AttributesImpl attr = new AttributesImpl();
        XmlGeneratorUtils.addAttribute((AttributesImpl)attr, (String)"name", (Object)this.index.getName());
        XmlGeneratorUtils.startElement((ContentHandler)handler, (String)"lucene", (String)"index", (AttributesImpl)attr);
        for (String field : this.index.getFieldNames()) {
            AttributesImpl fieldAttr = new AttributesImpl();
            XmlGeneratorUtils.addAttribute((AttributesImpl)fieldAttr, (String)"name", (Object)field);
            Analyzer analyzer = this.index.getFieldAnalyzers().get(field);
            if (analyzer != null) {
                XmlGeneratorUtils.addAttribute((AttributesImpl)fieldAttr, (String)"analyzer", (Object)analyzer.getClass().getName());
            }
            XmlGeneratorUtils.emptyElement((ContentHandler)handler, (String)"lucene", (String)"field", (AttributesImpl)fieldAttr);
        }
        LuceneSerializer serializer = this.index.getLuceneSerializer();
        if (serializer != null) {
            XmlGeneratorUtils.startElement((ContentHandler)handler, (String)"lucene", (String)"serializer", (AttributesImpl)EMPTY);
            XmlGeneratorUtils.addDeclarable((ContentHandler)handler, (Declarable)serializer);
            XmlGeneratorUtils.endElement((ContentHandler)handler, (String)"lucene", (String)"serializer");
        }
        XmlGeneratorUtils.endElement((ContentHandler)handler, (String)"lucene", (String)"index");
    }
}

