/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.jetbrains.annotations.NotNull;

public class CommitOp {
    public static TXCommitMessage execute(ExecutablePool pool, int txId) {
        CommitOpImpl op = new CommitOpImpl(txId);
        pool.execute(op);
        return op.getTXCommitMessageResponse();
    }

    private CommitOp() {
    }

    private static class CommitOpImpl
    extends AbstractOp {
        private final int txId;
        private TXCommitMessage tXCommitMessageResponse = null;

        public CommitOpImpl(int txId) {
            super(85, 1);
            this.getMessage().setTransactionId(txId);
            this.txId = txId;
        }

        public TXCommitMessage getTXCommitMessageResponse() {
            return this.tXCommitMessageResponse;
        }

        public String toString() {
            return "TXCommit(txId=" + this.txId + ")";
        }

        @Override
        protected Object processResponse(@NotNull Message msg) throws Exception {
            TXCommitMessage rcs = (TXCommitMessage)this.processObjResponse(msg, "commit");
            assert (rcs != null) : "TxCommit response was null";
            this.tXCommitMessageResponse = rcs;
            return rcs;
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().clearMessageHasSecurePartFlag();
            this.getMessage().send(false);
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 2;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startCommit();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endCommitSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endCommit(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

