/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.proxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Properties;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.client.SocketFactory;
import org.apache.geode.cache.client.proxy.SniProxySocket;

public class SniProxySocketFactory
implements SocketFactory,
Declarable {
    private String hostname;
    private int port;

    public SniProxySocketFactory() {
    }

    public SniProxySocketFactory(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    @Override
    public void initialize(Cache cache, Properties properties) {
        this.hostname = properties.getProperty("hostname");
        String portString = properties.getProperty("port", "10334");
        this.port = Integer.parseInt(portString);
    }

    @Override
    public Socket createSocket() throws IOException {
        return new SniProxySocket(new InetSocketAddress(this.hostname, this.port));
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }
}

