/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.geode.cache.query.CqResults;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.internal.types.CollectionTypeImpl;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.query.types.StructType;
import org.apache.geode.internal.cache.CachePerfStats;

public abstract class Bag<E>
extends AbstractCollection<E>
implements CqResults<E> {
    protected ObjectType elementType;
    protected int size = 0;
    protected int numNulls = 0;
    private int limit = -1;
    boolean hasLimitIterator = false;
    final Object limitLock = new Object();

    public Bag() {
    }

    public Bag(boolean ignored) {
    }

    public Bag(CachePerfStats stats) {
    }

    Bag(Collection c, CachePerfStats stats) {
        this(stats);
        for (Object o : c) {
            this.add(o);
        }
    }

    Bag(SelectResults sr, CachePerfStats stats) {
        this((Collection)sr, stats);
        this.setElementType(sr.getCollectionType().getElementType());
    }

    Bag(ObjectType elementType, CachePerfStats stats) {
        this(stats);
        this.setElementType(elementType);
    }

    @Override
    public void setElementType(ObjectType elementType) {
        if (elementType instanceof StructType) {
            throw new IllegalArgumentException("This collection does not support struct elements");
        }
        this.elementType = elementType;
    }

    @Override
    public List asList() {
        return new ArrayList(this);
    }

    @Override
    public Set asSet() {
        return new SetView();
    }

    @Override
    public CollectionType getCollectionType() {
        return new CollectionTypeImpl(Collection.class, this.elementType);
    }

    @Override
    public abstract boolean isModifiable();

    @Override
    public int occurrences(Object element) {
        if (this.hasLimitIterator) {
            int count = 0;
            boolean encounteredObject = false;
            for (Object v : this) {
                if (element == null ? v == null : element.equals(v)) {
                    ++count;
                    encounteredObject = true;
                    continue;
                }
                if (!encounteredObject) continue;
                break;
            }
            return count;
        }
        if (element == null) {
            return this.numNulls;
        }
        return this.mapGet(element);
    }

    protected abstract int mapGet(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator iterator() {
        if (this.hasLimitIterator) {
            Object object = this.limitLock;
            synchronized (object) {
                return new LimitBagIterator();
            }
        }
        return new BagIterator();
    }

    @Override
    public boolean contains(Object element) {
        if (this.hasLimitIterator) {
            return super.contains(element);
        }
        if (element == null) {
            return this.numNulls > 0;
        }
        return this.mapContainsKey(element);
    }

    protected abstract boolean mapContainsKey(Object var1);

    @Override
    public boolean add(Object element) {
        if (this.limit > -1) {
            throw new UnsupportedOperationException("Addition to the SelectResults not allowed as the query result is constrained by LIMIT");
        }
        if (element == null) {
            ++this.numNulls;
        } else {
            int count = this.mapGet(element);
            this.mapPut(element, count + 1);
        }
        ++this.size;
        assert (this.size >= 0) : this.size;
        return true;
    }

    protected abstract void mapPut(Object var1, int var2);

    public int addAndGetOccurence(Object element) {
        int occurrence;
        if (element == null) {
            ++this.numNulls;
            occurrence = this.numNulls;
        } else {
            occurrence = this.mapGet(element);
            this.mapPut(element, ++occurrence);
        }
        ++this.size;
        assert (this.size >= 0) : this.size;
        return occurrence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        if (this.hasLimitIterator) {
            Object object = this.limitLock;
            synchronized (object) {
                return this.limit;
            }
        }
        return this.size;
    }

    protected abstract int mapSize();

    @Override
    public boolean remove(Object element) {
        if (this.hasLimitIterator) {
            return super.remove(element);
        }
        if (element == null) {
            if (this.numNulls > 0) {
                --this.numNulls;
                --this.size;
                assert (this.size >= 0) : this.size;
                return true;
            }
            return false;
        }
        int count = this.mapGet(element);
        if (count == 0) {
            return false;
        }
        if (count == 1) {
            this.mapRemove(element);
        } else {
            this.mapPut(element, --count);
        }
        --this.size;
        assert (this.size >= 0) : this.size;
        return true;
    }

    protected abstract int mapRemove(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.mapClear();
        this.numNulls = 0;
        this.size = 0;
        if (this.hasLimitIterator) {
            Object object = this.limitLock;
            synchronized (object) {
                this.limit = 0;
            }
        }
    }

    protected abstract void mapClear();

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Bag)) {
            return false;
        }
        Bag otherBag = (Bag)o;
        return this.size == otherBag.size && this.elementType.equals(otherBag.elementType) && this.getMap().equals(otherBag.getMap()) && this.numNulls == otherBag.numNulls;
    }

    protected abstract Object getMap();

    @Override
    public int hashCode() {
        return this.mapHashCode();
    }

    protected abstract int mapHashCode();

    @Override
    public boolean addAll(Collection coll) {
        if (this.limit > -1) {
            throw new UnsupportedOperationException("Addition to the SelectResults not allowed as the query result is constrained by LIMIT");
        }
        return super.addAll(coll);
    }

    void writeNumNulls(DataOutput out) throws IOException {
        out.writeInt(this.numNulls);
    }

    void readNumNulls(DataInput in) throws IOException {
        this.numNulls = in.readInt();
    }

    void applyLimit(int limit) {
        this.limit = limit;
        if (this.limit > -1 && this.size > this.limit) {
            this.hasLimitIterator = true;
        }
    }

    protected boolean nullOutputAtBegining() {
        return true;
    }

    protected abstract boolean mapEmpty();

    protected abstract Iterator mapEntryIterator();

    protected abstract Iterator mapKeyIterator();

    protected abstract Object keyFromEntry(Object var1);

    protected abstract Integer valueFromEntry(Object var1);

    private void checkModifiablity() {
        if (!this.isModifiable()) {
            throw new UnsupportedOperationException("Collection unmodifiable");
        }
    }

    protected class LimitBagIterator
    extends BagIterator {
        private final int localLimit;
        private int currPos;

        public LimitBagIterator() {
            this.currPos = 0;
            this.localLimit = Bag.this.limit;
        }

        @Override
        public boolean hasNext() {
            return this.currPos < this.localLimit;
        }

        @Override
        public Object next() {
            if (this.currPos == this.localLimit) {
                throw new NoSuchElementException();
            }
            Object next = super.next();
            ++this.currPos;
            return next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.currPos == 0) {
                throw new IllegalStateException("next() must be called before remove()");
            }
            Object object = Bag.this.limitLock;
            synchronized (object) {
                super.remove();
                --Bag.this.limit;
            }
        }
    }

    class SetView
    extends AbstractSet {
        private int localLimit;

        SetView() {
            this.localLimit = Bag.this.limit;
        }

        @Override
        public Iterator iterator() {
            if (this.localLimit > -1) {
                return new LimitSetViewIterator();
            }
            return new SetViewIterator();
        }

        @Override
        public boolean add(Object o) {
            if (this.contains(o)) {
                return false;
            }
            return Bag.this.add(o);
        }

        @Override
        public void clear() {
            Bag.this.clear();
        }

        @Override
        public int size() {
            int calculatedSize = Bag.this.mapSize() + (Bag.this.numNulls > 0 ? 1 : 0);
            if (this.localLimit > -1) {
                return Math.min(this.localLimit, calculatedSize);
            }
            return calculatedSize;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return Bag.this.numNulls > 0;
            }
            return Bag.this.mapContainsKey(o);
        }

        @Override
        public boolean isEmpty() {
            if (this.localLimit == 0) {
                return true;
            }
            if (Bag.this.numNulls > 0) {
                return false;
            }
            return Bag.this.mapEmpty();
        }

        /*
         * Signature claims super is org.apache.geode.cache.query.internal.Bag$SetView.SetViewIterator, not org.apache.geode.cache.query.internal.Bag$SetView$SetViewIterator - discarding signature.
         */
        class LimitSetViewIterator
        extends SetViewIterator {
            private int currPos;
            private Object currentKey;

            LimitSetViewIterator() {
                this.currPos = 0;
            }

            @Override
            public Object next() {
                if (this.currPos == SetView.this.localLimit) {
                    throw new NoSuchElementException();
                }
                this.currentKey = super.next();
                ++this.currPos;
                return this.currentKey;
            }

            @Override
            public boolean hasNext() {
                return this.currPos < SetView.this.localLimit && super.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                if (this.currPos == 0) {
                    throw new IllegalStateException("next() must be called before remove()");
                }
                Object object = Bag.this.limitLock;
                synchronized (object) {
                    if (this.currentIsNull) {
                        Bag.this.limit = Bag.this.limit - Bag.this.numNulls;
                        Bag.this.numNulls = 0;
                        SetView.this.localLimit--;
                    } else {
                        int count = Bag.this.mapRemove(this.currentKey);
                        assert (count != 0) : "Attempted to remove an element that was not in the map.";
                        Bag.this.limit = Bag.this.limit - count;
                        SetView.this.localLimit--;
                    }
                }
            }
        }

        public class SetViewIterator
        implements Iterator {
            boolean emitNull;
            final Iterator it;
            boolean currentIsNull;

            public SetViewIterator() {
                this.emitNull = Bag.this.numNulls > 0;
                this.it = Bag.this.mapKeyIterator();
                this.currentIsNull = false;
            }

            public Object next() {
                if (this.emitNull) {
                    this.emitNull = false;
                    this.currentIsNull = true;
                    return null;
                }
                Object key = this.it.next();
                this.currentIsNull = false;
                return key;
            }

            @Override
            public boolean hasNext() {
                if (this.emitNull) {
                    return true;
                }
                return this.it.hasNext();
            }

            @Override
            public void remove() {
                if (this.currentIsNull) {
                    Bag.this.numNulls = 0;
                } else {
                    this.it.remove();
                }
            }
        }
    }

    protected class BagIterator
    implements Iterator {
        private final Iterator iter;

        protected BagIterator() {
            this.iter = Bag.this.nullOutputAtBegining() ? new NullFirstBagIterator() : new NullLastBagIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        private class NullFirstBagIterator
        implements Iterator {
            final Iterator mapIterator;
            Object currentEntry;
            int currentDup;
            int dupLimit;

            private NullFirstBagIterator() {
                this.mapIterator = Bag.this.mapEntryIterator();
                this.currentEntry = null;
                this.currentDup = 0;
                this.dupLimit = Bag.this.numNulls;
            }

            @Override
            public boolean hasNext() {
                return this.mapIterator.hasNext() || this.currentDup < this.dupLimit;
            }

            public Object next() {
                if (this.currentDup < this.dupLimit) {
                    ++this.currentDup;
                    return this.currentEntry == null ? null : Bag.this.keyFromEntry(this.currentEntry);
                }
                this.currentEntry = this.mapIterator.next();
                this.dupLimit = Bag.this.valueFromEntry(this.currentEntry);
                this.currentDup = 1;
                return Bag.this.keyFromEntry(this.currentEntry);
            }

            @Override
            public void remove() {
                Bag.this.checkModifiablity();
                if (this.currentDup == 0) {
                    throw new IllegalStateException("next() must be called before remove()");
                }
                --this.dupLimit;
                assert (this.dupLimit >= 0) : this.dupLimit;
                if (this.currentEntry == null) {
                    Bag.this.numNulls = this.dupLimit;
                    assert (Bag.this.numNulls >= 0) : Bag.this.numNulls;
                } else if (this.dupLimit > 0) {
                    Bag.this.mapPut(Bag.this.keyFromEntry(this.currentEntry), this.dupLimit);
                } else {
                    this.mapIterator.remove();
                }
                --Bag.this.size;
                --this.currentDup;
                assert (Bag.this.size >= 0) : Bag.this.size;
                assert (this.currentDup >= 0) : this.currentDup;
            }
        }

        private class NullLastBagIterator
        implements Iterator {
            final Iterator mapIterator;
            Object currentEntry;
            int currentDup;
            int dupLimit;
            int nullDup;
            int nullDupLimit;

            private NullLastBagIterator() {
                this.mapIterator = Bag.this.mapEntryIterator();
                this.currentEntry = null;
                this.currentDup = 0;
                this.dupLimit = 0;
                this.nullDup = 0;
                this.nullDupLimit = Bag.this.numNulls;
            }

            @Override
            public boolean hasNext() {
                return this.mapIterator.hasNext() || this.currentDup < this.dupLimit || this.nullDup < this.nullDupLimit;
            }

            public Object next() {
                if (this.currentDup < this.dupLimit) {
                    ++this.currentDup;
                    return Bag.this.keyFromEntry(this.currentEntry);
                }
                if (this.mapIterator.hasNext()) {
                    this.currentEntry = this.mapIterator.next();
                    this.dupLimit = Bag.this.valueFromEntry(this.currentEntry);
                    this.currentDup = 1;
                    return Bag.this.keyFromEntry(this.currentEntry);
                }
                if (this.nullDup < this.nullDupLimit) {
                    ++this.nullDup;
                    return null;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported");
            }
        }
    }
}

