/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.index;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.IndexInvalidException;
import org.apache.geode.cache.query.internal.CompiledIteratorDef;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.index.IndexCreationHelper;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;

public class PrimaryKeyIndexCreationHelper
extends IndexCreationHelper {
    ExecutionContext context = null;
    final Region region;

    public PrimaryKeyIndexCreationHelper(String fromClause, String indexedExpression, String projectionAttributes, InternalCache cache, ExecutionContext externalContext, IndexManager imgr) throws IndexInvalidException {
        super(fromClause, projectionAttributes, cache);
        this.context = externalContext == null ? new ExecutionContext(null, cache) : externalContext;
        this.context.newScope(1);
        this.region = imgr.region;
        this.prepareFromClause(imgr);
        this.prepareIndexExpression(indexedExpression);
        this.prepareProjectionAttributes(projectionAttributes);
    }

    private void prepareFromClause(IndexManager imgr) throws IndexInvalidException {
        List<CompiledIteratorDef> list = this.compiler.compileFromClause(this.fromClause);
        if (list.size() > 1) {
            throw new IndexInvalidException("The fromClause for a Primary Key index should only have one iterator and the collection must be a Region Path only");
        }
        try {
            CompiledIteratorDef iterDef = list.get(0);
            if (iterDef.getCollectionExpr().getType() != 36) {
                throw new IndexInvalidException("The fromClause for a Primary Key index should be a Region Path only");
            }
            iterDef.computeDependencies(this.context);
            RuntimeIterator rIter = iterDef.getRuntimeIterator(this.context);
            String definition = rIter.getDefinition();
            this.canonicalizedIteratorDefinitions = new String[1];
            this.canonicalizedIteratorDefinitions[0] = definition;
            PartitionedRegion pr = this.context.getPartitionedRegion();
            this.canonicalizedIteratorNames = new String[1];
            String name = null;
            name = pr != null ? pr.getIndexManager().putCanonicalizedIteratorNameIfAbsent(definition) : imgr.putCanonicalizedIteratorNameIfAbsent(definition);
            rIter.setIndexInternalID(name);
            this.canonicalizedIteratorNames = new String[1];
            this.canonicalizedIteratorNames[0] = name;
            this.fromClause = definition + ' ' + name;
            this.context.bindIterator(rIter);
        }
        catch (IndexInvalidException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IndexInvalidException(e);
        }
    }

    private void prepareIndexExpression(String indexedExpression) throws IndexInvalidException {
        List<CompiledIteratorDef> indexedExprs = this.compiler.compileProjectionAttributes(indexedExpression);
        if (indexedExprs == null || indexedExprs.size() != 1) {
            throw new IndexInvalidException(String.format("Invalid indexed expressoion : ' %s '", indexedExpression));
        }
        CompiledValue expr = (CompiledValue)((Object[])indexedExprs.get(0))[1];
        if (expr.getType() == -4) {
            throw new IndexInvalidException(String.format("Invalid indexed expressoion : ' %s '", indexedExpression));
        }
        try {
            StringBuilder sb = new StringBuilder();
            expr.generateCanonicalizedExpression(sb, this.context);
            this.indexedExpression = sb.toString();
        }
        catch (Exception e) {
            throw new IndexInvalidException(String.format("Invalid indexed expressoion : ' %s ' %s", indexedExpression, e.getMessage()));
        }
    }

    private void prepareProjectionAttributes(String projectionAttributes) throws IndexInvalidException {
        if (projectionAttributes != null && !projectionAttributes.equals("*")) {
            throw new IndexInvalidException(String.format("Invalid projection attributes : ' %s '", projectionAttributes));
        }
        this.projectionAttributes = projectionAttributes;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public List getIterators() {
        return null;
    }

    @Override
    public CompiledValue getCompiledIndexedExpression() {
        return null;
    }
}

